/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.utils;

import com.craftaro.core.chat.ColorCode;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ColorUtils {
    private static final Map<ColorCode, ColorSet<Integer, Integer, Integer>> COLOR_MAP = new HashMap<ColorCode, ColorSet<Integer, Integer, Integer>>();

    public static ColorCode fromRGB(int r, int g, int b) {
        TreeMap closest = new TreeMap();
        COLOR_MAP.forEach((color, set) -> {
            int red = Math.abs(r - (Integer)set.getRed());
            int green = Math.abs(g - (Integer)set.getGreen());
            int blue = Math.abs(b - (Integer)set.getBlue());
            closest.put(red + green + blue, color);
        });
        return (ColorCode)((Object)closest.firstEntry().getValue());
    }

    static {
        COLOR_MAP.put(ColorCode.BLACK, new ColorSet<Integer, Integer, Integer>(0, 0, 0));
        COLOR_MAP.put(ColorCode.DARK_BLUE, new ColorSet<Integer, Integer, Integer>(0, 0, 170));
        COLOR_MAP.put(ColorCode.DARK_GREEN, new ColorSet<Integer, Integer, Integer>(0, 170, 0));
        COLOR_MAP.put(ColorCode.DARK_AQUA, new ColorSet<Integer, Integer, Integer>(0, 170, 170));
        COLOR_MAP.put(ColorCode.DARK_RED, new ColorSet<Integer, Integer, Integer>(170, 0, 0));
        COLOR_MAP.put(ColorCode.DARK_PURPLE, new ColorSet<Integer, Integer, Integer>(170, 0, 170));
        COLOR_MAP.put(ColorCode.GOLD, new ColorSet<Integer, Integer, Integer>(255, 170, 0));
        COLOR_MAP.put(ColorCode.GRAY, new ColorSet<Integer, Integer, Integer>(170, 170, 170));
        COLOR_MAP.put(ColorCode.DARK_GRAY, new ColorSet<Integer, Integer, Integer>(85, 85, 85));
        COLOR_MAP.put(ColorCode.BLUE, new ColorSet<Integer, Integer, Integer>(85, 85, 255));
        COLOR_MAP.put(ColorCode.GREEN, new ColorSet<Integer, Integer, Integer>(85, 255, 85));
        COLOR_MAP.put(ColorCode.AQUA, new ColorSet<Integer, Integer, Integer>(85, 255, 255));
        COLOR_MAP.put(ColorCode.RED, new ColorSet<Integer, Integer, Integer>(255, 85, 85));
        COLOR_MAP.put(ColorCode.LIGHT_PURPLE, new ColorSet<Integer, Integer, Integer>(255, 85, 255));
        COLOR_MAP.put(ColorCode.YELLOW, new ColorSet<Integer, Integer, Integer>(255, 255, 85));
        COLOR_MAP.put(ColorCode.WHITE, new ColorSet<Integer, Integer, Integer>(255, 255, 255));
    }

    private static class ColorSet<R, G, B> {
        R red;
        G green;
        B blue;

        ColorSet(R red, G green, B blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public R getRed() {
            return this.red;
        }

        public G getGreen() {
            return this.green;
        }

        public B getBlue() {
            return this.blue;
        }
    }
}

