/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.utils;

import com.craftaro.core.SongodaCore;
import com.craftaro.core.compatibility.ClassMapping;
import com.craftaro.core.compatibility.MethodMapping;
import com.craftaro.core.compatibility.ServerVersion;
import com.craftaro.core.utils.BlockUtils;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.Switch;
import org.bukkit.block.data.type.TrapDoor;

@Deprecated
public class BlockUtilsModern {
    private static Class<?> clazzCraftWorld;
    private static Class<?> clazzCraftBlock;
    private static Class<?> clazzLeverBlock;
    private static Class<?> clazzButtonBlock;
    private static Class<?> clazzPressurePlateBlock;
    private static Method craftWorld_getHandle;
    private static Method craftBlock_getNMS;
    private static Method craftBlock_getPostition;
    private static Method craftBlockData_getState;
    private static Method nmsLever_updateNeighbours;
    private static Method nmsButton_updateNeighbours;
    private static Method nmsPlate_updateNeighbours;
    private static Method nmsBlockData_getBlock;

    protected static void _updatePressurePlateModern(Block plate, int power) {
        Powerable p;
        BlockData blockData = plate.getBlockData();
        boolean update = false;
        if (blockData instanceof AnaloguePowerable) {
            AnaloguePowerable a = (AnaloguePowerable)blockData;
            int toPower = Math.min(a.getMaximumPower(), power);
            update = toPower != a.getPower();
            if (update) {
                a.setPower(toPower);
                plate.setBlockData((BlockData)a);
            }
        } else if (blockData instanceof Powerable && (update = (p = (Powerable)blockData).isPowered() != (power != 0))) {
            p.setPowered(power != 0);
            plate.setBlockData((BlockData)p);
        }
        if (update) {
            BlockUtilsModern._updateRedstoneNeighbours(plate);
        }
    }

    protected static void _toggleLeverModern(Block lever) {
        BlockData blockData = lever.getBlockData();
        if (blockData instanceof Switch) {
            Switch s;
            s.setPowered(!(s = (Switch)blockData).isPowered());
            lever.setBlockData((BlockData)s);
            BlockUtilsModern._updateRedstoneNeighbours(lever);
        }
    }

    protected static void _pressButtonModern(Block button) {
        BlockData blockData = button.getBlockData();
        if (blockData instanceof Switch) {
            Switch s = (Switch)blockData;
            s.setPowered(true);
            button.setBlockData((BlockData)s);
            BlockUtilsModern._updateRedstoneNeighbours(button);
        }
    }

    static void _releaseButtonModern(Block button) {
        BlockData blockData = button.getBlockData();
        if (blockData instanceof Switch) {
            Switch s = (Switch)blockData;
            s.setPowered(false);
            button.setBlockData((BlockData)s);
            BlockUtilsModern._updateRedstoneNeighbours(button);
        }
    }

    static void _updateRedstoneNeighbours(Block block) {
        try {
            Object cworld = clazzCraftWorld.cast(block.getWorld());
            Object mworld = craftWorld_getHandle.invoke(cworld, new Object[0]);
            Object cblock = clazzCraftBlock.cast(block);
            Object mblock = nmsBlockData_getBlock.invoke(craftBlock_getNMS.invoke(cblock, new Object[0]), new Object[0]);
            Object mpos = craftBlock_getPostition.invoke(cblock, new Object[0]);
            if (clazzLeverBlock.isAssignableFrom(mblock.getClass())) {
                Object mstate = craftBlockData_getState.invoke((Object)block.getBlockData(), new Object[0]);
                nmsLever_updateNeighbours.invoke(mblock, mstate, mworld, mpos);
            } else if (clazzButtonBlock.isAssignableFrom(mblock.getClass())) {
                Object mstate = craftBlockData_getState.invoke((Object)block.getBlockData(), new Object[0]);
                nmsButton_updateNeighbours.invoke(mblock, mstate, mworld, mpos);
            } else if (clazzPressurePlateBlock.isAssignableFrom(mblock.getClass())) {
                nmsPlate_updateNeighbours.invoke(mblock, mworld, mpos);
            } else {
                SongodaCore.getLogger().warning("Unknown redstone: " + mblock.getClass().getName());
            }
        }
        catch (Throwable ex) {
            Logger.getLogger(BlockUtilsModern.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected static void _toggleDoorStatesModern(boolean allowDoorToOpen, Block ... doors) {
        for (Block door : doors) {
            BlockData blockData;
            if (door == null || !((blockData = door.getBlockData()) instanceof Door)) continue;
            Door data = (Door)blockData;
            if (!allowDoorToOpen && !data.isOpen()) continue;
            if (data.getHalf() == Bisected.Half.TOP) {
                Block lowerHalf = door.getRelative(BlockFace.DOWN);
                if (lowerHalf.getBlockData() instanceof Door) {
                    Door lowerData = (Door)lowerHalf.getBlockData();
                    lowerData.setOpen(!data.isOpen());
                    lowerHalf.setBlockData((BlockData)lowerData);
                }
            } else {
                data.setOpen(!data.isOpen());
                door.setBlockData((BlockData)data);
            }
            door.getWorld().playEffect(door.getLocation(), Effect.DOOR_TOGGLE, 0);
        }
    }

    protected static Block _getDoubleDoorModern(Block block) {
        BlockData bd = block.getBlockData();
        Block door = null;
        if (bd instanceof Door) {
            Door d = (Door)bd;
            BlockFace face = d.getFacing();
            door = face.getModX() == 0 ? (d.getHinge() == Door.Hinge.RIGHT ? block.getRelative(face.getModZ(), 0, 0) : block.getRelative(-face.getModZ(), 0, 0)) : (d.getHinge() == Door.Hinge.RIGHT ? block.getRelative(0, 0, -face.getModX()) : block.getRelative(0, 0, face.getModX()));
        }
        return door != null && door.getBlockData() instanceof Door && ((Door)door.getBlockData()).getHinge() != ((Door)bd).getHinge() ? door : null;
    }

    protected static BlockFace _getDoorClosedDirectionModern(Block door) {
        BlockData bd;
        if (BlockUtils.DOORS.contains(door.getType())) {
            BlockData bd2 = door.getBlockData();
            if (bd2 instanceof Door) {
                BlockFace face;
                Door d = (Door)bd2;
                if (d.getHalf() == Bisected.Half.TOP) {
                    if ((door = door.getRelative(BlockFace.DOWN)).getBlockData() instanceof Door) {
                        d = (Door)door.getBlockData();
                    } else {
                        return null;
                    }
                }
                if ((face = d.getFacing()).getModX() == 0) {
                    return d.isOpen() ? BlockFace.EAST : BlockFace.SOUTH;
                }
                return d.isOpen() ? BlockFace.SOUTH : BlockFace.EAST;
            }
        } else if (BlockUtils.FENCE_GATES.contains(door.getType())) {
            BlockData bd3 = door.getBlockData();
            if (bd3 instanceof Gate) {
                Gate g = (Gate)bd3;
                BlockFace face = g.getFacing();
                if (face.getModX() == 0) {
                    return g.isOpen() ? BlockFace.EAST : BlockFace.SOUTH;
                }
                return g.isOpen() ? BlockFace.SOUTH : BlockFace.EAST;
            }
        } else if (BlockUtils.TRAP_DOORS.contains(door.getType()) && (bd = door.getBlockData()) instanceof TrapDoor) {
            TrapDoor t = (TrapDoor)bd;
            if (!t.isOpen()) {
                return BlockFace.UP;
            }
            return t.getFacing();
        }
        return null;
    }

    protected static boolean _isCropFullyGrown(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Ageable) {
            return ((Ageable)data).getAge() == ((Ageable)data).getMaximumAge();
        }
        return false;
    }

    protected static int _getMaxGrowthStage(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Ageable) {
            return ((Ageable)data).getMaximumAge();
        }
        return -1;
    }

    protected static int _getMaxGrowthStage(Material material) {
        BlockData data = material.createBlockData();
        if (data instanceof Ageable) {
            return ((Ageable)data).getMaximumAge();
        }
        return -1;
    }

    public static void _setGrowthStage(Block block, int stage) {
        BlockData data = block.getBlockData();
        if (data instanceof Ageable) {
            ((Ageable)data).setAge(Math.max(0, Math.min(stage, ((Ageable)data).getMaximumAge())));
            block.setBlockData(data);
        }
    }

    public static void _incrementGrowthStage(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Ageable) {
            int max = ((Ageable)data).getMaximumAge();
            int age = ((Ageable)data).getAge();
            if (age < max) {
                ((Ageable)data).setAge(age + 1);
                block.setBlockData(data);
            }
        }
    }

    public static void _resetGrowthStage(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Ageable) {
            ((Ageable)data).setAge(0);
            block.setBlockData(data);
        }
    }

    static {
        try {
            clazzCraftWorld = ClassMapping.CRAFT_WORLD.getClazz();
            clazzCraftBlock = ClassMapping.CRAFT_BLOCK.getClazz();
            craftWorld_getHandle = MethodMapping.CB_GENERIC__GET_HANDLE.getMethod(clazzCraftWorld);
            craftBlock_getPostition = MethodMapping.CB_BLOCK__GET_POSITION.getMethod(clazzCraftBlock);
            craftBlock_getNMS = MethodMapping.CB_BLOCK__GET_NMS.getMethod(clazzCraftBlock);
            Class<?> clazzBlockData = ClassMapping.BLOCK_BASE.getClazz("BlockData");
            nmsBlockData_getBlock = MethodMapping.I_BLOCK_DATA__GET_BLOCK.getMethod(clazzBlockData);
            Class<?> clazzCraftBlockData = ClassMapping.CRAFT_BLOCK_DATA.getClazz();
            craftBlockData_getState = MethodMapping.CB_BLOCK_DATA__GET_STATE.getMethod(clazzCraftBlockData);
            Class<?> clazzWorld = ClassMapping.WORLD.getClazz();
            Class<?> clazzBlockState = ClassMapping.I_BLOCK_DATA.getClazz();
            Class<?> clazzBlockPos = ClassMapping.BLOCK_POSITION.getClazz();
            clazzLeverBlock = ClassMapping.BLOCK_LEVER.getClazz();
            clazzButtonBlock = ClassMapping.BLOCK_BUTTON_ABSTRACT.getClazz();
            clazzPressurePlateBlock = ClassMapping.BLOCK_PRESSURE_PLATE_ABSTRACT.getClazz();
            nmsLever_updateNeighbours = clazzLeverBlock.getDeclaredMethod(ServerVersion.isServerVersionAbove(ServerVersion.V1_13) ? "e" : "b", clazzBlockState, clazzWorld, clazzBlockPos);
            nmsLever_updateNeighbours.setAccessible(true);
            nmsButton_updateNeighbours = clazzButtonBlock.getDeclaredMethod(ServerVersion.isServerVersionAbove(ServerVersion.V1_13) ? "f" : "c", clazzBlockState, clazzWorld, clazzBlockPos);
            nmsButton_updateNeighbours.setAccessible(true);
            nmsPlate_updateNeighbours = clazzPressurePlateBlock.getDeclaredMethod("a", clazzWorld, clazzBlockPos);
            nmsPlate_updateNeighbours.setAccessible(true);
        }
        catch (Throwable ex) {
            Logger.getLogger(BlockUtilsModern.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

