/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.thread;

import com.craftaro.core.SongodaPlugin;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class TaskScheduler {
    private final SongodaPlugin plugin;
    private final Map<TaskWrapper, Long> tasks = new ConcurrentHashMap<TaskWrapper, Long>();
    private BukkitRunnable runnable;
    private long delay;
    private long period;

    public TaskScheduler(SongodaPlugin plugin) {
        this.plugin = plugin;
        this.delay = 20L;
        this.period = 20L;
    }

    public TaskScheduler(SongodaPlugin plugin, long delay, long period) {
        this.plugin = plugin;
        this.delay = delay;
        this.period = period;
    }

    private void startScheduler() {
        if (this.runnable == null || this.runnable.isCancelled()) {
            this.runnable = new BukkitRunnable(){

                public void run() {
                    TaskScheduler.this.executeTasks();
                }
            };
            this.runnable.runTaskTimerAsynchronously((Plugin)this.plugin, this.delay, this.period);
        }
    }

    private void stopScheduler() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
    }

    private void executeTasks() {
        if (this.tasks.isEmpty()) {
            this.stopScheduler();
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<TaskWrapper, Long>> iterator = this.tasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TaskWrapper, Long> entry = iterator.next();
            if (entry.getValue() > currentTime) continue;
            final TaskWrapper taskWrapper = entry.getKey();
            if (taskWrapper.isAsync()) {
                new BukkitRunnable(){

                    public void run() {
                        taskWrapper.getTask().run();
                    }
                }.runTaskAsynchronously((Plugin)this.plugin);
            } else {
                new BukkitRunnable(){

                    public void run() {
                        taskWrapper.getTask().run();
                    }
                }.runTask((Plugin)this.plugin);
            }
            iterator.remove();
        }
    }

    public synchronized void addTask(Runnable task, long delay, boolean async) {
        this.tasks.put(new TaskWrapper(task, async), System.currentTimeMillis() + delay);
        this.startScheduler();
    }

    public synchronized void addTask(Runnable task, long delay) {
        this.addTask(task, delay, false);
    }

    private static class TaskWrapper {
        private final Runnable task;
        private final boolean async;

        public TaskWrapper(Runnable task, boolean async) {
            this.task = task;
            this.async = async;
        }

        public Runnable getTask() {
            return this.task;
        }

        public boolean isAsync() {
            return this.async;
        }
    }
}

