/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.nms.v1_17_R1.world.spawner;

import com.craftaro.core.nms.world.BBaseSpawner;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_17_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BBaseSpawnerImpl
implements BBaseSpawner {
    private final CreatureSpawner bukkitSpawner;
    private final MobSpawnerAbstract spawner;
    private static final Random spawnerFieldP = new Random();

    public BBaseSpawnerImpl(CreatureSpawner bukkitSpawner, MobSpawnerAbstract spawner) {
        this.bukkitSpawner = bukkitSpawner;
        this.spawner = spawner;
    }

    @Override
    public boolean isNearPlayer() {
        BlockPosition bPos = this.getBlockPosition();
        return this.getWorld().isPlayerNearby((double)bPos.getX() + 0.5, (double)bPos.getY() + 0.5, (double)bPos.getZ() + 0.5, (double)this.spawner.n);
    }

    @Override
    public void tick() {
        WorldServer world = this.getWorld();
        BlockPosition bPos = this.getBlockPosition();
        if (this.spawner.d == -1) {
            this.delay(world, bPos);
        }
        if (this.spawner.d > 0) {
            --this.spawner.d;
            return;
        }
        boolean flag = false;
        int i = 0;
        while (true) {
            block18: {
                Entity entity;
                block19: {
                    double d2;
                    if (i >= this.spawner.k) {
                        if (!flag) break;
                        this.delay(world, bPos);
                        break;
                    }
                    NBTTagCompound nbttagcompound = this.spawner.f.getEntity();
                    Optional optional = EntityTypes.a((NBTTagCompound)nbttagcompound);
                    if (optional.isEmpty()) {
                        this.delay(world, bPos);
                        return;
                    }
                    NBTTagList nbttaglist = nbttagcompound.getList("Pos", 6);
                    int j = nbttaglist.size();
                    double d0 = j >= 1 ? nbttaglist.h(0) : (double)bPos.getX() + (world.w.nextDouble() - world.w.nextDouble()) * (double)this.spawner.o + 0.5;
                    double d1 = j >= 2 ? nbttaglist.h(1) : (double)(bPos.getY() + world.w.nextInt(3) - 1);
                    double d = d2 = j >= 3 ? nbttaglist.h(2) : (double)bPos.getZ() + (world.w.nextDouble() - world.w.nextDouble()) * (double)this.spawner.o + 0.5;
                    if (!world.b(((EntityTypes)optional.get()).a(d0, d1, d2)) || !EntityPositionTypes.a((EntityTypes)((EntityTypes)optional.get()), (WorldAccess)world, (EnumMobSpawn)EnumMobSpawn.c, (BlockPosition)new BlockPosition(d0, d1, d2), (Random)world.getRandom())) break block18;
                    entity = EntityTypes.a((NBTTagCompound)nbttagcompound, (World)world, entity1 -> {
                        entity1.setPositionRotation(d0, d1, d2, entity1.getYRot(), entity1.getXRot());
                        return entity1;
                    });
                    if (entity == null) {
                        this.delay(world, bPos);
                        return;
                    }
                    int k = world.a(entity.getClass(), new AxisAlignedBB((double)bPos.getX(), (double)bPos.getY(), (double)bPos.getZ(), (double)(bPos.getX() + 1), (double)(bPos.getY() + 1), (double)(bPos.getZ() + 1)).g((double)this.spawner.o)).size();
                    if (k >= this.spawner.m) {
                        this.delay(world, bPos);
                        return;
                    }
                    entity.setPositionRotation(entity.locX(), entity.locY(), entity.locZ(), world.w.nextFloat() * 360.0f, 0.0f);
                    if (!(entity instanceof EntityInsentient)) break block19;
                    EntityInsentient entityinsentient = (EntityInsentient)entity;
                    if (!entityinsentient.a((GeneratorAccess)world, EnumMobSpawn.c) || !entityinsentient.a((IWorldReader)world)) break block18;
                    if (this.spawner.f.getEntity().e() == 1 && this.spawner.f.getEntity().hasKeyOfType("id", 8)) {
                        ((EntityInsentient)entity).prepare((WorldAccess)world, world.getDamageScaler(entity.getChunkCoordinates()), EnumMobSpawn.c, null, null);
                    }
                    if (entityinsentient.t.spigotConfig.nerfSpawnerMobs) {
                        entityinsentient.aware = false;
                    }
                }
                if (CraftEventFactory.callSpawnerSpawnEvent((Entity)entity, (BlockPosition)bPos).isCancelled()) {
                    Entity vehicle = entity.getVehicle();
                    if (vehicle != null) {
                        vehicle.die();
                    }
                    for (Entity passenger : entity.getAllPassengers()) {
                        passenger.die();
                    }
                } else {
                    if (!world.addAllEntitiesSafely(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.delay(world, bPos);
                        return;
                    }
                    world.triggerEffect(2004, bPos, 0);
                    if (entity instanceof EntityInsentient) {
                        ((EntityInsentient)entity).doSpawnEffect();
                    }
                    flag = true;
                }
            }
            ++i;
        }
    }

    private void delay(WorldServer world, BlockPosition bPos) {
        this.spawner.d = this.spawner.j <= this.spawner.i ? this.spawner.i : this.spawner.i + spawnerFieldP.nextInt(this.spawner.j - this.spawner.i);
        this.spawner.e.b(spawnerFieldP).ifPresent(mobSpawnerData -> this.spawner.setSpawnData((World)world, bPos, mobSpawnerData));
        this.spawner.a((World)world, this.getBlockPosition(), 1);
    }

    private WorldServer getWorld() {
        return ((CraftWorld)this.bukkitSpawner.getWorld()).getHandle();
    }

    private BlockPosition getBlockPosition() {
        return ((CraftCreatureSpawner)this.bukkitSpawner).getPosition();
    }
}

