/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.nms.v1_11_R1.world.spawner;

import com.craftaro.core.nms.ReflectionUtils;
import com.craftaro.core.nms.world.BBaseSpawner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.server.v1_11_R1.AxisAlignedBB;
import net.minecraft.server.v1_11_R1.BlockPosition;
import net.minecraft.server.v1_11_R1.ChunkRegionLoader;
import net.minecraft.server.v1_11_R1.Entity;
import net.minecraft.server.v1_11_R1.EntityInsentient;
import net.minecraft.server.v1_11_R1.EnumParticle;
import net.minecraft.server.v1_11_R1.MobSpawnerAbstract;
import net.minecraft.server.v1_11_R1.MobSpawnerData;
import net.minecraft.server.v1_11_R1.NBTTagCompound;
import net.minecraft.server.v1_11_R1.NBTTagList;
import net.minecraft.server.v1_11_R1.World;
import org.bukkit.craftbukkit.v1_11_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BBaseSpawnerImpl
implements BBaseSpawner {
    private static Method iMethod;
    private static Method hMethod;
    private final MobSpawnerAbstract spawner;

    public BBaseSpawnerImpl(MobSpawnerAbstract spawner) {
        this.spawner = spawner;
    }

    @Override
    public boolean isNearPlayer() throws InvocationTargetException, IllegalAccessException {
        return (Boolean)hMethod.invoke((Object)this.spawner, new Object[0]);
    }

    @Override
    public void tick() throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        BlockPosition blockposition = this.spawner.b();
        if (this.spawner.a().isClientSide) {
            double d0 = (float)blockposition.getX() + this.spawner.a().random.nextFloat();
            double d1 = (float)blockposition.getY() + this.spawner.a().random.nextFloat();
            double d2 = (float)blockposition.getZ() + this.spawner.a().random.nextFloat();
            this.spawner.a().addParticle(EnumParticle.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            this.spawner.a().addParticle(EnumParticle.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            if (this.spawner.spawnDelay > 0) {
                --this.spawner.spawnDelay;
            }
            double spawnerD = (Double)ReflectionUtils.getFieldValue(this.spawner, "d");
            ReflectionUtils.setFieldValue(this.spawner, "e", spawnerD);
            ReflectionUtils.setFieldValue(this.spawner, "d", (spawnerD + (double)(1000.0f / ((float)this.spawner.spawnDelay + 200.0f))) % 360.0);
            return;
        }
        if (this.spawner.spawnDelay == -1) {
            this.delay(this.spawner);
        }
        if (this.spawner.spawnDelay > 0) {
            --this.spawner.spawnDelay;
            return;
        }
        boolean flag = false;
        int i = 0;
        int spawnCount = (Integer)ReflectionUtils.getFieldValue(this.spawner, "spawnCount");
        int spawnRange = (Integer)ReflectionUtils.getFieldValue(this.spawner, "spawnRange");
        int maxNearbyEntities = (Integer)ReflectionUtils.getFieldValue(this.spawner, "maxNearbyEntities");
        MobSpawnerData spawnData = (MobSpawnerData)ReflectionUtils.getFieldValue(this.spawner, "spawnData");
        while (true) {
            double d5;
            double d4;
            int j;
            double d3;
            if (i >= spawnCount) {
                if (!flag) break;
                this.delay(this.spawner);
                break;
            }
            NBTTagCompound nbttagcompound = spawnData.b();
            NBTTagList nbttaglist = nbttagcompound.getList("Pos", 6);
            World world = this.spawner.a();
            Entity entity = ChunkRegionLoader.a((NBTTagCompound)nbttagcompound, (World)world, (double)(d3 = (j = nbttaglist.size()) >= 1 ? nbttaglist.e(0) : (double)blockposition.getX() + (world.random.nextDouble() - world.random.nextDouble()) * (double)spawnRange + 0.5), (double)(d4 = j >= 2 ? nbttaglist.e(1) : (double)(blockposition.getY() + world.random.nextInt(3) - 1)), (double)(d5 = j >= 3 ? nbttaglist.e(2) : (double)blockposition.getZ() + (world.random.nextDouble() - world.random.nextDouble()) * (double)spawnRange + 0.5), (boolean)false);
            if (entity == null) {
                return;
            }
            int k = world.a(entity.getClass(), new AxisAlignedBB((double)blockposition.getX(), (double)blockposition.getY(), (double)blockposition.getZ(), (double)(blockposition.getX() + 1), (double)(blockposition.getY() + 1), (double)(blockposition.getZ() + 1)).g((double)spawnRange)).size();
            if (k >= maxNearbyEntities) {
                this.delay(this.spawner);
                return;
            }
            EntityInsentient entityinsentient = entity instanceof EntityInsentient ? (EntityInsentient)entity : null;
            entity.setPositionRotation(entity.locX, entity.locY, entity.locZ, world.random.nextFloat() * 360.0f, 0.0f);
            if (entityinsentient == null || entityinsentient.cM() && entityinsentient.canSpawn()) {
                if (spawnData.b().d() == 1 && spawnData.b().hasKeyOfType("id", 8) && entity instanceof EntityInsentient) {
                    ((EntityInsentient)entity).prepare(world.D(new BlockPosition(entity)), null);
                }
                if (entity.world.spigotConfig.nerfSpawnerMobs) {
                    entity.fromMobSpawner = true;
                }
                if (!CraftEventFactory.callSpawnerSpawnEvent((Entity)entity, (BlockPosition)blockposition).isCancelled()) {
                    ChunkRegionLoader.a((Entity)entity, (World)world, (CreatureSpawnEvent.SpawnReason)CreatureSpawnEvent.SpawnReason.SPAWNER);
                    world.triggerEffect(2004, blockposition, 0);
                    if (entityinsentient != null) {
                        entityinsentient.doSpawnEffect();
                    }
                    flag = true;
                }
            }
            ++i;
        }
    }

    private void delay(MobSpawnerAbstract spawner) throws InvocationTargetException, IllegalAccessException {
        iMethod.invoke((Object)spawner, new Object[0]);
    }

    static {
        try {
            hMethod = MobSpawnerAbstract.class.getDeclaredMethod("h", new Class[0]);
            hMethod.setAccessible(true);
            iMethod = MobSpawnerAbstract.class.getDeclaredMethod("i", new Class[0]);
            iMethod.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
    }
}

