/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.nms;

import com.craftaro.core.compatibility.ServerVersion;
import com.craftaro.core.nms.NmsImplementations;
import com.craftaro.core.nms.UnsupportedServerVersionException;

public final class Nms {
    private static NmsImplementations cachedImplementation;

    public static NmsImplementations getImplementations() throws UnsupportedServerVersionException {
        if (cachedImplementation == null) {
            try {
                Class<?> implementationClazz = Class.forName(Nms.getImplementationClassName());
                cachedImplementation = (NmsImplementations)implementationClazz.getConstructors()[0].newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new UnsupportedServerVersionException(ex);
            }
        }
        return cachedImplementation;
    }

    private static String getImplementationClassName() {
        return String.format("com.craftaro.core.nms.%s.NmsImplementationsImpl", ServerVersion.getServerVersionString());
    }
}

