/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.lootables.loot;

import com.craftaro.core.SongodaCore;
import com.craftaro.core.lootables.loot.Drop;
import com.craftaro.ultimatestacker.api.UltimateStackerApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DropUtils {
    public static void processStackedDrop(LivingEntity entity, List<Drop> drops, EntityDeathEvent event) {
        int xpToDrop = event.getDroppedExp();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<Integer> xp = new ArrayList<Integer>();
        for (Drop drop : drops) {
            if (drop == null) continue;
            ItemStack droppedItem = drop.getItemStack();
            if (droppedItem != null) {
                droppedItem = droppedItem.clone();
                boolean success = false;
                for (ItemStack item : items) {
                    if (item.getType() != droppedItem.getType() || item.getDurability() != droppedItem.getDurability() || item.getAmount() + droppedItem.getAmount() > droppedItem.getMaxStackSize()) continue;
                    item.setAmount(item.getAmount() + droppedItem.getAmount());
                    success = true;
                    break;
                }
                if (!success) {
                    items.add(droppedItem);
                }
            }
            if (drop.getCommand() != null) {
                commands.add(drop.getCommand());
            }
            if (drop.getXp() == 0) continue;
            xp.add(drop.getXp());
        }
        event.getDrops().clear();
        if (!items.isEmpty()) {
            DropUtils.dropItems(items, event);
        } else if (!commands.isEmpty()) {
            DropUtils.runCommands(entity, commands);
        }
        Iterator<Drop> iterator = xp.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)((Object)iterator.next());
            xpToDrop += x;
        }
        event.setDroppedExp(xpToDrop);
    }

    private static void dropItems(List<ItemStack> items, EntityDeathEvent event) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)SongodaCore.getHijackedPlugin(), () -> DropUtils.dropItems(items, event));
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("UltimateStacker")) {
            ArrayList<StackedItem> stacks = new ArrayList<StackedItem>();
            int maxSize = UltimateStackerApi.getSettings().getMaxItemStackSize() - 64;
            for (ItemStack item : items) {
                StackedItem stack = stacks.stream().filter(stackedItem -> stackedItem.getItem().getType() == item.getType()).filter(stackedItem -> stackedItem.getAmount() < 0x3FFFFFFF).findFirst().orElse(null);
                if (stack == null) {
                    stacks.add(new StackedItem(item, item.getAmount()));
                    continue;
                }
                BigDecimal newAmount = BigDecimal.valueOf(stack.getAmount() + item.getAmount());
                while (newAmount.compareTo(BigDecimal.valueOf(maxSize)) > 0) {
                    newAmount = newAmount.subtract(BigDecimal.valueOf(maxSize));
                    stacks.add(new StackedItem(item, maxSize));
                }
                stack.setAmount(newAmount.intValue());
            }
            for (StackedItem stack : stacks) {
                UltimateStackerApi.getStackedItemManager().createStack(stack.getItemToDrop(), event.getEntity().getLocation(), stack.getAmount(), event.getEntity());
            }
            return;
        }
        event.getDrops().addAll(items);
    }

    private static void runCommands(LivingEntity entity, List<String> commands) {
        Bukkit.getScheduler().runTask((Plugin)SongodaCore.getHijackedPlugin(), () -> {
            for (String command : commands) {
                if (entity.getKiller() != null) {
                    command = command.replace("%player%", entity.getKiller().getName().replace("%x%", String.valueOf((int)entity.getLocation().getX())).replace("%y%", String.valueOf((int)entity.getLocation().getY())).replace("%z%", String.valueOf((int)entity.getLocation().getZ())));
                }
                if (command.contains("%player%")) continue;
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
        });
    }

    private static class StackedItem {
        private final ItemStack item;
        private int amount;

        public StackedItem(ItemStack item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        public Material getMaterial() {
            return this.item.getType();
        }

        public ItemStack getItem() {
            return this.item;
        }

        public ItemStack getItemToDrop() {
            this.item.setAmount(32);
            return this.item;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }
    }
}

