/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.lootables.gui;

import com.craftaro.core.chat.AdventureUtils;
import com.craftaro.core.compatibility.CompatibleMaterial;
import com.craftaro.core.gui.AnvilGui;
import com.craftaro.core.gui.Gui;
import com.craftaro.core.gui.GuiUtils;
import com.craftaro.core.gui.events.GuiClickEvent;
import com.craftaro.core.lootables.gui.GuiEnchantEditor;
import com.craftaro.core.lootables.gui.GuiEntityEditor;
import com.craftaro.core.lootables.gui.GuiLoreEditor;
import com.craftaro.core.lootables.loot.Loot;
import com.craftaro.core.lootables.loot.LootBuilder;
import com.craftaro.core.lootables.loot.LootManager;
import com.craftaro.core.utils.TextUtils;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.bukkit.entity.EntityType;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class GuiLootEditor
extends Gui {
    private final LootManager lootManager;
    private final Loot loot;
    private final Gui returnGui;

    public GuiLootEditor(LootManager lootManager, Loot loot, Gui returnGui) {
        super(6, returnGui);
        this.lootManager = lootManager;
        this.loot = loot;
        this.returnGui = returnGui;
        this.setDefaultItem(null);
        this.setTitle("Loot Editor");
        this.paint();
        this.setOnClose(event -> lootManager.saveLootables(false));
    }

    /*
     * WARNING - void declaration
     */
    public void paint() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setActionForRange(0, 0, 5, 9, null);
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_DOOR, TextUtils.formatText("&cBack"), new String[0]), event -> this.guiManager.showGUI(event.player, this.returnGui));
        this.setButton(9, GuiUtils.createButtonItem(this.loot.getMaterial() == null ? XMaterial.BARRIER : this.loot.getMaterial(), TextUtils.formatText("&7Current Material: &6" + (this.loot.getMaterial() != null ? this.loot.getMaterial().name() : "None")), TextUtils.formatText(Arrays.asList("", "&8Click to set the material to", "&8the material in your hand."))), event -> {
            ItemStack stack = event.player.getInventory().getItemInMainHand();
            this.loot.setMaterial(CompatibleMaterial.getMaterial(stack.getType()).get());
            this.paint();
        });
        this.setButton(10, GuiUtils.createButtonItem(XMaterial.PAPER, TextUtils.formatText("&7Name Override: &6" + (this.loot.getName() == null ? "None set" : this.loot.getName())), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                this.loot.setName(gui.getInputText().trim());
                this.paint();
                e.player.closeInventory();
            });
            this.guiManager.showGUI(event.player, gui);
            gui.setInput(GuiUtils.createButtonItem(XMaterial.PAPER, this.loot.getName(), new String[0]));
        });
        this.setButton(11, GuiUtils.createButtonItem(XMaterial.WRITABLE_BOOK, TextUtils.formatText("&7Lore Override:"), TextUtils.formatText(this.loot.getLore() == null ? Collections.singletonList("&6None set") : this.loot.getLore())), event -> this.guiManager.showGUI(event.player, new GuiLoreEditor(this.loot, (Gui)this)));
        ArrayList<String> enchantments = new ArrayList<String>();
        if (this.loot.getEnchants() != null) {
            for (Map.Entry<String, Integer> entry : this.loot.getEnchants().entrySet()) {
                enchantments.add("&6" + entry.getKey() + " " + entry.getValue());
            }
        }
        this.setButton(12, GuiUtils.createButtonItem(XMaterial.ENCHANTED_BOOK, TextUtils.formatText("&7Enchantments:"), TextUtils.formatText(enchantments.isEmpty() ? Collections.singletonList("&6None set") : enchantments)), event -> this.guiManager.showGUI(event.player, new GuiEnchantEditor(this.loot, (Gui)this)));
        this.setButton(13, GuiUtils.createButtonItem(this.loot.getBurnedMaterial() == null ? XMaterial.FIRE_CHARGE : this.loot.getBurnedMaterial(), TextUtils.formatText("&7Current Burned Material: &6" + (this.loot.getBurnedMaterial() == null ? "None" : this.loot.getBurnedMaterial().name())), TextUtils.formatText(Arrays.asList("", "&8Click to set the burned material to", "&8the material in your hand."))), event -> {
            ItemStack stack = event.player.getInventory().getItemInMainHand();
            this.loot.setBurnedMaterial(CompatibleMaterial.getMaterial(stack.getType()).get());
            this.paint();
        });
        this.setButton(14, GuiUtils.createButtonItem(XMaterial.CLOCK, TextUtils.formatText("&7Chance: &6" + this.loot.getChance()), TextUtils.formatText(Arrays.asList("", "&8Click to edit this loots", "&8drop chance."))), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                this.loot.setChance(Double.parseDouble(gui.getInputText()));
                this.paint();
                e.player.closeInventory();
            });
            gui.setInput(GuiUtils.createButtonItem(XMaterial.PAPER, String.valueOf(this.loot.getChance()), new String[0]));
            this.guiManager.showGUI(event.player, gui);
        });
        this.setButton(15, GuiUtils.createButtonItem(XMaterial.REDSTONE, TextUtils.formatText("&7Min Drop Amount: &6" + this.loot.getMin()), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                this.loot.setMin(Integer.parseInt(gui.getInputText()));
                this.paint();
                e.player.closeInventory();
            });
            gui.setInput(GuiUtils.createButtonItem(XMaterial.PAPER, String.valueOf(this.loot.getMin()), new String[0]));
            this.guiManager.showGUI(event.player, gui);
        });
        this.setButton(16, GuiUtils.createButtonItem(XMaterial.GLOWSTONE_DUST, TextUtils.formatText("&7Max Drop Amount: &6" + this.loot.getMax()), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                this.loot.setMax(Integer.parseInt(gui.getInputText()));
                this.paint();
                e.player.closeInventory();
            });
            gui.setInput(GuiUtils.createButtonItem(XMaterial.PAPER, String.valueOf(this.loot.getMax()), new String[0]));
            this.guiManager.showGUI(event.player, gui);
        });
        this.setButton(17, GuiUtils.createButtonItem(XMaterial.REDSTONE, TextUtils.formatText("&7Min Item Damage: &6" + this.loot.getDamageMin()), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                this.loot.setDamageMin(Integer.parseInt(gui.getInputText()));
                this.paint();
                e.player.closeInventory();
            });
            gui.setInput(GuiUtils.createButtonItem(XMaterial.PAPER, String.valueOf(this.loot.getDamageMin()), new String[0]));
            this.guiManager.showGUI(event.player, gui);
        });
        this.setButton(18, GuiUtils.createButtonItem(XMaterial.GLOWSTONE_DUST, TextUtils.formatText("&7Max Item Damage: &6" + this.loot.getDamageMax()), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                this.loot.setDamageMax(Integer.parseInt(gui.getInputText()));
                this.paint();
                e.player.closeInventory();
            });
            gui.setInput(GuiUtils.createButtonItem(XMaterial.PAPER, String.valueOf(this.loot.getDamageMax()), new String[0]));
            this.guiManager.showGUI(event.player, gui);
        });
        this.setButton(19, GuiUtils.createButtonItem(XMaterial.CHEST, TextUtils.formatText("&7Allow Looting Enchantment?: &6" + this.loot.isAllowLootingEnchant()), new String[0]), event -> {
            this.loot.setAllowLootingEnchant(!this.loot.isAllowLootingEnchant());
            this.paint();
            event.player.closeInventory();
        });
        this.setButton(20, GuiUtils.createButtonItem(XMaterial.REDSTONE, TextUtils.formatText("&7Min Child Loot Min: &6" + this.loot.getChildDropCountMin()), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                this.loot.setChildDropCountMin(Integer.parseInt(gui.getInputText()));
                this.paint();
                e.player.closeInventory();
            });
            gui.setInput(GuiUtils.createButtonItem(XMaterial.PAPER, String.valueOf(this.loot.getChildDropCountMin()), new String[0]));
            this.guiManager.showGUI(event.player, gui);
        });
        this.setButton(21, GuiUtils.createButtonItem(XMaterial.GLOWSTONE_DUST, TextUtils.formatText("&7Min Child Loot Max: &6" + this.loot.getChildDropCountMax()), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                this.loot.setChildDropCountMax(Integer.parseInt(gui.getInputText()));
                this.paint();
                e.player.closeInventory();
            });
            gui.setInput(GuiUtils.createButtonItem(XMaterial.PAPER, String.valueOf(this.loot.getChildDropCountMax()), new String[0]));
            this.guiManager.showGUI(event.player, gui);
        });
        ArrayList<String> entities = new ArrayList<String>();
        if (this.loot.getOnlyDropFor() != null) {
            for (EntityType entity : this.loot.getOnlyDropFor()) {
                entities.add("&6" + entity.name());
            }
        }
        this.setButton(22, GuiUtils.createButtonItem(XMaterial.ENCHANTED_BOOK, TextUtils.formatText("&7Only Drop For:"), TextUtils.formatText(entities)), event -> this.guiManager.showGUI(event.player, new GuiEntityEditor(this.loot, (Gui)this)));
        this.setButton(4, 0, GuiUtils.createButtonItem(XMaterial.LIME_DYE, TextUtils.formatText("&aCreate new Child Loot"), new String[0]), (GuiClickEvent event) -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(event1 -> {
                try {
                    this.loot.addChildLoots(new LootBuilder().setMaterial(XMaterial.valueOf(gui.getInputText().trim())).build());
                }
                catch (IllegalArgumentException ignore) {
                    event.player.sendMessage("That is not a valid material.");
                }
                event.player.closeInventory();
                this.paint();
            });
            gui.setTitle("Enter a material");
            this.guiManager.showGUI(event.player, gui);
        });
        int n = 45;
        for (Loot loot : this.loot.getChildLoot()) {
            void var3_7;
            ItemStack item = loot.getMaterial() == null ? XMaterial.BARRIER.parseItem() : GuiUtils.createButtonItem(loot.getMaterial(), null, Arrays.asList(AdventureUtils.formatComponent("&6Left click &7to edit"), AdventureUtils.formatComponent("&6Right click &7to destroy")));
            this.setButton((int)var3_7, item, event -> {
                if (event.clickType == ClickType.RIGHT) {
                    this.loot.removeChildLoot(loot);
                    this.paint();
                } else if (event.clickType == ClickType.LEFT) {
                    this.guiManager.showGUI(event.player, new GuiLootEditor(this.lootManager, loot, this));
                }
            });
            ++var3_7;
        }
    }
}

