/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.lootables.gui;

import com.craftaro.core.gui.AnvilGui;
import com.craftaro.core.gui.Gui;
import com.craftaro.core.gui.GuiUtils;
import com.craftaro.core.lootables.gui.GuiLootEditor;
import com.craftaro.core.lootables.loot.Loot;
import com.craftaro.core.utils.TextUtils;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractGuiListEditor
extends Gui {
    protected final Loot loot;
    private final Gui returnGui;

    public AbstractGuiListEditor(Loot loot, Gui returnGui) {
        super(1, returnGui);
        this.returnGui = returnGui;
        this.loot = loot;
        this.setDefaultItem(null);
        this.paint();
    }

    public void paint() {
        List<Object> lore = this.getData() == null ? new ArrayList() : this.getData();
        this.setButton(2, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText("&cBack"), new String[0]), event -> {
            this.guiManager.showGUI(event.player, this.returnGui);
            ((GuiLootEditor)this.returnGui).paint();
        });
        this.setButton(6, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText("&cBack"), new String[0]), event -> {
            this.guiManager.showGUI(event.player, this.returnGui);
            ((GuiLootEditor)this.returnGui).paint();
        });
        this.setButton(3, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText("&aAdd new line"), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                String validated = this.validate(gui.getInputText());
                if (validated != null) {
                    lore.add(validated);
                    this.updateData(lore);
                    e.player.closeInventory();
                    this.paint();
                }
            });
            gui.setTitle("Enter a new line");
            this.guiManager.showGUI(event.player, gui);
        });
        this.setItem(4, GuiUtils.createButtonItem(XMaterial.WRITABLE_BOOK, TextUtils.formatText("&9Lore:"), lore.isEmpty() ? TextUtils.formatText(Collections.singletonList("&cNo lore set...")) : TextUtils.formatText(lore)));
        this.setButton(5, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText("&cRemove the last line"), new String[0]), event -> {
            lore.remove(lore.size() - 1);
            this.updateData(lore);
            this.paint();
        });
    }

    protected abstract List<String> getData();

    protected abstract void updateData(List<String> var1);

    protected abstract String validate(String var1);
}

