/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.hooks.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

@Deprecated
public class WorldGuardRegionHandler {
    static boolean wgPlugin;
    static Object worldGuardPlugin;
    static boolean wg_v7;
    static boolean legacy_v60;
    static boolean legacy_v62;
    static boolean legacy_v5;
    static Method legacy_getRegionManager;
    static Method legacy_getApplicableRegions_Region;
    static Method legacy_getApplicableRegions_Location;
    static Constructor legacy_newProtectedCuboidRegion;
    static Class legacy_blockVectorClazz;
    static Constructor legacy_newblockVector;
    static Class legacy_VectorClazz;
    static Constructor legacy_newVectorClazz;
    static Method legacy_getApplicableRegions_Vector;

    static void init() {
        worldGuardPlugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
        wgPlugin = worldGuardPlugin != null;
        if (wgPlugin) {
            try {
                Class.forName("com.sk89q.worldguard.protection.flags.WeatherTypeFlag");
                wg_v7 = true;
            }
            catch (ClassNotFoundException ex) {
                try {
                    Class.forName("com.sk89q.worldguard.protection.flags.registry.SimpleFlagRegistry");
                    legacy_v62 = true;
                }
                catch (ClassNotFoundException ex2) {
                    try {
                        Class.forName("com.sk89q.worldguard.protection.flags.BuildFlag");
                        legacy_v60 = true;
                    }
                    catch (ClassNotFoundException ex3) {
                        try {
                            Class.forName("com.sk89q.worldguard.protection.flags.DefaultFlag");
                            legacy_v5 = true;
                        }
                        catch (ClassNotFoundException ex4) {
                            wgPlugin = false;
                        }
                    }
                }
            }
        }
        if (wgPlugin && (legacy_v62 || legacy_v60 || legacy_v5)) {
            try {
                if (legacy_getRegionManager == null) {
                    legacy_getRegionManager = worldGuardPlugin.getClass().getDeclaredMethod("getRegionManager", World.class);
                    legacy_getApplicableRegions_Region = RegionManager.class.getDeclaredMethod("getApplicableRegions", Class.forName("com.sk89q.worldguard.protection.regions.ProtectedRegion"));
                    legacy_getApplicableRegions_Location = RegionManager.class.getDeclaredMethod("getApplicableRegions", Location.class);
                    legacy_blockVectorClazz = Class.forName("com.sk89q.worldedit.BlockVector");
                    legacy_newblockVector = legacy_blockVectorClazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    legacy_newProtectedCuboidRegion = Class.forName("com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion").getConstructor(String.class, legacy_blockVectorClazz, legacy_blockVectorClazz);
                    legacy_VectorClazz = Class.forName("com.sk89q.worldedit.Vector");
                    legacy_newVectorClazz = legacy_VectorClazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    legacy_getApplicableRegions_Vector = RegionManager.class.getDeclaredMethod("getApplicableRegions", legacy_VectorClazz);
                }
            }
            catch (Exception ex) {
                Bukkit.getServer().getLogger().log(Level.WARNING, "Could not load WorldGuard methods for " + (legacy_v62 ? "6.2" : (legacy_v60 ? "6.0" : "5")));
                wgPlugin = false;
            }
        }
    }

    public static List<String> getRegionNames(Chunk c) {
        if (worldGuardPlugin == null) {
            WorldGuardRegionHandler.init();
        }
        if (!wgPlugin || c == null) {
            return Collections.emptyList();
        }
        if (legacy_v62 || legacy_v60 || legacy_v5) {
            return WorldGuardRegionHandler.getRegionNamesLegacy(c);
        }
        RegionManager worldManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)c.getWorld()));
        if (worldManager == null) {
            return Collections.emptyList();
        }
        ProtectedCuboidRegion chunkRegion = new ProtectedCuboidRegion("__TEST__", BlockVector3.at((int)(c.getX() << 4), (int)c.getWorld().getMaxHeight(), (int)(c.getZ() << 4)), BlockVector3.at((int)((c.getX() << 4) + 15), (int)0, (int)((c.getZ() << 4) + 15)));
        ApplicableRegionSet set = worldManager.getApplicableRegions((ProtectedRegion)chunkRegion);
        ArrayList<String> regions = new ArrayList<String>();
        ArrayList<String> parentNames = new ArrayList<String>();
        for (ProtectedRegion region : set) {
            String id = region.getId();
            regions.add(id);
            for (ProtectedRegion parent = region.getParent(); parent != null; parent = parent.getParent()) {
                parentNames.add(parent.getId());
            }
        }
        regions.removeAll(parentNames);
        return regions;
    }

    private static List<String> getRegionNamesLegacy(Chunk c) {
        try {
            Object worldManager = legacy_getRegionManager.invoke(worldGuardPlugin, c.getWorld());
            if (worldManager == null) {
                return null;
            }
            Object chunkRegion = legacy_newProtectedCuboidRegion.newInstance("__TEST__", legacy_newblockVector.newInstance(c.getX() << 4, c.getWorld().getMaxHeight(), c.getZ() << 4), legacy_newblockVector.newInstance((c.getX() << 4) + 15, 0, (c.getZ() << 4) + 15));
            Iterable set = (Iterable)legacy_getApplicableRegions_Region.invoke(worldManager, chunkRegion);
            ArrayList<String> regions = new ArrayList<String>();
            ArrayList<String> parentNames = new ArrayList<String>();
            for (ProtectedRegion region : set) {
                String id = region.getId();
                regions.add(id);
                for (ProtectedRegion parent = region.getParent(); parent != null; parent = parent.getParent()) {
                    parentNames.add(parent.getId());
                }
            }
            regions.removeAll(parentNames);
            return regions;
        }
        catch (Exception ex) {
            Bukkit.getServer().getLogger().log(Level.WARNING, "Could not grab regions from WorldGuard", ex);
            return Collections.emptyList();
        }
    }

    public static List<String> getRegionNames(Location loc) {
        if (worldGuardPlugin == null) {
            WorldGuardRegionHandler.init();
        }
        if (!wgPlugin || loc == null) {
            return Collections.emptyList();
        }
        if (legacy_v62 || legacy_v60 || legacy_v5) {
            return WorldGuardRegionHandler.getRegionNamesLegacy(loc);
        }
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)loc.getWorld()));
        if (regionManager == null) {
            return Collections.emptyList();
        }
        ArrayList<String> regions = new ArrayList<String>();
        ArrayList<String> parentNames = new ArrayList<String>();
        ApplicableRegionSet set = regionManager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)loc));
        for (ProtectedRegion region : set) {
            String id = region.getId();
            regions.add(id);
            for (ProtectedRegion parent = region.getParent(); parent != null; parent = parent.getParent()) {
                parentNames.add(parent.getId());
            }
        }
        regions.removeAll(parentNames);
        return regions;
    }

    private static List<String> getRegionNamesLegacy(Location loc) {
        try {
            Object worldManager = legacy_getRegionManager.invoke(worldGuardPlugin, loc.getWorld());
            if (worldManager == null) {
                return Collections.emptyList();
            }
            Object vec = legacy_newVectorClazz.newInstance(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            Iterable set = (Iterable)legacy_getApplicableRegions_Vector.invoke(worldManager, legacy_VectorClazz.cast(vec));
            ArrayList<String> regions = new ArrayList<String>();
            ArrayList<String> parentNames = new ArrayList<String>();
            for (ProtectedRegion region : set) {
                String id = region.getId();
                regions.add(id);
                for (ProtectedRegion parent = region.getParent(); parent != null; parent = parent.getParent()) {
                    parentNames.add(parent.getId());
                }
            }
            regions.removeAll(parentNames);
            return regions;
        }
        catch (Exception ex) {
            Bukkit.getServer().getLogger().log(Level.WARNING, "Could not grab regions from WorldGuard", ex);
            return Collections.emptyList();
        }
    }

    static {
        wg_v7 = false;
        legacy_v60 = false;
        legacy_v62 = false;
        legacy_v5 = false;
        legacy_getRegionManager = null;
        legacy_getApplicableRegions_Region = null;
        legacy_getApplicableRegions_Location = null;
        legacy_getApplicableRegions_Vector = null;
    }
}

