/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.hooks.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

@Deprecated
public class WorldGuardFlagHandler {
    static boolean wgPlugin;
    static Object worldGuardPlugin;
    static boolean wg_v7;
    static boolean legacy_v60;
    static boolean legacy_v62;
    static boolean legacy_v5;
    static boolean hooksInstalled;
    static Map<String, Object> flags;
    static Method legacy_getRegionManager;
    static Method legacy_getApplicableRegions_Region;
    static Method legacy_getApplicableRegions_Location;
    static Method legacy5_applicableRegionSet_getFlag;
    static Constructor legacy_newProtectedCuboidRegion;
    static Class legacy_blockVectorClazz;
    static Constructor legacy_newblockVector;
    static Class legacy_VectorClazz;
    static Constructor legacy_newVectorClazz;
    static Method legacy_getApplicableRegions_Vector;
    static Class legacy_simpleFlagRegistryClazz;
    static Method legacy_simpleFlagRegistry_get;
    static Object legacy_worldGuardPlugin_flagRegistry;
    static boolean legacy_loadedFlags;

    public static void addHook(String flag, boolean state) {
        if (!wgPlugin) {
            return;
        }
        if (legacy_v62 || legacy_v60 || legacy_v5) {
            WorldGuardFlagHandler.addLegacyHook(flag, state);
            return;
        }
        StateFlag addFlag = new StateFlag(flag, state);
        try {
            WorldGuard.getInstance().getFlagRegistry().register((Flag)addFlag);
            flags.put(flag, addFlag);
        }
        catch (Exception ex) {
            Bukkit.getServer().getLogger().log(Level.WARNING, "Could not add flag {0} to WorldGuard", addFlag.getName());
            Flag wgFlag = WorldGuard.getInstance().getFlagRegistry().get(addFlag.getName());
            if (!(wgFlag instanceof StateFlag)) {
                wgPlugin = false;
                Bukkit.getServer().getLogger().log(Level.WARNING, "Could not hook WorldGuard");
            }
            flags.put(flag, wgFlag);
            Bukkit.getServer().getLogger().log(Level.WARNING, "Loaded existing {1} {0}", new Object[]{wgFlag.getName(), wgFlag.getClass().getSimpleName()});
        }
    }

    private static void addLegacyHook(String flag, boolean state) {
        try {
            Class<?> defaultFlagClazz = Class.forName("com.sk89q.worldguard.protection.flags.DefaultFlag");
            Field flagField = defaultFlagClazz.getField("flagsList");
            Flag[] flagsOld = (Flag[])flagField.get(null);
            Flag wgFlag = Stream.of(flagsOld).filter(f -> f.getName().equalsIgnoreCase(flag)).findFirst().orElse(null);
            if (wgFlag != null) {
                flags.put(flag, wgFlag);
                Bukkit.getServer().getLogger().log(Level.WARNING, "Loaded existing {1} {0}", new Object[]{wgFlag.getName(), wgFlag.getClass().getSimpleName()});
                return;
            }
            wgFlag = new StateFlag(flag, state);
            Flag[] flagsNew = new Flag[flagsOld.length + 1];
            System.arraycopy(flagsOld, 0, flagsNew, 0, flagsOld.length);
            flagsNew[flagsNew.length - 1] = wgFlag;
            WorldGuardFlagHandler.setStaticField(flagField, flagsNew);
            if (legacy_v62) {
                if (legacy_simpleFlagRegistryClazz == null) {
                    legacy_worldGuardPlugin_flagRegistry = WorldGuardFlagHandler.getPrivateField(worldGuardPlugin.getClass(), worldGuardPlugin, "flagRegistry");
                    legacy_simpleFlagRegistryClazz = Class.forName("com.sk89q.worldguard.protection.flags.registry.SimpleFlagRegistry");
                    legacy_simpleFlagRegistry_get = legacy_simpleFlagRegistryClazz.getDeclaredMethod("get", String.class);
                }
                legacy_simpleFlagRegistryClazz.getDeclaredMethod("register", Flag.class).invoke(legacy_worldGuardPlugin_flagRegistry, wgFlag);
            }
            flags.put(flag, wgFlag);
        }
        catch (Exception ex) {
            Bukkit.getServer().getLogger().log(Level.WARNING, "Could not add flag {0} to WorldGuard " + (legacy_v62 ? "6.2" : (legacy_v60 ? "6.0" : "5")), flag);
            Bukkit.getServer().getLogger().log(Level.WARNING, "Could not hook WorldGuard");
            wgPlugin = false;
        }
    }

    private static Object getPrivateField(Class<?> c, Object handle, String fieldName) throws Exception {
        Field field = c.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(handle);
    }

    private static void setStaticField(Field field, Object value) throws Exception {
        field.setAccessible(true);
        Field modifier = Field.class.getDeclaredField("modifiers");
        modifier.setAccessible(true);
        modifier.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, value);
    }

    public static boolean isEnabled() {
        return wgPlugin;
    }

    public static Object getFlag(String flag) {
        Object flagObj = flags.get(flag);
        if (flagObj == null) {
            if (wg_v7) {
                flagObj = WorldGuard.getInstance().getFlagRegistry().get(flag);
                flags.put(flag, flagObj);
            } else if (legacy_v62) {
                try {
                    if (legacy_simpleFlagRegistryClazz == null) {
                        legacy_worldGuardPlugin_flagRegistry = WorldGuardFlagHandler.getPrivateField(worldGuardPlugin.getClass(), worldGuardPlugin, "flagRegistry");
                        legacy_simpleFlagRegistryClazz = Class.forName("com.sk89q.worldguard.protection.flags.registry.SimpleFlagRegistry");
                        legacy_simpleFlagRegistry_get = legacy_simpleFlagRegistryClazz.getDeclaredMethod("get", String.class);
                    }
                    flagObj = legacy_simpleFlagRegistry_get.invoke(legacy_worldGuardPlugin_flagRegistry, flag);
                    flags.put(flag, flagObj);
                }
                catch (Exception ex) {
                    Bukkit.getServer().getLogger().log(Level.WARNING, "Could not grab flags from WorldGuard", ex);
                }
            } else if (!legacy_loadedFlags && (legacy_v60 || legacy_v5)) {
                try {
                    Class<?> defaultFlagClazz = Class.forName("com.sk89q.worldguard.protection.flags.DefaultFlag");
                    Field flagField = defaultFlagClazz.getField("flagsList");
                    Flag[] flagsOld = (Flag[])flagField.get(null);
                    Stream.of(flagsOld).forEach(f -> flags.put(f.getName(), f));
                    flagObj = flags.get(flag);
                }
                catch (Exception ex) {
                    Bukkit.getServer().getLogger().log(Level.WARNING, "Could not grab flags from WorldGuard", ex);
                }
                legacy_loadedFlags = true;
            }
        }
        return flagObj;
    }

    public static Boolean getBooleanFlag(Location loc, String flag) {
        return WorldGuardFlagHandler.getBooleanFlag(loc, flag, null);
    }

    public static Boolean getBooleanFlag(Location loc, String flag, Player optionalPlayer) {
        if (!wgPlugin) {
            return null;
        }
        LocalPlayer player = optionalPlayer != null ? WorldGuardPlugin.inst().wrapPlayer(optionalPlayer) : null;
        Object flagObj = WorldGuardFlagHandler.getFlag(flag);
        if (legacy_v62 || legacy_v60 || legacy_v5) {
            return flagObj == null ? null : WorldGuardFlagHandler.getBooleanFlagLegacy(loc, flagObj);
        }
        if (flagObj instanceof StateFlag) {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            StateFlag.State result = query.getApplicableRegions(BukkitAdapter.adapt((Location)loc)).queryState((RegionAssociable)player, new StateFlag[]{(StateFlag)flagObj});
            return result != null ? Boolean.valueOf(result == StateFlag.State.ALLOW) : null;
        }
        return null;
    }

    public static Boolean getBooleanFlag(Chunk c, String flag) {
        if (!wgPlugin) {
            return null;
        }
        Object flagObj = WorldGuardFlagHandler.getFlag(flag);
        if (legacy_v62 || legacy_v60 || legacy_v5) {
            return flagObj == null ? null : WorldGuardFlagHandler.getBooleanFlagLegacy(c, flagObj);
        }
        if (flagObj instanceof StateFlag) {
            RegionManager worldManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)c.getWorld()));
            if (worldManager == null) {
                return null;
            }
            ProtectedCuboidRegion chunkRegion = new ProtectedCuboidRegion("__TEST__", BlockVector3.at((int)(c.getX() << 4), (int)c.getWorld().getMaxHeight(), (int)(c.getZ() << 4)), BlockVector3.at((int)((c.getX() << 4) + 15), (int)0, (int)((c.getZ() << 4) + 15)));
            ApplicableRegionSet set = worldManager.getApplicableRegions((ProtectedRegion)chunkRegion);
            StateFlag.State result = set.queryState(null, new StateFlag[]{(StateFlag)flagObj});
            if (result == null && set.size() == 0) {
                return null;
            }
            return result == StateFlag.State.ALLOW;
        }
        return null;
    }

    private static Boolean getBooleanFlagLegacy(Location l, Object flag) {
        try {
            StateFlag.State result;
            Object worldManager;
            if (legacy_getRegionManager == null) {
                legacy_getRegionManager = worldGuardPlugin.getClass().getDeclaredMethod("getRegionManager", World.class);
                legacy_getApplicableRegions_Region = RegionManager.class.getDeclaredMethod("getApplicableRegions", Class.forName("com.sk89q.worldguard.protection.regions.ProtectedRegion"));
                legacy_getApplicableRegions_Location = RegionManager.class.getDeclaredMethod("getApplicableRegions", Location.class);
                legacy_blockVectorClazz = Class.forName("com.sk89q.worldedit.BlockVector");
                legacy_newblockVector = legacy_blockVectorClazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                legacy_newProtectedCuboidRegion = Class.forName("com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion").getConstructor(String.class, legacy_blockVectorClazz, legacy_blockVectorClazz);
                legacy_VectorClazz = Class.forName("com.sk89q.worldedit.Vector");
                legacy_newVectorClazz = legacy_VectorClazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                legacy_getApplicableRegions_Vector = RegionManager.class.getDeclaredMethod("getApplicableRegions", legacy_VectorClazz);
            }
            if ((worldManager = legacy_getRegionManager.invoke(worldGuardPlugin, l.getWorld())) == null) {
                return null;
            }
            Object vec = legacy_newVectorClazz.newInstance(l.getBlockX(), l.getBlockY(), l.getBlockZ());
            Object set = legacy_getApplicableRegions_Vector.invoke(worldManager, legacy_VectorClazz.cast(vec));
            if (legacy_v62 || legacy_v60) {
                result = ((ApplicableRegionSet)set).queryState(null, new StateFlag[]{(StateFlag)flag});
            } else {
                if (legacy5_applicableRegionSet_getFlag == null) {
                    legacy5_applicableRegionSet_getFlag = Class.forName("com.sk89q.worldguard.protection.ApplicableRegionSet").getMethod("getFlag", Flag.class);
                }
                result = (StateFlag.State)legacy5_applicableRegionSet_getFlag.invoke(set, flag);
            }
            if (result == null && set != null && ((Iterable)set).iterator().hasNext()) {
                return null;
            }
            return result == StateFlag.State.ALLOW;
        }
        catch (Exception ex) {
            Bukkit.getServer().getLogger().log(Level.WARNING, "Could not grab flags from WorldGuard", ex);
            return null;
        }
    }

    private static Boolean getBooleanFlagLegacy(Chunk c, Object flag) {
        try {
            StateFlag.State result;
            Object worldManager;
            if (legacy_getRegionManager == null) {
                legacy_getRegionManager = worldGuardPlugin.getClass().getDeclaredMethod("getRegionManager", World.class);
                legacy_getApplicableRegions_Region = RegionManager.class.getDeclaredMethod("getApplicableRegions", Class.forName("com.sk89q.worldguard.protection.regions.ProtectedRegion"));
                legacy_getApplicableRegions_Location = RegionManager.class.getDeclaredMethod("getApplicableRegions", Location.class);
                legacy_blockVectorClazz = Class.forName("com.sk89q.worldedit.BlockVector");
                legacy_newblockVector = legacy_blockVectorClazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                legacy_newProtectedCuboidRegion = Class.forName("com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion").getConstructor(String.class, legacy_blockVectorClazz, legacy_blockVectorClazz);
                legacy_VectorClazz = Class.forName("com.sk89q.worldedit.Vector");
                legacy_newVectorClazz = legacy_VectorClazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                legacy_getApplicableRegions_Vector = RegionManager.class.getDeclaredMethod("getApplicableRegions", legacy_VectorClazz);
            }
            if ((worldManager = legacy_getRegionManager.invoke(worldGuardPlugin, c.getWorld())) == null) {
                return null;
            }
            Object chunkRegion = legacy_newProtectedCuboidRegion.newInstance("__TEST__", legacy_newblockVector.newInstance(c.getX() << 4, c.getWorld().getMaxHeight(), c.getZ() << 4), legacy_newblockVector.newInstance((c.getX() << 4) + 15, 0, (c.getZ() << 4) + 15));
            Object set = legacy_getApplicableRegions_Region.invoke(worldManager, chunkRegion);
            if (legacy_v62 || legacy_v60) {
                result = ((ApplicableRegionSet)set).queryState(null, new StateFlag[]{(StateFlag)flag});
            } else {
                if (legacy5_applicableRegionSet_getFlag == null) {
                    legacy5_applicableRegionSet_getFlag = Class.forName("com.sk89q.worldguard.protection.ApplicableRegionSet").getMethod("getFlag", Flag.class);
                }
                result = (StateFlag.State)legacy5_applicableRegionSet_getFlag.invoke(set, flag);
            }
            if (result == null && set != null && ((Iterable)set).iterator().hasNext()) {
                return null;
            }
            return result == StateFlag.State.ALLOW;
        }
        catch (Exception ex) {
            Bukkit.getServer().getLogger().log(Level.WARNING, "Could not grab flags from WorldGuard", ex);
            return null;
        }
    }

    static {
        wg_v7 = false;
        legacy_v60 = false;
        legacy_v62 = false;
        legacy_v5 = false;
        hooksInstalled = false;
        flags = new HashMap<String, Object>();
        worldGuardPlugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
        wgPlugin = worldGuardPlugin != null;
        if (wgPlugin) {
            try {
                Class.forName("com.sk89q.worldguard.protection.flags.WeatherTypeFlag");
                wg_v7 = true;
            }
            catch (ClassNotFoundException ex) {
                try {
                    Class.forName("com.sk89q.worldguard.protection.flags.registry.SimpleFlagRegistry");
                    legacy_v62 = true;
                }
                catch (ClassNotFoundException ex2) {
                    try {
                        Class.forName("com.sk89q.worldguard.protection.flags.BuildFlag");
                        legacy_v60 = true;
                    }
                    catch (ClassNotFoundException ex3) {
                        try {
                            Class.forName("com.sk89q.worldguard.protection.flags.DefaultFlag");
                            legacy_v5 = true;
                        }
                        catch (ClassNotFoundException ex4) {
                            wgPlugin = false;
                        }
                    }
                }
            }
        }
        legacy_getRegionManager = null;
        legacy_getApplicableRegions_Region = null;
        legacy_getApplicableRegions_Location = null;
        legacy5_applicableRegionSet_getFlag = null;
        legacy_getApplicableRegions_Vector = null;
        legacy_simpleFlagRegistryClazz = null;
        legacy_simpleFlagRegistry_get = null;
        legacy_worldGuardPlugin_flagRegistry = null;
        legacy_loadedFlags = false;
    }
}

