/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.hooks;

import com.craftaro.core.hooks.Hook;
import com.craftaro.core.hooks.HookRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHookRegistry<T extends Hook>
extends HookRegistry<T> {
    private final Plugin plugin;
    private final Map<T, Integer> hooksWithPriority = new HashMap<T, Integer>();
    protected T activeHook = null;

    public BaseHookRegistry(Plugin plugin) {
        this.plugin = plugin;
    }

    public abstract void registerDefaultHooks();

    @Override
    public Optional<T> getActive() {
        if (this.activeHook == null) {
            T hook = this.findFirstAvailableHook();
            if (hook != null) {
                this.setActive(hook);
                this.plugin.getLogger().info("Activated hook '" + hook.getName() + "'");
            }
            this.checkDependenciesOfAllHooksAndLogMissingOnes();
        }
        return Optional.ofNullable(this.activeHook);
    }

    @Override
    public void setActive(@Nullable T hook) {
        if (this.activeHook == hook) {
            return;
        }
        if (this.activeHook != null) {
            this.activeHook.deactivate();
        }
        this.activeHook = hook;
        if (this.activeHook != null) {
            this.activeHook.activate(this.plugin);
        }
    }

    @Override
    @Nullable
    public T get(String name) {
        for (Hook hook : this.hooksWithPriority.keySet()) {
            if (!hook.getName().equalsIgnoreCase(name)) continue;
            return (T)hook;
        }
        return null;
    }

    @Override
    @NotNull
    public List<T> getAll() {
        return Collections.unmodifiableList(new ArrayList<T>(this.hooksWithPriority.keySet()));
    }

    @Override
    @NotNull
    public List<String> getAllNames() {
        return this.hooksWithPriority.keySet().stream().map(Hook::getName).sorted().collect(Collectors.toList());
    }

    @Override
    public void register(@NotNull T hook) {
        this.register(hook, 0);
    }

    public void register(@NotNull T hook, int priority) {
        if (this.get(hook.getName()) != null) {
            throw new IllegalArgumentException("Hook with name '" + hook.getName() + "' already registered");
        }
        this.hooksWithPriority.put(hook, priority);
    }

    @Override
    public void unregister(@NotNull T hook) {
        if (this.activeHook == hook) {
            this.activeHook = null;
            hook.deactivate();
        }
        this.hooksWithPriority.remove(hook);
    }

    @Override
    public void clear() {
        this.hooksWithPriority.clear();
    }

    @Nullable
    protected T findFirstAvailableHook() {
        return (T)((Hook)this.hooksWithPriority.entrySet().stream().sorted((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue())).filter(entry -> ((Hook)entry.getKey()).canBeActivated()).map(Map.Entry::getKey).findFirst().orElse(null));
    }

    protected void checkDependenciesOfAllHooksAndLogMissingOnes() {
        ArrayList<String> missingDependencies = new ArrayList<String>(0);
        for (Hook hook : this.getAll()) {
            for (String pluginName : hook.getPluginDependencies()) {
                if (this.plugin.getDescription().getDepend().contains(pluginName) || this.plugin.getDescription().getSoftDepend().contains(pluginName)) continue;
                missingDependencies.add(pluginName);
            }
        }
        if (!missingDependencies.isEmpty()) {
            this.plugin.getLogger().warning("Nag author(s): Plugin accesses hooks that it does not declare dependance on: " + String.join((CharSequence)", ", missingDependencies));
        }
    }
}

