/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.gui;

import com.craftaro.core.gui.Gui;
import com.craftaro.core.gui.GuiManager;
import com.craftaro.core.gui.GuiType;
import com.craftaro.core.gui.events.GuiClickEvent;
import com.craftaro.core.gui.events.GuiDropItemEvent;
import com.craftaro.core.gui.methods.Clickable;
import com.craftaro.core.gui.methods.Closable;
import com.craftaro.core.gui.methods.Droppable;
import com.craftaro.core.gui.methods.Openable;
import com.craftaro.core.gui.methods.Pagable;
import com.craftaro.core.utils.ItemUtils;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DoubleGui
extends Gui {
    protected boolean startStashed = true;
    protected int playerRows = 4;
    protected Map<Player, ItemStack[]> stash = new HashMap<Player, ItemStack[]>();

    public DoubleGui() {
        super(GuiType.STANDARD);
        this.allowDropItems = false;
    }

    public DoubleGui(GuiType type) {
        super(type);
        this.allowDropItems = false;
    }

    public DoubleGui(int rows) {
        super(rows);
        this.allowDropItems = false;
    }

    public DoubleGui(int rows, Gui parent) {
        super(rows, parent);
        this.allowDropItems = false;
    }

    public DoubleGui(Gui parent) {
        super(parent);
        this.allowDropItems = false;
    }

    public int getPlayerRows() {
        return this.playerRows;
    }

    int clickOffset(int cell) {
        return 54 + (cell < 9 ? cell + 27 : cell - 9);
    }

    int invOffset(int cell) {
        return 54 + cell;
    }

    public void setStartStashed(boolean startStashed) {
        this.startStashed = startStashed;
    }

    public DoubleGui setPlayerUnlocked(int cell) {
        this.unlockedCells.put(this.invOffset(cell), true);
        return this;
    }

    public DoubleGui setPlayerUnlocked(int row, int col) {
        this.unlockedCells.put(this.invOffset(col + row * 9), true);
        return this;
    }

    public DoubleGui setPlayerUnlocked(int cell, boolean open) {
        this.unlockedCells.put(this.invOffset(cell), open);
        return this;
    }

    public DoubleGui setPlayerUnlocked(int row, int col, boolean open) {
        this.unlockedCells.put(this.invOffset(col + row * 9), open);
        return this;
    }

    public DoubleGui setPlayerUnlockedRange(int cellFirst, int cellLast) {
        int last = this.invOffset(cellLast);
        for (int cell = this.invOffset(cellFirst); cell <= last; ++cell) {
            this.unlockedCells.put(cell, true);
        }
        return this;
    }

    public DoubleGui setPlayerUnlockedRange(int cellFirst, int cellLast, boolean open) {
        int last = this.invOffset(cellLast);
        for (int cell = this.invOffset(cellFirst); cell <= last; ++cell) {
            this.unlockedCells.put(cell, open);
        }
        return this;
    }

    public DoubleGui setPlayerUnlockedRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast) {
        int last = this.invOffset(cellColLast + cellRowLast * 9);
        for (int cell = this.invOffset(cellColFirst + cellRowFirst * 9); cell <= last; ++cell) {
            this.unlockedCells.put(cell, true);
        }
        return this;
    }

    public DoubleGui setPlayerUnlockedRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast, boolean open) {
        int last = this.invOffset(cellColLast + cellRowLast * 9);
        for (int cell = this.invOffset(cellColFirst + cellRowFirst * 9); cell <= last; ++cell) {
            this.unlockedCells.put(cell, open);
        }
        return this;
    }

    public DoubleGui setPlayerItem(int cell, ItemStack item) {
        this.cellItems.put(this.invOffset(cell), item);
        if (this.open && cell >= 0 && cell < 36) {
            cell = cell >= 27 ? cell - 27 : cell + 9;
            for (HumanEntity e : this.inventory.getViewers()) {
                e.getInventory().setItem(cell, item);
            }
        }
        return this;
    }

    public DoubleGui setPlayerItem(int row, int col, ItemStack item) {
        int cell = col + row * 9;
        this.cellItems.put(this.invOffset(cell), item);
        if (this.open && cell >= 0 && cell < 36) {
            cell = cell >= 27 ? cell - 27 : cell + 9;
            for (HumanEntity e : this.inventory.getViewers()) {
                e.getInventory().setItem(cell, item);
            }
        }
        return this;
    }

    public DoubleGui highlightPlayerItem(int cell) {
        int invCell = this.invOffset(cell);
        ItemStack item = (ItemStack)this.cellItems.get(invCell);
        if (item != null) {
            this.setPlayerItem(cell, ItemUtils.addGlow(item));
        }
        return this;
    }

    public DoubleGui highlightPlayerItem(int row, int col) {
        int cell = col + row * 9;
        int invCell = this.invOffset(cell);
        ItemStack item = (ItemStack)this.cellItems.get(invCell);
        if (item != null) {
            this.setPlayerItem(cell, ItemUtils.addGlow(item));
        }
        return this;
    }

    public DoubleGui setPlayerAction(int cell, Clickable action) {
        this.setConditional(this.invOffset(cell), null, action);
        return this;
    }

    public DoubleGui setPlayerAction(int row, int col, Clickable action) {
        this.setConditional(this.invOffset(col + row * 9), null, action);
        return this;
    }

    public DoubleGui setPlayerAction(int cell, ClickType type, Clickable action) {
        this.setConditional(this.invOffset(cell), type, action);
        return this;
    }

    public DoubleGui setPlayerAction(int row, int col, ClickType type, Clickable action) {
        this.setConditional(this.invOffset(col + row * 9), type, action);
        return this;
    }

    public DoubleGui setPlayerActionForRange(int cellFirst, int cellLast, Clickable action) {
        for (int cell = cellFirst; cell <= cellLast; ++cell) {
            this.setConditional(this.invOffset(cell), null, action);
        }
        return this;
    }

    public DoubleGui setPlayerActionForRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast, Clickable action) {
        int last = cellColLast + cellRowLast * 9;
        for (int cell = cellColFirst + cellRowFirst * 9; cell <= last; ++cell) {
            this.setConditional(this.invOffset(cell), null, action);
        }
        return this;
    }

    public DoubleGui setPlayerActionForRange(int cellFirst, int cellLast, ClickType type, Clickable action) {
        for (int cell = cellFirst; cell <= cellLast; ++cell) {
            this.setConditional(this.invOffset(cell), type, action);
        }
        return this;
    }

    public DoubleGui setPlayerActionForRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast, ClickType type, Clickable action) {
        int last = cellColLast + cellRowLast * 9;
        for (int cell = cellColFirst + cellRowFirst * 9; cell <= last; ++cell) {
            this.setConditional(this.invOffset(cell), type, action);
        }
        return this;
    }

    public DoubleGui clearPlayerActions(int cell) {
        this.conditionalButtons.remove(this.invOffset(cell));
        return this;
    }

    public DoubleGui clearPlayerActions(int row, int col) {
        int cell = this.invOffset(col + row * 9);
        this.conditionalButtons.remove(cell);
        return this;
    }

    public DoubleGui setPlayerButton(int cell, ItemStack item, Clickable action) {
        this.setPlayerItem(cell, item);
        this.setConditional(this.invOffset(cell), null, action);
        return this;
    }

    public DoubleGui setPlayerButton(int row, int col, ItemStack item, Clickable action) {
        int cell = col + row * 9;
        this.setPlayerItem(cell, item);
        this.setConditional(this.invOffset(cell), null, action);
        return this;
    }

    public DoubleGui setPlayerButton(int cell, ItemStack item, ClickType type, Clickable action) {
        this.setItem(cell, item);
        this.setConditional(this.invOffset(cell), type, action);
        return this;
    }

    public DoubleGui setPlayerButton(int row, int col, ItemStack item, ClickType type, Clickable action) {
        int cell = col + row * 9;
        this.setPlayerItem(cell, item);
        this.setConditional(this.invOffset(cell), type, action);
        return this;
    }

    @Override
    protected boolean onClickPlayerInventory(@NotNull GuiManager manager, @NotNull Player player, @NotNull Inventory openInv, InventoryClickEvent event) {
        Clickable button;
        int cell = event.getSlot();
        int offsetCell = this.clickOffset(cell);
        Map conditionals = (Map)this.conditionalButtons.get(offsetCell);
        if (conditionals == null || (button = (Clickable)conditionals.get(event.getClick())) == null && (button = (Clickable)conditionals.get(null)) == null) {
            return false;
        }
        button.onClick(new GuiClickEvent(manager, this, player, event, cell, true));
        event.setCancelled(this.unlockedCells.entrySet().stream().noneMatch(e -> offsetCell == (Integer)e.getKey() && (Boolean)e.getValue() != false));
        return true;
    }

    @Override
    protected boolean onClickOutside(@NotNull GuiManager manager, @NotNull Player player, @NotNull InventoryClickEvent event) {
        if (this.dropper != null) {
            return this.dropper.onDrop(new GuiDropItemEvent(manager, this, player, event));
        }
        return false;
    }

    @Override
    public void onOpen(@NotNull GuiManager manager, @NotNull Player player) {
        if (this.startStashed) {
            this.stashItems(player);
        }
        super.onOpen(manager, player);
    }

    @Override
    public void onClose(@NotNull GuiManager manager, @NotNull Player player) {
        this.restoreStash(player);
        super.onClose(manager, player);
    }

    protected void restoreStash(Player player) {
        if (this.stash.containsKey(player)) {
            player.getInventory().setContents(this.stash.remove(player));
            player.updateInventory();
        }
    }

    protected void stashItems(Player player) {
        if (!this.stash.containsKey(player)) {
            this.stash.put(player, (ItemStack[])player.getInventory().getContents().clone());
            player.getInventory().clear();
        }
    }

    @Override
    public DoubleGui setAcceptsItems(boolean acceptsItems) {
        return (DoubleGui)super.setAcceptsItems(acceptsItems);
    }

    @Override
    @NotNull
    public DoubleGui setUnlocked(int cell) {
        return (DoubleGui)super.setUnlocked(cell);
    }

    @Override
    @NotNull
    public DoubleGui setUnlocked(int cell, boolean open) {
        return (DoubleGui)super.setUnlocked(cell, open);
    }

    @Override
    @NotNull
    public DoubleGui setUnlocked(int row, int col) {
        return (DoubleGui)super.setUnlocked(row, col);
    }

    @Override
    @NotNull
    public DoubleGui setUnlocked(int row, int col, boolean open) {
        return (DoubleGui)super.setUnlocked(row, col, open);
    }

    @Override
    @NotNull
    public DoubleGui setUnlockedRange(int cellFirst, int cellLast) {
        return (DoubleGui)super.setUnlockedRange(cellFirst, cellLast);
    }

    @Override
    @NotNull
    public DoubleGui setUnlockedRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast) {
        return (DoubleGui)super.setUnlockedRange(cellRowFirst, cellColFirst, cellRowLast, cellColLast);
    }

    @Override
    public DoubleGui setAllowDrops(boolean allow) {
        return (DoubleGui)super.setAllowDrops(allow);
    }

    @Override
    public DoubleGui setAllowClose(boolean allow) {
        return (DoubleGui)super.setAllowClose(allow);
    }

    @Override
    @NotNull
    public DoubleGui setTitle(String title) {
        return (DoubleGui)super.setTitle(title);
    }

    @Override
    @NotNull
    public DoubleGui setRows(int rows) {
        return (DoubleGui)super.setRows(rows);
    }

    @Override
    @NotNull
    public DoubleGui setDefaultItem(ItemStack item) {
        return (DoubleGui)super.setDefaultItem(item);
    }

    @Override
    @NotNull
    public DoubleGui setItem(int cell, ItemStack item) {
        return (DoubleGui)super.setItem(cell, item);
    }

    @Override
    @NotNull
    public DoubleGui setItem(int row, int col, ItemStack item) {
        return (DoubleGui)super.setItem(row, col, item);
    }

    @Override
    @NotNull
    public DoubleGui highlightItem(int cell) {
        return (DoubleGui)super.highlightItem(cell);
    }

    @Override
    @NotNull
    public DoubleGui highlightItem(int row, int col) {
        return (DoubleGui)super.highlightItem(row, col);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int cell, String name, String ... lore) {
        return (DoubleGui)super.updateItem(cell, name, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int row, int col, String name, List<String> lore) {
        return (DoubleGui)super.updateItem(col + row * 9, name, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int cell, @NotNull String name, List<String> lore) {
        return (DoubleGui)super.updateItem(cell, name, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int row, int col, @NotNull ItemStack itemTo, String title, String ... lore) {
        return (DoubleGui)super.updateItem(col + row * 9, itemTo, title, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int cell, @NotNull ItemStack itemTo, String title, String ... lore) {
        return (DoubleGui)super.updateItem(cell, itemTo, title, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int row, int col, @NotNull XMaterial itemTo, String title, String ... lore) {
        return (DoubleGui)super.updateItem(col + row * 9, itemTo, title, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int cell, @NotNull XMaterial itemTo, String title, String ... lore) {
        return (DoubleGui)super.updateItem(cell, itemTo, title, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int row, int col, @NotNull ItemStack itemTo, String title, List<String> lore) {
        return (DoubleGui)super.updateItem(col + row * 9, itemTo, title, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int cell, @NotNull ItemStack itemTo, String title, List<String> lore) {
        return (DoubleGui)super.updateItem(cell, itemTo, title, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int row, int col, @NotNull XMaterial itemTo, String title, List<String> lore) {
        return (DoubleGui)super.updateItem(col + row * 9, itemTo, title, lore);
    }

    @Override
    @NotNull
    public DoubleGui updateItem(int cell, @NotNull XMaterial itemTo, String title, List<String> lore) {
        return (DoubleGui)super.updateItem(cell, itemTo, title, lore);
    }

    @Override
    @NotNull
    public DoubleGui setAction(int cell, Clickable action) {
        return (DoubleGui)super.setAction(cell, action);
    }

    @Override
    @NotNull
    public DoubleGui setAction(int row, int col, Clickable action) {
        return (DoubleGui)super.setAction(row, col, action);
    }

    @Override
    @NotNull
    public DoubleGui setAction(int cell, ClickType type, Clickable action) {
        return (DoubleGui)super.setAction(cell, type, action);
    }

    @Override
    @NotNull
    public DoubleGui setAction(int row, int col, ClickType type, Clickable action) {
        return (DoubleGui)super.setAction(row, col, type, action);
    }

    @Override
    @NotNull
    public DoubleGui setActionForRange(int cellFirst, int cellLast, Clickable action) {
        return (DoubleGui)super.setActionForRange(cellFirst, cellLast, action);
    }

    @Override
    @NotNull
    public DoubleGui setActionForRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast, Clickable action) {
        return (DoubleGui)super.setActionForRange(cellRowFirst, cellColFirst, cellRowLast, cellColLast, action);
    }

    @Override
    @NotNull
    public DoubleGui setActionForRange(int cellFirst, int cellLast, ClickType type, Clickable action) {
        return (DoubleGui)super.setActionForRange(cellFirst, cellLast, type, action);
    }

    @Override
    @NotNull
    public DoubleGui setActionForRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast, ClickType type, Clickable action) {
        return (DoubleGui)super.setActionForRange(cellRowFirst, cellColFirst, cellRowLast, cellColLast, type, action);
    }

    @Override
    @NotNull
    public DoubleGui clearActions(int cell) {
        return (DoubleGui)super.clearActions(cell);
    }

    @Override
    @NotNull
    public DoubleGui clearActions(int row, int col) {
        return (DoubleGui)super.clearActions(row, col);
    }

    @Override
    @NotNull
    public DoubleGui setButton(int cell, ItemStack item, Clickable action) {
        return (DoubleGui)super.setButton(cell, item, action);
    }

    @Override
    @NotNull
    public DoubleGui setButton(int row, int col, ItemStack item, Clickable action) {
        return (DoubleGui)super.setButton(row, col, item, action);
    }

    @Override
    @NotNull
    public DoubleGui setButton(int cell, ItemStack item, ClickType type, Clickable action) {
        return (DoubleGui)super.setButton(cell, item, type, action);
    }

    @Override
    @NotNull
    public DoubleGui setButton(int row, int col, ItemStack item, ClickType type, Clickable action) {
        return (DoubleGui)super.setButton(row, col, item, type, action);
    }

    @Override
    @NotNull
    public DoubleGui setOnOpen(Openable action) {
        return (DoubleGui)super.setOnOpen(action);
    }

    @Override
    @NotNull
    public DoubleGui setOnClose(Closable action) {
        return (DoubleGui)super.setOnClose(action);
    }

    @Override
    @NotNull
    public DoubleGui setOnDrop(Droppable action) {
        return (DoubleGui)super.setOnDrop(action);
    }

    @Override
    @NotNull
    public DoubleGui setOnPage(Pagable action) {
        return (DoubleGui)super.setOnPage(action);
    }

    @Override
    @NotNull
    public DoubleGui setNextPage(int row, int col, @NotNull ItemStack item) {
        return (DoubleGui)super.setNextPage(row, col, item);
    }

    @Override
    @NotNull
    public DoubleGui setPrevPage(int row, int col, @NotNull ItemStack item) {
        return (DoubleGui)super.setPrevPage(row, col, item);
    }
}

