/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.database;

import com.craftaro.core.SongodaCore;
import com.craftaro.core.SongodaPlugin;
import com.craftaro.core.configuration.Config;
import com.craftaro.core.database.DatabaseConnector;
import com.craftaro.core.database.DatabaseType;
import com.craftaro.core.database.OptionalResult;
import com.craftaro.third_party.com.zaxxer.hikari.HikariConfig;
import com.craftaro.third_party.com.zaxxer.hikari.HikariDataSource;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.DSL;
import java.sql.Connection;
import java.sql.SQLException;
import org.bukkit.plugin.Plugin;

public class MySQLConnector
implements DatabaseConnector {
    private final Plugin plugin;
    private HikariDataSource hikari;
    private boolean initializedSuccessfully;

    public MySQLConnector(SongodaPlugin plugin) {
        this((Plugin)plugin, plugin.getDatabaseConfig());
    }

    public MySQLConnector(Plugin plugin, Config databaseConfig) {
        this.plugin = plugin;
        String hostname = databaseConfig.getString("Connection Settings.Hostname");
        int port = databaseConfig.getInt("Connection Settings.Port");
        String database = databaseConfig.getString("Connection Settings.Database");
        String username = databaseConfig.getString("Connection Settings.Username");
        String password = databaseConfig.getString("Connection Settings.Password");
        boolean useSSL = databaseConfig.getBoolean("Connection Settings.Use SSL");
        int poolSize = databaseConfig.getInt("Connection Settings.Pool Size");
        plugin.getLogger().info("Connecting to " + hostname + " : " + port + " using MySQL");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + hostname + ":" + port + "/" + database + "?useSSL=" + useSSL);
        config.setUsername(username);
        config.setPassword(password);
        config.setMaximumPoolSize(poolSize);
        try {
            this.hikari = new HikariDataSource(config);
            this.initializedSuccessfully = true;
        }
        catch (Exception ex) {
            this.initializedSuccessfully = false;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initializedSuccessfully;
    }

    @Override
    public void closeConnection() {
        this.hikari.close();
    }

    @Override
    public void connect(DatabaseConnector.ConnectionCallback callback) {
        try (Connection connection = this.hikari.getConnection();){
            callback.accept(connection);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("An error occurred executing a MySQL query: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public OptionalResult connectOptional(DatabaseConnector.ConnectionOptionalCallback callback) {
        OptionalResult optionalResult;
        block8: {
            Connection connection = this.getConnection();
            try {
                optionalResult = callback.accept(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    SongodaCore.getLogger().severe("An error occurred executing a MySQL query: " + ex.getMessage());
                    ex.printStackTrace();
                    return OptionalResult.empty();
                }
            }
            connection.close();
        }
        return optionalResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T connectResult(DatabaseConnector.ConnectResult<T> callback, T ... defaultValue) {
        try (Connection connection = this.getConnection();){
            T result = callback.accept(connection);
            T t = result != null ? result : (defaultValue.length > 0 ? defaultValue[0] : null);
            return t;
        }
        catch (Exception ex) {
            T t;
            SongodaCore.getLogger().severe("An error occurred executing a MySQL query: " + ex.getMessage());
            ex.printStackTrace();
            if (defaultValue.length > 0) {
                t = defaultValue[0];
                return t;
            }
            t = null;
            return t;
        }
    }

    @Override
    public void connectDSL(DatabaseConnector.DSLContextCallback callback) {
        try (Connection connection = this.getConnection();){
            callback.accept(DSL.using(connection, SQLDialect.MYSQL));
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("An error occurred executing a MySQL query: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public OptionalResult connectDSLOptional(DatabaseConnector.DSLContextOptionalCallback callback) {
        OptionalResult optionalResult;
        block8: {
            Connection connection = this.getConnection();
            try {
                optionalResult = callback.accept(DSL.using(connection, SQLDialect.MYSQL));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    SongodaCore.getLogger().severe("An error occurred executing a MySQL query: " + ex.getMessage());
                    ex.printStackTrace();
                    return OptionalResult.empty();
                }
            }
            connection.close();
        }
        return optionalResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T connectDSLResult(DatabaseConnector.DSLConnectResult<T> callback, T ... defaultValue) {
        try (Connection connection = this.getConnection();){
            T result = callback.accept(DSL.using(connection, SQLDialect.MYSQL));
            T t = result != null ? result : (defaultValue.length > 0 ? defaultValue[0] : null);
            return t;
        }
        catch (Exception ex) {
            T t;
            SongodaCore.getLogger().severe("An error occurred executing a MySQL query: " + ex.getMessage());
            ex.printStackTrace();
            if (defaultValue.length > 0) {
                t = defaultValue[0];
                return t;
            }
            t = null;
            return t;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.hikari.getConnection();
    }

    @Override
    public DatabaseType getType() {
        return DatabaseType.MYSQL;
    }
}

