/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.data.lazy;

import java.util.function.Supplier;

public class Lazy<T> {
    private Supplier<T> supplier = null;
    private T value = null;

    public synchronized T get() {
        if (this.value == null && this.supplier != null) {
            this.value = this.supplier.get();
            this.supplier = null;
        }
        return this.value;
    }

    public synchronized T getOrDefault(T def) {
        T value = this.get();
        return value == null ? def : value;
    }

    public synchronized Lazy<T> reset() {
        this.value = null;
        return this;
    }

    public synchronized Lazy<T> set(T value) {
        this.value = value;
        return this;
    }

    public Lazy<T> set(Supplier<T> supplier) {
        this.supplier = supplier;
        return this;
    }

    public synchronized boolean isLoaded() {
        return this.supplier != null;
    }

    public String toString() {
        return this.get().toString();
    }

    public boolean equals(Object obj) {
        if (obj == this.get()) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Lazy) {
            Lazy other = (Lazy)obj;
            return this.get().equals(other.get());
        }
        return this.get().equals(obj);
    }

    public int hashCode() {
        return this.get().hashCode();
    }
}

