/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.data;

import com.craftaro.core.utils.ItemSerializer;
import java.time.Instant;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class StoredData {
    private Object object;

    public StoredData(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public String asString() {
        if (this.object == null) {
            return null;
        }
        return this.object.toString();
    }

    public int asInt() {
        if (this.object == null) {
            return 0;
        }
        return Integer.parseInt(this.asString());
    }

    public double asDouble() {
        return Double.parseDouble(this.asString());
    }

    public long asLong() {
        String string = this.asString();
        if (string == null) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    public float asFloat() {
        return Float.parseFloat(this.asString());
    }

    public Instant asInstant() {
        return Instant.ofEpochMilli(this.asLong());
    }

    public boolean asBoolean() {
        if (this.object instanceof Integer) {
            return (Integer)this.object == 1;
        }
        return Boolean.parseBoolean(this.asString());
    }

    public void swap(Object object) {
        this.object = object;
    }

    public boolean isNull() {
        return this.object == null;
    }

    public byte[] asBytes() {
        return (byte[])this.object;
    }

    public UUID asUniqueID() {
        return UUID.fromString(this.asString());
    }

    public ItemStack asItemStack() {
        return ItemSerializer.deserializeItem(this.asBytes());
    }
}

