/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.data;

import com.craftaro.core.data.SQLBase;
import com.craftaro.core.data.SQLExecutable;
import com.craftaro.third_party.org.jooq.DSLContext;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.InsertOnDuplicateSetMoreStep;
import com.craftaro.third_party.org.jooq.InsertOnDuplicateSetStep;
import com.craftaro.third_party.org.jooq.InsertValuesStepN;
import com.craftaro.third_party.org.jooq.impl.DSL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SQLInsert
extends SQLBase {
    private String table;
    private final Map<String, Object> fields = new LinkedHashMap<String, Object>();
    private boolean voidedKey = false;
    private InsertValuesStepN currentStep;

    public SQLInsert(DSLContext ctx) {
        super(ctx);
    }

    public static SQLInsert create(DSLContext ctx) {
        return new SQLInsert(ctx);
    }

    public SQLInsert insertInto(String table) {
        this.table = table;
        return this;
    }

    public SQLInsert withField(String field, Object value, boolean voidKey) {
        if (voidKey) {
            this.voidedKey = true;
        }
        return voidKey ? this : this.withField(field, value);
    }

    public SQLInsert withField(String field, Object value) {
        if (field.equalsIgnoreCase("desc")) {
            field = "`desc`";
        }
        this.fields.put(field.toLowerCase(), value);
        return this;
    }

    public SQLExecutable onDuplicateKeyUpdate(String ... columns) {
        this.currentStep = this.ctx.insertInto(DSL.table(this.table), (Field[])this.fields.keySet().stream().map(DSL::field).toArray(Field[]::new));
        this.currentStep = this.currentStep.values(this.fields.values().stream().map(this::cleanValue).toArray());
        if (this.voidedKey) {
            return new SQLExecutable(this.ctx, this.currentStep);
        }
        SQLOnDupeUpdate sqlOnDupeUpdate = new SQLOnDupeUpdate(this.ctx, this.currentStep, columns);
        for (String column : columns.length > 0 ? new HashSet<String>(Arrays.asList(columns)) : this.fields.keySet()) {
            sqlOnDupeUpdate.set(column.replace("`", ""), this.fields.get(column.toLowerCase()));
        }
        return sqlOnDupeUpdate;
    }

    public static class SQLOnDupeUpdate
    extends SQLExecutable {
        private InsertOnDuplicateSetStep currentStep;
        private final List<String> columnsToUpdate = new ArrayList<String>();

        public SQLOnDupeUpdate(DSLContext ctx, InsertValuesStepN currentStep, String ... columns) {
            super(ctx, null);
            this.currentStep = currentStep.onDuplicateKeyUpdate();
            this.columnsToUpdate.addAll(Arrays.asList(columns));
        }

        public SQLOnDupeUpdate set(String field, Object value) {
            if (!this.columnsToUpdate.isEmpty() && !this.columnsToUpdate.contains(field)) {
                return this;
            }
            Field fieldName = this.getField(field, (value = this.cleanValue(value)) == null ? null : value.getClass());
            if (this.currentStep != null) {
                this.query = value == null ? this.currentStep.setNull(fieldName) : this.currentStep.set(fieldName, value);
                this.currentStep = null;
            } else {
                this.query = value == null ? ((InsertOnDuplicateSetMoreStep)this.query).setNull(fieldName) : ((InsertOnDuplicateSetMoreStep)this.query).set(fieldName, value);
            }
            return this;
        }
    }
}

