/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.configuration.editor;

import com.craftaro.core.SongodaPlugin;
import com.craftaro.core.configuration.Config;
import com.craftaro.core.configuration.editor.ConfigEditorGui;
import com.craftaro.core.gui.Gui;
import com.craftaro.core.gui.GuiUtils;
import com.craftaro.core.gui.SimplePagedGui;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginConfigGui
extends SimplePagedGui {
    final JavaPlugin plugin;
    LinkedHashMap<String, MemoryConfiguration> configs;

    public PluginConfigGui(SongodaPlugin plugin) {
        this(plugin, (Gui)null);
    }

    public PluginConfigGui(SongodaPlugin plugin, Gui parent) {
        super(parent);
        this.configs = new LinkedHashMap();
        this.plugin = plugin;
        this.configs.put(plugin.getCoreConfig().getFile().getName(), plugin.getCoreConfig());
        List<Config> more = plugin.getExtraConfig();
        if (more != null && !more.isEmpty()) {
            for (Config cfg : more) {
                this.configs.put(cfg.getFile().getName(), cfg);
            }
        }
        this.init();
    }

    public PluginConfigGui(JavaPlugin plugin) {
        this(plugin, null);
    }

    public PluginConfigGui(JavaPlugin plugin, Gui parent) {
        block5: {
            super(parent);
            this.configs = new LinkedHashMap();
            this.plugin = plugin;
            this.configs.put("config.yml", (MemoryConfiguration)plugin.getConfig());
            try {
                Object more = plugin.getClass().getDeclaredMethod("getExtraConfig", new Class[0]).invoke((Object)plugin, new Object[0]);
                if (!(more instanceof List) || ((List)more).isEmpty()) break block5;
                try {
                    Method method_Config_getFile = ((List)more).get(0).getClass().getDeclaredMethod("getFile", new Class[0]);
                    for (Object cfg2 : (List)more) {
                        this.configs.put(((File)method_Config_getFile.invoke(cfg2, new Object[0])).getName(), (MemoryConfiguration)cfg2);
                    }
                }
                catch (Exception ex) {
                    ((List)more).forEach(cfg -> this.configs.put("(File " + this.configs.size() + ")", (MemoryConfiguration)cfg));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        this.init();
    }

    private void init() {
        this.blankItem = GuiUtils.getBorderItem(XMaterial.LIGHT_GRAY_STAINED_GLASS_PANE);
        this.setTitle(ChatColor.DARK_BLUE + this.plugin.getName() + " Plugin Config");
        this.setUseHeader(true);
        this.headerBackItem = this.footerBackItem = GuiUtils.getBorderItem(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem());
        this.setButton(8, GuiUtils.createButtonItem(XMaterial.OAK_DOOR, "Exit", new String[0]), event -> event.player.closeInventory());
        int i = 9;
        for (Map.Entry<String, MemoryConfiguration> config : this.configs.entrySet()) {
            this.setButton(i++, GuiUtils.createButtonItem(XMaterial.BOOK, ChatColor.YELLOW + config.getKey(), "Click to edit this config"), event -> event.manager.showGUI(event.player, new ConfigEditorGui(event.player, this.plugin, this, (String)config.getKey(), (MemoryConfiguration)config.getValue())));
        }
    }
}

