/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.configuration;

import com.craftaro.core.configuration.DataStoreObject;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDataStore<T extends DataStoreObject> {
    protected final Plugin plugin;
    protected final String filename;
    protected final String dirName;
    private final Function<ConfigurationSection, T> getFromSection;
    protected final HashMap<Object, T> data = new HashMap();
    private File file;
    private final Object lock = new Object();
    SaveTask saveTask;
    Timer autosaveTimer;
    int autosaveInterval = 60;

    public SimpleDataStore(@NotNull Plugin plugin, @NotNull String filename, @NotNull Function<ConfigurationSection, T> loadFunction) {
        this.plugin = plugin;
        this.filename = filename;
        this.dirName = null;
        this.getFromSection = loadFunction;
    }

    public SimpleDataStore(@NotNull Plugin plugin, @Nullable String directory, @NotNull String filename, @NotNull Function<ConfigurationSection, T> loadFunction) {
        this.plugin = plugin;
        this.filename = filename;
        this.dirName = directory;
        this.getFromSection = loadFunction;
    }

    @NotNull
    public File getFile() {
        if (this.file == null) {
            this.file = this.dirName != null ? new File(this.plugin.getDataFolder() + this.dirName, this.filename != null ? this.filename : "data.yml") : new File(this.plugin.getDataFolder(), this.filename != null ? this.filename : "data.yml");
        }
        return this.file;
    }

    public Map<Object, T> getData() {
        return this.data;
    }

    @Nullable
    public T get(Object key) {
        return (T)((DataStoreObject)this.data.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T remove(@NotNull Object key) {
        DataStoreObject temp;
        Object object = this.lock;
        synchronized (object) {
            temp = (DataStoreObject)this.data.remove(key);
        }
        this.save();
        return (T)temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T remove(@NotNull T value) {
        DataStoreObject temp;
        if (value == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            temp = (DataStoreObject)this.data.remove(value.getKey());
        }
        this.save();
        return (T)temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T add(@NotNull T value) {
        DataStoreObject temp;
        if (value == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            temp = (DataStoreObject)this.data.put(value.getKey(), value);
        }
        this.save();
        return (T)temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@NotNull T[] value) {
        if (value == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (T t : value) {
                if (t == null) continue;
                this.data.put(t.getKey(), t);
            }
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public void addAll(@NotNull Collection<T> value) {
        if (value == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (DataStoreObject v : value) {
                if (v == null) continue;
                this.data.put(v.getKey(), v);
            }
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (!this.getFile().exists()) {
            return;
        }
        try {
            YamlConfiguration f = new YamlConfiguration();
            f.options().pathSeparator('\u0000');
            f.load(this.file);
            Object object = this.lock;
            synchronized (object) {
                this.data.clear();
                f.getValues(false).values().stream().filter(ConfigurationSection.class::isInstance).map(v -> (DataStoreObject)this.getFromSection.apply((ConfigurationSection)v)).forEach(v -> this.data.put(v.getKey(), v));
            }
        }
        catch (IOException | InvalidConfigurationException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load data from " + this.file.getName(), ex);
        }
    }

    public void saveChanges() {
        if (this.saveTask != null || this.data.values().stream().anyMatch(DataStoreObject::hasChanged)) {
            this.flushSave();
        }
    }

    public void save() {
        if (this.saveTask == null) {
            this.autosaveTimer = new Timer((this.plugin != null ? this.plugin.getName() + "-DataStoreSave-" : "DataStoreSave-") + this.getFile().getName());
            this.saveTask = new SaveTask();
            this.autosaveTimer.schedule((TimerTask)this.saveTask, (long)this.autosaveInterval * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushSave() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
            this.autosaveTimer.cancel();
            this.saveTask = null;
            this.autosaveTimer = null;
        }
        YamlConfiguration yamlConfig = new YamlConfiguration();
        Object object = this.lock;
        synchronized (object) {
            this.data.values().forEach(e -> e.saveToSection(yamlConfig.createSection(e.getConfigKey())));
        }
        try {
            yamlConfig.save(this.getFile());
            this.data.values().forEach(e -> e.setChanged(false));
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save data to " + this.file.getName(), ex);
        }
    }

    class SaveTask
    extends TimerTask {
        SaveTask() {
        }

        @Override
        public void run() {
            SimpleDataStore.this.flushSave();
        }
    }
}

