/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.configuration;

import com.craftaro.core.configuration.Comment;
import com.craftaro.core.configuration.ConfigFileConfigurationAdapter;
import com.craftaro.core.configuration.ConfigFormattingRules;
import com.craftaro.core.configuration.ConfigSection;
import com.craftaro.core.utils.TextUtils;
import com.craftaro.third_party.org.apache.commons.lang3.Validate;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class Config
extends ConfigSection {
    protected static final String BLANK_CONFIG = "{}\n";
    protected File file;
    protected final ConfigFileConfigurationAdapter config = new ConfigFileConfigurationAdapter(this);
    protected Comment headerComment = null;
    protected Comment footerComment = null;
    final String dirName;
    final String fileName;
    final Plugin plugin;
    final DumperOptions yamlOptions = new DumperOptions();
    final Representer yamlRepresenter = new YamlRepresenter();
    final Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);
    Charset defaultCharset = StandardCharsets.UTF_8;
    SaveTask saveTask;
    Timer autosaveTimer;
    boolean autosave = false;
    int autosaveInterval = 60;
    boolean autoremove = false;
    boolean loadComments = true;
    ConfigFormattingRules.CommentStyle defaultNodeCommentFormat = ConfigFormattingRules.CommentStyle.SIMPLE;
    ConfigFormattingRules.CommentStyle defaultSectionCommentFormat = ConfigFormattingRules.CommentStyle.SPACED;
    int rootNodeSpacing = 1;
    int commentSpacing = 1;
    protected final Pattern yamlNode = Pattern.compile("^( *)([^:{}\\[\\],&*#?|\\-<>=!%@`]+):(.*)$");

    public Config() {
        this.plugin = null;
        this.file = null;
        this.dirName = null;
        this.fileName = null;
    }

    public Config(@NotNull File file) {
        this.plugin = null;
        this.file = file.getAbsoluteFile();
        this.dirName = null;
        this.fileName = null;
    }

    public Config(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.dirName = null;
        this.fileName = null;
    }

    public Config(@NotNull Plugin plugin, @NotNull String file) {
        this.plugin = plugin;
        this.dirName = null;
        this.fileName = file;
    }

    public Config(@NotNull Plugin plugin, @Nullable String directory, @NotNull String file) {
        this.plugin = plugin;
        this.dirName = directory;
        this.fileName = file;
    }

    @NotNull
    public ConfigFileConfigurationAdapter getFileConfig() {
        return this.config;
    }

    @NotNull
    public File getFile() {
        if (this.file == null) {
            this.file = this.dirName != null ? new File(this.plugin.getDataFolder() + this.dirName, this.fileName != null ? this.fileName : "config.yml") : new File(this.plugin.getDataFolder(), this.fileName != null ? this.fileName : "config.yml");
        }
        return this.file;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Config setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
        return this;
    }

    public Config setUseUTF16() {
        this.defaultCharset = StandardCharsets.UTF_16;
        return this;
    }

    public boolean getLoadComments() {
        return this.loadComments;
    }

    public void setLoadComments(boolean loadComments) {
        this.loadComments = loadComments;
    }

    public boolean getAutosave() {
        return this.autosave;
    }

    @NotNull
    public Config setAutosave(boolean autosave) {
        this.autosave = autosave;
        return this;
    }

    public int getAutosaveInterval() {
        return this.autosaveInterval;
    }

    @NotNull
    public Config setAutosaveInterval(int autosaveInterval) {
        this.autosaveInterval = autosaveInterval;
        return this;
    }

    public boolean getAutoremove() {
        return this.autoremove;
    }

    @NotNull
    public Config setAutoremove(boolean autoremove) {
        this.autoremove = autoremove;
        return this;
    }

    @Nullable
    public ConfigFormattingRules.CommentStyle getDefaultNodeCommentFormat() {
        return this.defaultNodeCommentFormat;
    }

    @NotNull
    public Config setDefaultNodeCommentFormat(@Nullable ConfigFormattingRules.CommentStyle defaultNodeCommentFormat) {
        this.defaultNodeCommentFormat = defaultNodeCommentFormat;
        return this;
    }

    @Nullable
    public ConfigFormattingRules.CommentStyle getDefaultSectionCommentFormat() {
        return this.defaultSectionCommentFormat;
    }

    @NotNull
    public Config setDefaultSectionCommentFormat(@Nullable ConfigFormattingRules.CommentStyle defaultSectionCommentFormat) {
        this.defaultSectionCommentFormat = defaultSectionCommentFormat;
        return this;
    }

    public int getRootNodeSpacing() {
        return this.rootNodeSpacing;
    }

    @NotNull
    public Config setRootNodeSpacing(int rootNodeSpacing) {
        this.rootNodeSpacing = rootNodeSpacing;
        return this;
    }

    public int getCommentSpacing() {
        return this.commentSpacing;
    }

    @NotNull
    public Config setCommentSpacing(int commentSpacing) {
        this.commentSpacing = commentSpacing;
        return this;
    }

    @NotNull
    public Config setHeader(String ... description) {
        this.headerComment = description.length == 0 ? null : new Comment(description);
        return this;
    }

    @NotNull
    public Config setHeader(@Nullable ConfigFormattingRules.CommentStyle commentStyle, String ... description) {
        this.headerComment = description.length == 0 ? null : new Comment(commentStyle, description);
        return this;
    }

    @NotNull
    public Config setHeader(@Nullable List<String> description) {
        this.headerComment = description == null || description.isEmpty() ? null : new Comment(description);
        return this;
    }

    @NotNull
    public Config setHeader(@Nullable ConfigFormattingRules.CommentStyle commentStyle, @Nullable List<String> description) {
        this.headerComment = description == null || description.isEmpty() ? null : new Comment(commentStyle, description);
        return this;
    }

    @NotNull
    public List<String> getHeader() {
        if (this.headerComment != null) {
            return this.headerComment.getLines();
        }
        return Collections.emptyList();
    }

    public Config clearConfig(boolean clearDefaults) {
        this.root.values.clear();
        this.root.configComments.clear();
        if (clearDefaults) {
            this.root.defaultComments.clear();
            this.root.defaults.clear();
        }
        return this;
    }

    public Config clearDefaults() {
        this.root.defaultComments.clear();
        this.root.defaults.clear();
        return this;
    }

    public boolean load() {
        return this.load(this.getFile());
    }

    public boolean load(@NotNull File file) {
        Validate.notNull(file, "File cannot be null", new Object[0]);
        if (file.exists()) {
            boolean bl;
            BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
            try {
                Charset charset = TextUtils.detectCharset(stream, StandardCharsets.UTF_8);
                if (charset == StandardCharsets.UTF_16BE || charset == StandardCharsets.UTF_16LE) {
                    this.defaultCharset = StandardCharsets.UTF_16;
                }
                this.load(new InputStreamReader((InputStream)stream, charset));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | InvalidConfigurationException ex) {
                    (this.plugin != null ? this.plugin.getLogger() : Bukkit.getLogger()).log(Level.SEVERE, "Failed to load config file: " + file.getName(), ex);
                    return false;
                }
            }
            stream.close();
            return bl;
        }
        return true;
    }

    public void load(@NotNull Reader reader) throws IOException, InvalidConfigurationException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            boolean firstLine = true;
            while ((line = input.readLine()) != null) {
                if (firstLine) {
                    line = line.replaceAll("[\ufeff\ufffe\u200b]", "");
                    firstLine = false;
                }
                builder.append(line).append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    public void loadFromString(@NotNull String contents) throws InvalidConfigurationException {
        Map input;
        try {
            input = (Map)this.yaml.load(contents);
        }
        catch (YAMLException e2) {
            throw new InvalidConfigurationException((Throwable)e2);
        }
        catch (ClassCastException e3) {
            throw new InvalidConfigurationException("Top level is not a Map.");
        }
        if (input != null) {
            if (this.loadComments) {
                this.parseComments(contents, input);
            }
            this.convertMapsToSections(input, this);
        }
    }

    protected void convertMapsToSections(@NotNull Map<?, ?> input, @NotNull ConfigSection section) {
        for (Map.Entry<?, ?> entry : input.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.convertMapsToSections((Map)value, section.createSection(key));
                continue;
            }
            section.set(key, value);
        }
    }

    protected void parseComments(@NotNull String contents, @NotNull Map<?, ?> input) {
        BufferedReader in = new BufferedReader(new StringReader(contents));
        boolean insideScalar = false;
        boolean firstNode = true;
        int index = 0;
        LinkedList<String> currentPath = new LinkedList<String>();
        ArrayList<String> commentBlock = new ArrayList<String>();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                Matcher m;
                if (line.isEmpty()) {
                    if (!firstNode || commentBlock.isEmpty()) continue;
                    firstNode = false;
                    this.headerComment = Comment.loadComment(commentBlock);
                    commentBlock.clear();
                    continue;
                }
                if (line.trim().startsWith("#")) {
                    commentBlock.add(line.trim());
                    continue;
                }
                int lineOffset = Config.getOffset(line);
                if ((insideScalar &= lineOffset <= index) || !(m = this.yamlNode.matcher(line)).find()) continue;
                int depth = m.group(1).length() / this.indentation;
                while (depth < currentPath.size()) {
                    currentPath.removeLast();
                }
                currentPath.add(m.group(2));
                if (!commentBlock.isEmpty()) {
                    String path = currentPath.stream().collect(Collectors.joining(String.valueOf(this.pathChar)));
                    Comment comment = Comment.loadComment(commentBlock);
                    commentBlock.clear();
                    this.setComment(path, comment);
                }
                firstNode = false;
                index = lineOffset;
                if (!m.group(3).trim().equals("|") && !m.group(3).trim().equals(">")) continue;
                insideScalar = true;
            }
            if (!commentBlock.isEmpty()) {
                this.footerComment = Comment.loadComment(commentBlock);
                commentBlock.clear();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Config.class.getName()).log(Level.SEVERE, "Error parsing config comment", ex);
        }
    }

    public void deleteNonDefaultSettings() {
        List<String> defaultKeys = Arrays.asList(this.defaults.keySet().toArray(new String[0]));
        for (String key : this.values.keySet().toArray(new String[0])) {
            if (defaultKeys.contains(key)) continue;
            this.values.remove(key);
        }
    }

    @Override
    protected void onChange() {
        if (this.autosave) {
            this.delaySave();
        }
    }

    public void delaySave() {
        if (this.saveTask == null && (this.changed || this.hasNewDefaults())) {
            this.autosaveTimer = new Timer((this.plugin != null ? this.plugin.getName() + "-ConfigSave-" : "ConfigSave-") + this.getFile().getName());
            this.saveTask = new SaveTask();
            this.autosaveTimer.schedule((TimerTask)this.saveTask, (long)this.autosaveInterval * 1000L);
        }
    }

    public boolean saveChanges() {
        boolean saved = true;
        if (this.changed || this.hasNewDefaults()) {
            saved = this.save();
        }
        if (this.saveTask != null) {
            this.saveTask.cancel();
            this.autosaveTimer.cancel();
            this.saveTask = null;
            this.autosaveTimer = null;
        }
        return saved;
    }

    boolean hasNewDefaults() {
        if (this.file != null && !this.file.exists()) {
            return true;
        }
        for (String def : this.defaults.keySet()) {
            if (this.values.containsKey(def)) continue;
            return true;
        }
        return false;
    }

    public boolean save() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
            this.autosaveTimer.cancel();
            this.saveTask = null;
            this.autosaveTimer = null;
        }
        return this.save(this.getFile());
    }

    public boolean save(@NotNull String file) {
        Validate.notNull(file, "File cannot be null", new Object[0]);
        return this.save(new File(file));
    }

    public boolean save(@NotNull File file) {
        Validate.notNull(file, "File cannot be null", new Object[0]);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        String data = this.saveToString();
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), this.defaultCharset);){
            writer.write(data);
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    @NotNull
    public String saveToString() {
        try {
            String dump;
            if (this.autoremove) {
                this.deleteNonDefaultSettings();
            }
            this.yamlOptions.setIndent(this.indentation);
            this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yamlOptions.setSplitLines(false);
            this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            StringWriter str = new StringWriter();
            if (this.headerComment != null) {
                this.headerComment.writeComment(str, 0, ConfigFormattingRules.CommentStyle.BLOCKED);
                str.write("\n");
            }
            if (!(dump = this.yaml.dump(this.getValues(false))).equals(BLANK_CONFIG)) {
                this.writeComments(dump, str);
            }
            if (this.footerComment != null) {
                str.write("\n");
                this.footerComment.writeComment(str, 0, ConfigFormattingRules.CommentStyle.BLOCKED);
            }
            return str.toString();
        }
        catch (Throwable ex) {
            Logger.getLogger(Config.class.getName()).log(Level.SEVERE, "Error saving config", ex);
            this.delaySave();
            return "";
        }
    }

    protected void writeComments(String data, Writer out) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new StringReader(data));
        boolean insideScalar = false;
        boolean firstNode = true;
        int index = 0;
        LinkedList<String> currentPath = new LinkedList<String>();
        while ((line = in.readLine()) != null) {
            Matcher m;
            if (line.trim().startsWith("#") || line.isEmpty()) continue;
            int lineOffset = Config.getOffset(line);
            if (!(insideScalar &= lineOffset <= index) && (m = this.yamlNode.matcher(line)).find()) {
                int depth = m.group(1).length() / this.indentation;
                while (depth < currentPath.size()) {
                    currentPath.removeLast();
                }
                currentPath.add(m.group(2));
                String path = currentPath.stream().collect(Collectors.joining(String.valueOf(this.pathChar)));
                if (!firstNode && depth == 0 && this.rootNodeSpacing > 0) {
                    out.write(new String(new char[this.rootNodeSpacing]).replace("\u0000", "\n"));
                }
                firstNode = false;
                Comment comment = this.getComment(path);
                if (comment != null) {
                    ConfigFormattingRules.CommentStyle style;
                    if (depth != 0) {
                        out.write(new String(new char[this.commentSpacing]).replace("\u0000", "\n"));
                    }
                    if ((style = comment.getCommentStyle()) == null) {
                        if (!m.group(3).trim().isEmpty()) {
                            style = this.defaultNodeCommentFormat;
                        } else {
                            in.mark(1000);
                            String nextLine = in.readLine().trim();
                            in.reset();
                            style = nextLine.startsWith("-") ? this.defaultNodeCommentFormat : this.defaultSectionCommentFormat;
                        }
                    }
                    comment.writeComment(out, lineOffset, style);
                }
                index = lineOffset;
                if (m.group(3).trim().equals("|") || m.group(3).trim().equals(">")) {
                    insideScalar = true;
                }
            }
            out.write(line);
            out.write("\n");
        }
    }

    protected static int getOffset(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ' ') continue;
            return i;
        }
        return -1;
    }

    class SaveTask
    extends TimerTask {
        SaveTask() {
        }

        @Override
        public void run() {
            Config.this.saveChanges();
        }
    }
}

