/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.compatibility;

import com.craftaro.core.compatibility.ClassMapping;
import com.craftaro.core.compatibility.ServerVersion;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Biome;

public enum CompatibleBiome {
    MANGROVE_SWAMP(ServerVersion.V1_19, new Version[0]),
    DEEP_DARK(ServerVersion.V1_19, new Version[0]),
    DRIPSTONE_CAVES(ServerVersion.V1_17, new Version[0]),
    LUSH_CAVES(ServerVersion.V1_17, new Version[0]),
    SOUL_SAND_VALLEY(ServerVersion.V1_16, new Version[0]),
    CRIMSON_FOREST(ServerVersion.V1_16, new Version[0]),
    WARPED_FOREST(ServerVersion.V1_16, new Version[0]),
    BASALT_DELTAS(ServerVersion.V1_16, new Version[0]),
    BADLANDS(ServerVersion.V1_13, CompatibleBiome.v("MESA")),
    BADLANDS_PLATEAU(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MESA_CLEAR_ROCK"), CompatibleBiome.v("MESA_PLATEAU")),
    BAMBOO_JUNGLE(ServerVersion.V1_14, new Version[0]),
    BAMBOO_JUNGLE_HILLS(ServerVersion.V1_14, new Version[0]),
    BEACH(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "BEACHES")),
    BIRCH_FOREST,
    BIRCH_FOREST_HILLS,
    COLD_OCEAN(ServerVersion.V1_13, new Version[0]),
    DARK_FOREST(ServerVersion.V1_13, CompatibleBiome.v("ROOFED_FOREST")),
    DARK_FOREST_HILLS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_ROOFED_FOREST")),
    DEEP_COLD_OCEAN(ServerVersion.V1_13, new Version[0]),
    DEEP_FROZEN_OCEAN(ServerVersion.V1_13, new Version[0]),
    DEEP_LUKEWARM_OCEAN(ServerVersion.V1_13, new Version[0]),
    DEEP_OCEAN,
    DEEP_WARM_OCEAN(ServerVersion.V1_13, new Version[0]),
    DESERT,
    DESERT_HILLS,
    DESERT_LAKES(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_DESERT")),
    END_BARRENS(ServerVersion.V1_13, new Version[0]),
    END_HIGHLANDS(ServerVersion.V1_13, new Version[0]),
    END_MIDLANDS(ServerVersion.V1_13, new Version[0]),
    ERODED_BADLANDS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_MESA")),
    FLOWER_FOREST,
    FOREST,
    FROZEN_OCEAN,
    FROZEN_RIVER,
    GIANT_SPRUCE_TAIGA(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_REDWOOD_TAIGA")),
    GIANT_SPRUCE_TAIGA_HILLS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_REDWOOD_TAIGA_HILLS")),
    GIANT_TREE_TAIGA(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "REDWOOD_TAIGA")),
    GIANT_TREE_TAIGA_HILLS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "REDWOOD_TAIGA_HILLS")),
    GRAVELLY_MOUNTAINS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_EXTREME_HILLS ")),
    ICE_SPIKES(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_ICE_FLATS")),
    JUNGLE,
    JUNGLE_EDGE,
    JUNGLE_HILLS,
    LUKEWARM_OCEAN,
    MODIFIED_BADLANDS_PLATEAU(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_MESA_CLEAR_ROCK")),
    MODIFIED_GRAVELLY_MOUNTAINS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_EXTREME_HILLS_WITH_TREES"), CompatibleBiome.v("EXTREME_HILLS_MOUNTAINS")),
    MODIFIED_JUNGLE(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_JUNGLE"), CompatibleBiome.v("JUNGLE_MOUNTAINS")),
    MODIFIED_JUNGLE_EDGE(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_JUNGLE_EDGE"), CompatibleBiome.v("JUNGLE_EDGE_MOUNTAINS")),
    MODIFIED_WOODED_BADLANDS_PLATEAU(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_MESA_ROCK"), CompatibleBiome.v("MESA_PLATEAU_FOREST_MOUNTAINS")),
    MOUNTAINS(ServerVersion.V1_13, CompatibleBiome.v("EXTREME_HILLS")),
    MOUNTAIN_EDGE(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "SMALLER_EXTREME_HILLS")),
    MUSHROOM_FIELDS(ServerVersion.V1_13, CompatibleBiome.v("MUSHROOM_ISLAND")),
    MUSHROOM_FIELD_SHORE(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUSHROOM_ISLAND_SHORE"), CompatibleBiome.v("MUSHROOM_SHORE")),
    NETHER_WASTES(ServerVersion.V1_16, CompatibleBiome.v(ServerVersion.V1_13, "NETHER"), CompatibleBiome.v("HELL")),
    OCEAN,
    PLAINS,
    RIVER,
    SAVANNA,
    SAVANNA_PLATEAU(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "SAVANNA_ROCK"), CompatibleBiome.v("SAVANNA_PLATEAU")),
    SHATTERED_SAVANNA(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_SAVANNA"), CompatibleBiome.v("SAVANNA_MOUNTAINS")),
    SHATTERED_SAVANNA_PLATEAU(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_SAVANNA_ROCK"), CompatibleBiome.v("SAVANNA_PLATEAU_MOUNTAINS")),
    SMALL_END_ISLANDS(ServerVersion.V1_13, new Version[0]),
    SNOWY_BEACH(ServerVersion.V1_13, CompatibleBiome.v("COLD_BEACH")),
    SNOWY_MOUNTAINS(ServerVersion.V1_13, CompatibleBiome.v("ICE_MOUNTAINS")),
    SNOWY_TAIGA(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "TAIGA_COLD")),
    SNOWY_TAIGA_HILLS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "TAIGA_COLD_HILLS"), CompatibleBiome.v("COLD_TAIGA_HILLS")),
    SNOWY_TAIGA_MOUNTAINS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_TAIGA_COLD"), CompatibleBiome.v("COLD_TAIGA_MOUNTAINS")),
    SNOWY_TUNDRA(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "ICE_FLATS")),
    STONE_SHORE(ServerVersion.V1_13, CompatibleBiome.v("STONE_BEACH")),
    SUNFLOWER_PLAINS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_PLAINS"), CompatibleBiome.v("SUNFLOWER_PLAINS")),
    SWAMP(ServerVersion.V1_13, CompatibleBiome.v("SWAMPLAND")),
    SWAMP_HILLS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_SWAMPLAND"), CompatibleBiome.v("SWAMPLAND_MOUNTAINS")),
    TAIGA,
    TAIGA_HILLS,
    TAIGA_MOUNTAINS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "TAIGA_MOUNTAINS"), CompatibleBiome.v("MUTATED_TAIGA")),
    TALL_BIRCH_FOREST(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_BIRCH_FOREST"), CompatibleBiome.v("BIRCH_FOREST_MOUNTAINS")),
    TALL_BIRCH_HILLS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MUTATED_BIRCH_FOREST_HILLS"), CompatibleBiome.v("MESA_PLATEAU_FOREST_MOUNTAINS")),
    THE_END(ServerVersion.V1_13, CompatibleBiome.v("SKY")),
    THE_VOID(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "VOID")),
    WARM_OCEAN(ServerVersion.V1_13, new Version[0]),
    WOODED_BADLANDS_PLATEAU(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "MESA_ROCK"), CompatibleBiome.v("MESA_PLATEAU_FOREST")),
    WOODED_HILLS(ServerVersion.V1_13, CompatibleBiome.v("FOREST_HILLS")),
    WOODED_MOUNTAINS(ServerVersion.V1_13, CompatibleBiome.v(ServerVersion.V1_9, "EXTREME_HILLS_WITH_TREES"), CompatibleBiome.v("EXTREME_HILLS_PLUS"));

    private static final boolean isAbove1_16_R1;
    private static final Map<String, CompatibleBiome> lookupMap;
    private static final Set<CompatibleBiome> compatibleBiomes;
    private final Deque<Version> versions = new ArrayDeque<Version>();
    private static Method methodGetHandle;
    private static Method methodMarkDirty;
    private static Method methodBiomeToBiomeBase;
    private static Method methodGetBiomeIndex;
    private static Method methodSetBiome;
    private static Field fieldStorageRegistry;

    private CompatibleBiome() {
        this.versions.add(CompatibleBiome.v(ServerVersion.UNKNOWN, this.name()));
    }

    private CompatibleBiome(ServerVersion version, Version ... versions) {
        this.versions.add(CompatibleBiome.v(version, this.name()));
        this.versions.addAll(Arrays.asList(versions));
    }

    public boolean isCompatible() {
        return this.getBiome() != null;
    }

    public List<Version> getVersions() {
        return new LinkedList<Version>(this.versions);
    }

    public Biome getBiome() {
        try {
            for (Version version : this.versions) {
                if (!ServerVersion.isServerVersionAtLeast(version.version)) continue;
                return Biome.valueOf((String)version.biome);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static Set<CompatibleBiome> getCompatibleBiomes() {
        return compatibleBiomes;
    }

    public static CompatibleBiome getBiome(Biome biome) {
        return biome == null ? null : lookupMap.get(biome.name());
    }

    public static CompatibleBiome getBiome(String name) {
        return name == null ? null : lookupMap.get(name.toUpperCase());
    }

    public void setBiome(Chunk chunk) throws InvocationTargetException, IllegalAccessException {
        Object nmsChunk = null;
        Object biomeStorage = null;
        Object biomeBase = null;
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_15) && ServerVersion.isServerVersionBelow(ServerVersion.V1_18)) {
            nmsChunk = methodGetHandle.invoke((Object)chunk, new Object[0]);
            biomeStorage = methodGetBiomeIndex.invoke(nmsChunk, new Object[0]);
            if (isAbove1_16_R1) {
                Object registry = fieldStorageRegistry.get(biomeStorage);
                biomeBase = methodBiomeToBiomeBase.invoke(null, registry, this.getBiome());
            } else {
                biomeBase = methodBiomeToBiomeBase.invoke(null, this.getBiome());
            }
        }
        World world = chunk.getWorld();
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        for (int x = chunkX << 4; x < (chunkX << 4) + 16; ++x) {
            for (int z = chunkZ << 4; z < (chunkZ << 4) + 16; ++z) {
                for (int y = 0; y < world.getMaxHeight(); ++y) {
                    if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_18)) {
                        chunk.getWorld().setBiome(x, y, z, this.getBiome());
                        continue;
                    }
                    if (!ServerVersion.isServerVersionAtLeast(ServerVersion.V1_15) || !ServerVersion.isServerVersionBelow(ServerVersion.V1_18)) continue;
                    methodSetBiome.invoke(biomeStorage, x >> 2, y >> 2, z >> 2, biomeBase);
                }
                if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_15)) continue;
                chunk.getWorld().setBiome(x, z, this.getBiome());
            }
        }
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_15) && ServerVersion.isServerVersionBelow(ServerVersion.V1_18)) {
            methodMarkDirty.invoke(nmsChunk, new Object[0]);
        }
    }

    public void setBiome(World world, int x, int y, int z) {
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_15)) {
            world.setBiome(x, y, z, this.getBiome());
            return;
        }
        world.setBiome(x, z, this.getBiome());
    }

    private static Version v(ServerVersion version, String biome) {
        return new Version(version, biome);
    }

    private static Version v(String biome) {
        return new Version(ServerVersion.UNKNOWN, biome);
    }

    static {
        isAbove1_16_R1 = ServerVersion.isServerVersionAtLeast(ServerVersion.V1_16) && !ServerVersion.getServerVersionString().equals("v1_16_R1");
        lookupMap = new HashMap<String, CompatibleBiome>();
        compatibleBiomes = new HashSet<CompatibleBiome>();
        for (CompatibleBiome biome : CompatibleBiome.values()) {
            for (Version version : biome.getVersions()) {
                lookupMap.put(version.biome, biome);
            }
        }
        for (CompatibleBiome biome : CompatibleBiome.values()) {
            if (!biome.isCompatible()) continue;
            compatibleBiomes.add(biome);
        }
        if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_15) && ServerVersion.isServerVersionBelow(ServerVersion.V1_18)) {
            try {
                Class<?> classBiomeBase = ClassMapping.BIOME_BASE.getClazz();
                Class<?> classCraftChunk = ClassMapping.CRAFT_CHUNK.getClazz();
                Class<?> classCraftBlock = ClassMapping.CRAFT_BLOCK.getClazz();
                Class<?> classChunk = ClassMapping.CHUNK.getClazz();
                Class<?> classBiomeStorage = ClassMapping.BIOME_STORAGE.getClazz();
                Class<?> classIRegistry = ClassMapping.I_REGISTRY.getClazz();
                methodBiomeToBiomeBase = isAbove1_16_R1 ? classCraftBlock.getMethod("biomeToBiomeBase", classIRegistry, Biome.class) : classCraftBlock.getMethod("biomeToBiomeBase", Biome.class);
                methodGetHandle = classCraftChunk.getMethod("getHandle", new Class[0]);
                methodMarkDirty = classChunk.getMethod("markDirty", new Class[0]);
                methodGetBiomeIndex = classChunk.getMethod("getBiomeIndex", new Class[0]);
                methodSetBiome = classBiomeStorage.getMethod("setBiome", Integer.TYPE, Integer.TYPE, Integer.TYPE, classBiomeBase);
                try {
                    fieldStorageRegistry = classBiomeStorage.getDeclaredField("registry");
                }
                catch (NoSuchFieldException ex) {
                    fieldStorageRegistry = classBiomeStorage.getDeclaredField("g");
                }
                fieldStorageRegistry.setAccessible(true);
            }
            catch (NoSuchFieldException | NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class Version {
        final ServerVersion version;
        final String biome;

        public Version(ServerVersion version, String biome) {
            this.version = version;
            this.biome = biome;
        }
    }
}

