/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.commands;

import com.craftaro.core.compatibility.EntityNamespace;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectorArguments {
    static Pattern selectorPattern = Pattern.compile("^(@[apers])(\\[(.*?)])?$");
    static Pattern selectorRangePattern = Pattern.compile("^([0-9]{1,9}(\\.[0-9]{1,9})?)?(\\.\\.)?([0-9]{1,9}(\\.[0-9]{1,9})?)?$");
    protected final CommandSender sender;
    protected final SelectorType selector;
    protected double rangeMin = 0.0;
    protected double rangeMax = Double.POSITIVE_INFINITY;
    protected EntityType entityType;

    @Nullable
    public static SelectorArguments parseSelector(@NotNull CommandSender sender, @NotNull String argument) {
        if (!(sender instanceof BlockCommandSender) && !(sender instanceof Player)) {
            return null;
        }
        Matcher matcher = selectorPattern.matcher(argument);
        if (!matcher.find()) {
            return null;
        }
        SelectorType type = SelectorType.getType(matcher.group(1));
        if (type == null) {
            return null;
        }
        SelectorArguments selector = new SelectorArguments(sender, type);
        if (matcher.group(3) != null) {
            selector.parseArguments(matcher.group(3));
        }
        return selector;
    }

    public SelectorArguments(CommandSender sender, SelectorType type) {
        this.sender = sender;
        this.selector = type;
    }

    private void parseArguments(String selectorArgs) {
        String[] args;
        for (String s : args = selectorArgs.split(",")) {
            if (!s.contains("=")) continue;
            String[] v = s.split("=");
            if (v[0].equals("distance")) {
                Matcher distGroup = selectorRangePattern.matcher(v[1]);
                if (!distGroup.find()) continue;
                if (distGroup.group(1) != null) {
                    this.rangeMin = Double.parseDouble(distGroup.group(1));
                }
                if (distGroup.group(3) == null) {
                    this.rangeMax = this.rangeMin;
                    continue;
                }
                if (distGroup.group(4) == null) continue;
                this.rangeMax = Double.parseDouble(distGroup.group(4));
                continue;
            }
            if (!v[0].equals("type")) continue;
            this.entityType = EntityNamespace.minecraftToBukkit(v[1]);
        }
    }

    public Collection<Entity> getSelection() {
        Location location = this.sender instanceof Player ? ((Player)this.sender).getLocation() : ((BlockCommandSender)this.sender).getBlock().getLocation();
        Collection<Entity> list = this.preSelect(location);
        if (list.isEmpty()) {
            return list;
        }
        List<Entity> list2 = this.filter(location, list);
        if (list2.isEmpty()) {
            return list2;
        }
        switch (this.selector.ordinal()) {
            case 0: {
                list2.sort((o1, o2) -> (int)(o1.getLocation().distanceSquared(location) - o2.getLocation().distanceSquared(location)));
                return Arrays.asList(list2.get(0));
            }
            case 1: {
                Collections.shuffle(list2);
                return Arrays.asList(list2.get(0));
            }
            case 2: 
            case 3: 
            case 4: {
                return list2;
            }
        }
        return list2;
    }

    protected Collection<Entity> preSelect(Location location) {
        switch (this.selector.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return this.rangeMax == Double.POSITIVE_INFINITY ? location.getWorld().getEntitiesByClasses(new Class[]{Player.class}) : (Collection)location.getWorld().getNearbyEntities(location, this.rangeMax * 2.0, this.rangeMax * 2.0, this.rangeMax * 2.0).stream().filter(Player.class::isInstance).collect(Collectors.toSet());
            }
            case 3: {
                return this.rangeMax == Double.POSITIVE_INFINITY ? location.getWorld().getEntities() : location.getWorld().getNearbyEntities(location, this.rangeMax * 2.0, this.rangeMax * 2.0, this.rangeMax * 2.0);
            }
            case 4: {
                return this.sender instanceof Entity ? Arrays.asList((Entity)this.sender) : Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    protected List<Entity> filter(Location location, Collection<Entity> list) {
        Stream<Entity> stream = list.stream().filter(p -> this.rangeMin == 0.0 || p.getLocation().distance(location) > this.rangeMin).filter(e -> this.entityType == null || e.getType() == this.entityType);
        return stream.collect(Collectors.toList());
    }

    public static enum SelectorType {
        PLAYER,
        RANDOM_PLAYER,
        ALL_PLAYER,
        ALL_ENTITIES,
        SELF;


        public static SelectorType getType(String str) {
            if (str != null) {
                switch (str.toLowerCase()) {
                    case "@p": {
                        return PLAYER;
                    }
                    case "@r": {
                        return RANDOM_PLAYER;
                    }
                    case "@a": {
                        return ALL_PLAYER;
                    }
                    case "@e": {
                        return ALL_ENTITIES;
                    }
                    case "@s": {
                        return SELF;
                    }
                }
            }
            return null;
        }
    }
}

