/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.chat;

import com.craftaro.core.chat.MiniMessagePlaceholder;
import com.craftaro.core.compatibility.ServerProject;
import com.craftaro.core.compatibility.ServerVersion;
import com.craftaro.core.third_party.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.craftaro.core.third_party.net.kyori.adventure.text.Component;
import com.craftaro.core.third_party.net.kyori.adventure.text.format.TextDecoration;
import com.craftaro.core.third_party.net.kyori.adventure.text.minimessage.MiniMessage;
import com.craftaro.core.third_party.net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import com.craftaro.core.third_party.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.craftaro.core.third_party.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.craftaro.core.third_party.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.craftaro.core.third_party.net.kyori.adventure.title.Title;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AdventureUtils {
    private static Method displayNameMethod = null;
    private static Method setLoreMethod = null;
    private static Method getLoreMethod = null;
    private static Object gsonComponentSerializer;
    private static Method gsonDeserializeMethod;

    public static String convertToJson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    public static Object convertToOriginalComponent(String json) {
        try {
            return gsonDeserializeMethod.invoke(gsonComponentSerializer, json);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object convertToOriginalComponent(Component component) {
        try {
            return gsonDeserializeMethod.invoke(gsonComponentSerializer, AdventureUtils.convertToJson(component));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object convertToOriginalComponent(List<Component> components) {
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            for (Component component : components) {
                list.add(AdventureUtils.convertToOriginalComponent(component));
            }
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object convertToOriginalComponent(Component ... components) {
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            for (Component component : components) {
                list.add(AdventureUtils.convertToOriginalComponent(component));
            }
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void sendMessage(Plugin plugin, Component message, CommandSender ... target) {
        try (BukkitAudiences bukkitAudiences = BukkitAudiences.create(plugin);){
            for (CommandSender sender : target) {
                bukkitAudiences.sender(sender).sendMessage(message);
            }
        }
    }

    public static void formatItemName(ItemStack item, String name) {
        AdventureUtils.formatItemName(item, AdventureUtils.formatComponent(name));
    }

    public static void formatItemLore(ItemStack item, List<String> lore) {
        AdventureUtils.formatItemLore(item, lore.toArray(new String[0]));
    }

    public static void formatItemLore(ItemStack item, String ... lore) {
        AdventureUtils.formatItemLore(item, AdventureUtils.formatComponent(lore), new String[0]);
    }

    public static void formatItemLore(ItemStack item, List<Component> lore, String ... unused) {
        AdventureUtils.formatItemLore(item, lore.toArray(new Component[0]));
    }

    public static void formatItemName(ItemStack item, Component name) {
        AdventureUtils.setItemName(item, name);
    }

    public static void formatItemLore(ItemStack item, Component ... lore) {
        AdventureUtils.setItemLore(item, lore);
    }

    public static void appendItemLore(ItemStack item, List<Component> lore) {
        List<Component> currentLore = new ArrayList<Component>();
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasLore()) {
            if (AdventureUtils.isMiniMessageEnabled()) {
                try {
                    currentLore = (List)getLoreMethod.invoke((Object)meta, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                currentLore = AdventureUtils.formatComponent(meta.getLore());
            }
        }
        currentLore.addAll(lore);
        AdventureUtils.setItemLore(item, currentLore.toArray(new Component[0]));
    }

    public static boolean isMiniMessageEnabled() {
        return ServerProject.isServer(ServerProject.PAPER) && ServerVersion.isServerVersionAtLeast(ServerVersion.V1_16) && displayNameMethod != null && setLoreMethod != null;
    }

    private static void setItemName(ItemStack item, Component name) {
        if (name == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (AdventureUtils.isMiniMessageEnabled()) {
            try {
                displayNameMethod.invoke((Object)meta, AdventureUtils.convertToOriginalComponent(name));
                item.setItemMeta(meta);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        meta.setDisplayName(AdventureUtils.toLegacy(name));
        item.setItemMeta(meta);
    }

    private static void setItemLore(ItemStack item, Component ... lore) {
        if (lore == null || lore.length == 0) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (AdventureUtils.isMiniMessageEnabled()) {
            try {
                setLoreMethod.invoke((Object)meta, AdventureUtils.convertToOriginalComponent(lore));
                item.setItemMeta(meta);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        meta.setLore(AdventureUtils.toLegacy(lore));
        item.setItemMeta(meta);
    }

    public static Component formatComponent(String text) {
        MiniMessage miniMessage = MiniMessage.builder().build();
        Object component = MiniMessage.miniMessage().deserialize(AdventureUtils.replaceLegacy(text));
        if (!component.hasDecoration(TextDecoration.ITALIC)) {
            component = component.decoration(TextDecoration.ITALIC, false);
        }
        return component;
    }

    public static Component formatComponent(String text, MiniMessagePlaceholder ... placeholders) {
        MiniMessage miniMessage = MiniMessage.builder().editTags(builder -> Arrays.stream(placeholders).forEach(placeholder -> builder.resolver(Placeholder.parsed(placeholder.getPlaceholder(), placeholder.getValue())))).build();
        Object component = miniMessage.deserialize(AdventureUtils.replaceLegacy(text));
        if (!component.hasDecoration(TextDecoration.ITALIC)) {
            component = component.decoration(TextDecoration.ITALIC, false);
        }
        return component;
    }

    public static Component formatComponent(String text, List<MiniMessagePlaceholder> placeholders) {
        return AdventureUtils.formatComponent(text, placeholders.toArray(new MiniMessagePlaceholder[0]));
    }

    public static List<Component> formatComponent(List<String> list) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (String line : list) {
            result.add(AdventureUtils.formatComponent(line));
        }
        return result;
    }

    public static List<Component> formatComponent(String ... list) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (String line : list) {
            result.add(AdventureUtils.formatComponent(line));
        }
        return result;
    }

    public static List<Component> formatComponent(List<String> list, MiniMessagePlaceholder ... placeholders) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (String line : list) {
            result.add(AdventureUtils.formatComponent(line, placeholders));
        }
        return result;
    }

    public static List<Component> formatComponent(List<String> list, List<MiniMessagePlaceholder> placeholders) {
        return AdventureUtils.formatComponent(list, placeholders.toArray(new MiniMessagePlaceholder[0]));
    }

    public static String formatLegacy(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)LegacyComponentSerializer.legacyAmpersand().serialize((Component)MiniMessage.miniMessage().deserialize(AdventureUtils.replaceLegacy(text))));
    }

    public static List<String> formatLegacy(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : list) {
            result.add(AdventureUtils.formatLegacy(line));
        }
        return result;
    }

    public static List<String> formatLegacy(String ... list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : list) {
            result.add(AdventureUtils.formatLegacy(line));
        }
        return result;
    }

    public static String toLegacy(Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static List<String> toLegacy(List<Component> components) {
        ArrayList<String> list = new ArrayList<String>();
        for (Component component : components) {
            list.add(AdventureUtils.toLegacy(component));
        }
        return list;
    }

    public static List<String> toLegacy(Component ... components) {
        ArrayList<String> list = new ArrayList<String>();
        for (Component component : components) {
            list.add(AdventureUtils.toLegacy(component));
        }
        return list;
    }

    public static String replaceLegacy(String legacy) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < legacy.length(); ++i) {
            char current = legacy.charAt(i);
            char next = legacy.charAt(i == legacy.length() - 1 ? i : i + 1);
            if (current == '\u00a7' || current == '&') {
                if (next == 'x' && legacy.length() > i + 13) {
                    builder.append("<color:#");
                    builder.append(legacy.charAt(i + 3));
                    builder.append(legacy.charAt(i + 5));
                    builder.append(legacy.charAt(i + 7));
                    builder.append(legacy.charAt(i + 9));
                    builder.append(legacy.charAt(i + 11));
                    builder.append(legacy.charAt(i + 13));
                    builder.append(">");
                    i += 13;
                    continue;
                }
                String color = AdventureUtils.getColor(next);
                if (color == null) {
                    builder.append(current);
                    continue;
                }
                builder.append(color);
                ++i;
                continue;
            }
            builder.append(current);
        }
        return builder.toString();
    }

    public static String getColor(char c) {
        ChatColor color = ChatColor.getByChar((char)c);
        if (color == null) {
            return null;
        }
        switch (c) {
            case '0': {
                return "<black>";
            }
            case '1': {
                return "<dark_blue>";
            }
            case '2': {
                return "<dark_green>";
            }
            case '3': {
                return "<dark_aqua>";
            }
            case '4': {
                return "<dark_red>";
            }
            case '5': {
                return "<dark_purple>";
            }
            case '6': {
                return "<gold>";
            }
            case '7': {
                return "<gray>";
            }
            case '8': {
                return "<dark_gray>";
            }
            case '9': {
                return "<blue>";
            }
            case 'a': {
                return "<green>";
            }
            case 'b': {
                return "<aqua>";
            }
            case 'c': {
                return "<red>";
            }
            case 'd': {
                return "<light_purple>";
            }
            case 'e': {
                return "<yellow>";
            }
            case 'f': {
                return "<white>";
            }
            case 'k': {
                return "<obfuscated>";
            }
            case 'l': {
                return "<b>";
            }
            case 'm': {
                return "<st>";
            }
            case 'n': {
                return "<u>";
            }
            case 'o': {
                return "<i>";
            }
            case 'r': {
                return "<reset>";
            }
        }
        return null;
    }

    public static String clear(String msg) {
        msg = msg.replaceAll("&[0-9abcdefklmnor]", "");
        msg = msg.replaceAll("\u00a7[0-9abcdefklmnor]", "");
        msg = msg.replaceAll("&#[0-9a-fA-F]{6}", "");
        return PlainTextComponentSerializer.plainText().serialize((Component)MiniMessage.miniMessage().deserialize(msg));
    }

    public static String clear(Component component) {
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static List<Component> splitComponent(Component message, char c) {
        ArrayList<Component> components = new ArrayList<Component>();
        StringBuilder builder = new StringBuilder();
        for (char character : AdventureUtils.toLegacy(message).toCharArray()) {
            if (character == c) {
                components.add(AdventureUtils.formatComponent(builder.toString()));
                builder = new StringBuilder();
                continue;
            }
            builder.append(character);
        }
        components.add(AdventureUtils.formatComponent(builder.toString()));
        return components;
    }

    public static Component formatPlaceholder(Component message, MiniMessagePlaceholder ... placeholder) {
        return message.replaceText(builder -> {
            for (MiniMessagePlaceholder place : placeholder) {
                builder.matchLiteral(place.getPlaceholder()).replacement(AdventureUtils.formatComponent(place.getValue()));
            }
        });
    }

    public static Title createTitle(Component title, Component subtitle) {
        return Title.title(title, subtitle, Title.Times.times(Duration.of(500L, ChronoUnit.MILLIS), Duration.of(3500L, ChronoUnit.MILLIS), Duration.of(1000L, ChronoUnit.MILLIS)));
    }

    public static Title createTitle(Component title, Component subtitle, int fadeIn, int stay, int fadeOut) {
        return Title.title(title, subtitle, Title.Times.times(Duration.of((long)fadeIn * 50L, ChronoUnit.MILLIS), Duration.of((long)stay * 50L, ChronoUnit.MILLIS), Duration.of((long)fadeOut * 50L, ChronoUnit.MILLIS)));
    }

    public static Title createTitle(Component title, Component subtitle, Title.Times times) {
        return Title.title(title, subtitle, times);
    }

    public static void sendTitle(JavaPlugin hijackedPlugin, Title title, CommandSender sender) {
        try (BukkitAudiences bukkitAudiences = BukkitAudiences.create((Plugin)hijackedPlugin);){
            bukkitAudiences.sender(sender).showTitle(title);
        }
    }

    public static void sendActionBar(JavaPlugin hijackedPlugin, Component message, CommandSender sender) {
        try (BukkitAudiences bukkitAudiences = BukkitAudiences.create((Plugin)hijackedPlugin);){
            bukkitAudiences.sender(sender).sendActionBar(message);
        }
    }

    static {
        if (ServerProject.isServer(ServerProject.PAPER) && ServerVersion.isServerVersionAtLeast(ServerVersion.V1_18)) {
            try {
                Class<?> componentClass = Class.forName("net;kyori;adventure;text;Component".replace(";", "."));
                displayNameMethod = ItemMeta.class.getDeclaredMethod("displayName", componentClass);
                setLoreMethod = ItemMeta.class.getDeclaredMethod("lore", List.class);
                setLoreMethod = ItemMeta.class.getDeclaredMethod("lore", new Class[0]);
                gsonComponentSerializer = Class.forName("net;kyori;adventure;text;serializer;gson;GsonComponentSerializer".replace(";", ".")).getDeclaredMethod("gson", new Class[0]).invoke(null, new Object[0]);
                gsonDeserializeMethod = gsonComponentSerializer.getClass().getDeclaredMethod("deserialize", String.class);
                gsonDeserializeMethod.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

