/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ToolUtilCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class ToolUtilCommandsRegistration
implements CommandRegistration<ToolUtilCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Boolean> boolean_Key = Key.of(Boolean.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private ToolUtilCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument superPickaxePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"superPickaxe"), (Component)TextComponent.of((String)"The new super pickaxe state")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(boolean_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask to set")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to use")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument rangePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"range"), (Component)TextComponent.of((String)"The range of the brush")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument sizePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The size of the brush")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The trace mask to set")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();

    private ToolUtilCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ToolUtilCommandsRegistration builder() {
        return new ToolUtilCommandsRegistration();
    }

    public ToolUtilCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ToolUtilCommandsRegistration containerInstance(ToolUtilCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public ToolUtilCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public ToolUtilCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/", b -> {
            b.aliases((Collection)ImmutableList.of((Object)","));
            b.description((Component)TextComponent.of((String)"Toggle the super pickaxe function"));
            b.parts((Collection)ImmutableList.of((Object)this.superPickaxePart));
            b.action(this::cmd$_);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"togglePickaxe", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("mask", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set the brush mask"));
            b.parts((Collection)ImmutableList.of((Object)this.maskPart));
            b.action(this::cmd$mask);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"mask", (Class[])new Class[]{Player.class, LocalSession.class, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("material", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/material"));
            b.description((Component)TextComponent.of((String)"Set the brush material"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart));
            b.action(this::cmd$material);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"material", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("range", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set the brush range"));
            b.parts((Collection)ImmutableList.of((Object)this.rangePart));
            b.action(this::cmd$range);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"range", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("size", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set the brush size"));
            b.parts((Collection)ImmutableList.of((Object)this.sizePart));
            b.action(this::cmd$size);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"size", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("tracemask", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set the mask used to stop tool traces"));
            b.parts((Collection)ImmutableList.of((Object)this.maskPart2));
            b.action(this::cmd$tracemask);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"traceMask", (Class[])new Class[]{Player.class, LocalSession.class, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$_(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"togglePickaxe", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.togglePickaxe(this.extract$player(parameters), this.extract$session(parameters), this.extract$superPickaxe(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$mask(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"mask", (Class[])new Class[]{Player.class, LocalSession.class, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.mask(this.extract$player(parameters), this.extract$session(parameters), this.extract$mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$material(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"material", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.material(this.extract$player(parameters), this.extract$session(parameters), this.extract$pattern(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$range(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"range", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.range(this.extract$player(parameters), this.extract$session(parameters), this.extract$range(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$size(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"size", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.size(this.extract$player(parameters), this.extract$session(parameters), this.extract$size(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$tracemask(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"traceMask", (Class[])new Class[]{Player.class, LocalSession.class, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.traceMask(this.extract$player(parameters), this.extract$session(parameters), this.extract$mask2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player extract$player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private Boolean extract$superPickaxe(CommandParameters parameters) {
        return (Boolean)this.superPickaxePart.value(parameters).asSingle(boolean_Key);
    }

    private Mask extract$mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private Pattern extract$pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private int extract$range(CommandParameters parameters) {
        return (Integer)this.rangePart.value(parameters).asSingle(integer_Key);
    }

    private int extract$size(CommandParameters parameters) {
        return (Integer)this.sizePart.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$mask2(CommandParameters parameters) {
        return (Mask)this.maskPart2.value(parameters).asSingle(mask_Key);
    }
}

