/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.SchematicCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class SchematicCommandsRegistration
implements CommandRegistration<SchematicCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private SchematicCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument filenamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"filename"), (Component)TextComponent.of((String)"File name.")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument formatNamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"formatName"), (Component)TextComponent.of((String)"Format name.")).defaultsTo((Iterable)ImmutableList.of((Object)"sponge")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag allowOverwritePart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Overwrite an existing file.")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Page to view.")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag oldFirstPart = CommandParts.flag((char)'d', (Component)TextComponent.of((String)"Sort by date, oldest first")).build();
    private final NoArgCommandFlag newFirstPart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"Sort by date, newest first")).build();

    private SchematicCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SchematicCommandsRegistration builder() {
        return new SchematicCommandsRegistration();
    }

    public SchematicCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SchematicCommandsRegistration containerInstance(SchematicCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public SchematicCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SchematicCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("load", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Load a schematic into your clipboard"));
            b.parts((Collection)ImmutableList.of((Object)this.filenamePart, (Object)this.formatNamePart));
            b.action(this::cmd$load);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"load", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("save", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Save a schematic into your clipboard"));
            b.parts((Collection)ImmutableList.of((Object)this.filenamePart, (Object)this.formatNamePart, (Object)this.allowOverwritePart));
            b.action(this::cmd$save);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"save", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("delete", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"d"));
            b.description((Component)TextComponent.of((String)"Delete a saved schematic"));
            b.parts((Collection)ImmutableList.of((Object)this.filenamePart));
            b.action(this::cmd$delete);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"delete", (Class[])new Class[]{Actor.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("formats", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"listformats", (Object)"f"));
            b.description((Component)TextComponent.of((String)"List available formats"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$formats);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"formats", (Class[])new Class[]{Actor.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("list", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"all", (Object)"ls"));
            b.description((Component)TextComponent.of((String)"List saved schematics"));
            b.footer((Component)TextComponent.of((String)"Note: Format is not fully verified until loading."));
            b.parts((Collection)ImmutableList.of((Object)this.pagePart, (Object)this.oldFirstPart, (Object)this.newFirstPart));
            b.action(this::cmd$list);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"list", (Class[])new Class[]{Actor.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$load(CommandParameters parameters) throws FilenameException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"load", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.load(this.extract$actor(parameters), this.extract$session(parameters), this.extract$filename(parameters), this.extract$formatName(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$save(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"save", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.save(this.extract$actor(parameters), this.extract$session(parameters), this.extract$filename(parameters), this.extract$formatName(parameters), this.extract$allowOverwrite(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$delete(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"delete", (Class[])new Class[]{Actor.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.delete(this.extract$actor(parameters), this.extract$filename(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$formats(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"formats", (Class[])new Class[]{Actor.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.formats(this.extract$actor(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$list(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"list", (Class[])new Class[]{Actor.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.list(this.extract$actor(parameters), this.extract$page(parameters), this.extract$oldFirst(parameters), this.extract$newFirst(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private String extract$filename(CommandParameters parameters) {
        return (String)this.filenamePart.value(parameters).asSingle(string_Key);
    }

    private String extract$formatName(CommandParameters parameters) {
        return (String)this.formatNamePart.value(parameters).asSingle(string_Key);
    }

    private boolean extract$allowOverwrite(CommandParameters parameters) {
        return this.allowOverwritePart.in(parameters);
    }

    private int extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$oldFirst(CommandParameters parameters) {
        return this.oldFirstPart.in(parameters);
    }

    private boolean extract$newFirst(CommandParameters parameters) {
        return this.newFirstPart.in(parameters);
    }
}

