/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.RegionCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Offset;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class RegionCommandsRegistration
implements CommandRegistration<RegionCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<BlockVector3> blockVector3_offset_Key = Key.of(BlockVector3.class, Offset.class);
    private static final Key<Long> long_Key = Key.of(Long.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private static final Key<Region> region_selection_Key = Key.of(Region.class, Selection.class);
    private static final Key<World> world_Key = Key.of(World.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private RegionCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to set")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument patternPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to place")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument thicknessPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"The thickness of the line")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag shellPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Generate only a shell")).build();
    private final CommandArgument thicknessPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"The thickness of the curve")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument fromPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"from"), (Component)TextComponent.of((String)"The mask representing blocks to replace")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument toPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"to"), (Component)TextComponent.of((String)"The pattern of blocks to replace with")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument patternPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to overlay")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument iterationsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"iterations"), (Component)TextComponent.of((String)"# of iterations to perform")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask of blocks to use as the height map")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument multiplierPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"multiplier"), (Component)TextComponent.of((String)"number of times to apply the offset")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument offsetPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"offset"), (Component)TextComponent.of((String)"The offset to move")).defaultsTo((Iterable)ImmutableList.of((Object)"forward")).ofTypes((Collection)ImmutableList.of(blockVector3_offset_Key)).build();
    private final CommandArgument replacePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"replace"), (Component)TextComponent.of((String)"The pattern of blocks to leave")).defaultsTo((Iterable)ImmutableList.of((Object)"air")).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final NoArgCommandFlag moveSelectionPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Shift the selection to the target location")).build();
    private final NoArgCommandFlag ignoreAirBlocksPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Ignore air blocks")).build();
    private final NoArgCommandFlag copyEntitiesPart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Also copy entities")).build();
    private final NoArgCommandFlag copyBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Also copy biomes")).build();
    private final ArgAcceptingCommandFlag maskPart2 = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Set the include mask, non-matching blocks become air")).withRequiredArg().argNamed(TranslatableComponent.of((String)"mask")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument countPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"count"), (Component)TextComponent.of((String)"# of copies to stack")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument offsetPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"offset"), (Component)TextComponent.of((String)"How far to move the contents each stack")).defaultsTo((Iterable)ImmutableList.of((Object)"forward")).ofTypes((Collection)ImmutableList.of(blockVector3_offset_Key)).build();
    private final NoArgCommandFlag moveSelectionPart2 = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Shift the selection to the last stacked copy")).build();
    private final NoArgCommandFlag blockUnitsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Use block units")).build();
    private final CommandArgument seedPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"seed"), (Component)TextComponent.of((String)"The seed to regenerate with, otherwise uses world seed")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(long_Key)).build();
    private final NoArgCommandFlag regenBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Regenerate biomes as well")).build();
    private final CommandArgument expressionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"The expression to use")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Use the game's coordinate origin")).build();
    private final NoArgCommandFlag offsetPart3 = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Use the placement's coordinate origin")).build();
    private final NoArgCommandFlag offsetCenterPart = CommandParts.flag((char)'c', (Component)TextComponent.of((String)"Use the selection's center as origin")).build();
    private final CommandArgument thicknessPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"Thickness of the shell to leave")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument patternPart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to replace the hollowed area with")).defaultsTo((Iterable)ImmutableList.of((Object)"air")).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"The type of tree to place")).defaultsTo((Iterable)ImmutableList.of((Object)"tree")).ofTypes((Collection)ImmutableList.of(treeType_Key)).build();
    private final CommandArgument densityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"The density of the forest")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();

    private RegionCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static RegionCommandsRegistration builder() {
        return new RegionCommandsRegistration();
    }

    public RegionCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public RegionCommandsRegistration containerInstance(RegionCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public RegionCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public RegionCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/set", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Sets all the blocks in the region"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart));
            b.action(this::cmd$_set);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"set", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/line", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Draws line segments between cuboid selection corners or convex polyhedral selection vertices"));
            b.footer((Component)TextComponent.of((String)"Can only be used with a cuboid selection or a convex polyhedral selection"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart2, (Object)this.thicknessPart, (Object)this.shellPart));
            b.action(this::cmd$_line);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"line", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/curve", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Draws a spline through selected points"));
            b.footer((Component)TextComponent.of((String)"Can only be used with a convex polyhedral selection"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart2, (Object)this.thicknessPart2, (Object)this.shellPart));
            b.action(this::cmd$_curve);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"curve", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/replace", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/re", (Object)"/rep"));
            b.description((Component)TextComponent.of((String)"Replace all blocks in the selection with another"));
            b.parts((Collection)ImmutableList.of((Object)this.fromPart, (Object)this.toPart));
            b.action(this::cmd$_replace);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"replace", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Mask.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/overlay", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set a block on top of blocks in the region"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart3));
            b.action(this::cmd$_overlay);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"overlay", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/center", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/middle"));
            b.description((Component)TextComponent.of((String)"Set the center block(s)"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart));
            b.action(this::cmd$_center);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"center", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/naturalize", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"3 layers of dirt on top then rock below"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$_naturalize);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"naturalize", (Class[])new Class[]{Actor.class, EditSession.class, Region.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/walls", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Build the four sides of the selection"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart));
            b.action(this::cmd$_walls);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"walls", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/faces", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/outline"));
            b.description((Component)TextComponent.of((String)"Build the walls, ceiling, and floor of a selection"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart));
            b.action(this::cmd$_faces);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"faces", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/smooth", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Smooth the elevation in the selection"));
            b.footer((Component)TextComponent.of((String)"Example: '//smooth 1 grass_block,dirt,stone' would only smooth natural surface terrain."));
            b.parts((Collection)ImmutableList.of((Object)this.iterationsPart, (Object)this.maskPart));
            b.action(this::cmd$_smooth);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"smooth", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Integer.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/move", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Move the contents of the selection"));
            b.parts((Collection)ImmutableList.of((Object)this.multiplierPart, (Object)this.offsetPart, (Object)this.replacePart, (Object)this.moveSelectionPart, (Object)this.ignoreAirBlocksPart, (Object)this.copyEntitiesPart, (Object)this.copyBiomesPart, (Object)this.maskPart2));
            b.action(this::cmd$_move);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"move", (Class[])new Class[]{Actor.class, World.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Pattern.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/stack", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Repeat the contents of the selection"));
            b.parts((Collection)ImmutableList.of((Object)this.countPart, (Object)this.offsetPart2, (Object)this.moveSelectionPart2, (Object)this.ignoreAirBlocksPart, (Object)this.copyEntitiesPart, (Object)this.copyBiomesPart, (Object)this.blockUnitsPart, (Object)this.maskPart2));
            b.action(this::cmd$_stack);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"stack", (Class[])new Class[]{Actor.class, World.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/regen", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Regenerates the contents of the selection"));
            b.parts((Collection)ImmutableList.of((Object)this.seedPart, (Object)this.regenBiomesPart));
            b.action(this::cmd$_regen);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"regenerate", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, EditSession.class, Region.class, Long.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/deform", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Deforms a selected region with an expression"));
            b.footer((Component)TextComponent.of((String)"The expression is executed for each block and is expected\nto modify the variables x, y and z to point to a new block\nto fetch. For details, see https://ehub.to/we/expr"));
            b.parts((Collection)ImmutableList.of((Object)this.expressionPart, (Object)this.useRawCoordsPart, (Object)this.offsetPart3, (Object)this.offsetCenterPart));
            b.action(this::cmd$_deform);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"deform", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hollow", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Hollows out the object contained in this selection"));
            b.footer((Component)TextComponent.of((String)"Thickness is measured in manhattan distance."));
            b.parts((Collection)ImmutableList.of((Object)this.thicknessPart3, (Object)this.patternPart4));
            b.action(this::cmd$_hollow);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"hollow", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Integer.TYPE, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/forest", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Make a forest within the region"));
            b.parts((Collection)ImmutableList.of((Object)this.typePart, (Object)this.densityPart));
            b.action(this::cmd$_forest);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"forest", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, TreeGenerator.TreeType.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/flora", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Make flora within the region"));
            b.parts((Collection)ImmutableList.of((Object)this.densityPart));
            b.action(this::cmd$_flora);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"flora", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$_set(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"set", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.set(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_line(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"line", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.line(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$pattern2(parameters), this.extract$thickness(parameters), this.extract$shell(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_curve(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"curve", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.curve(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$pattern2(parameters), this.extract$thickness2(parameters), this.extract$shell(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_replace(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"replace", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Mask.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.replace(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$from(parameters), this.extract$to(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_overlay(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"overlay", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.overlay(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$pattern3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_center(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"center", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.center(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_naturalize(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"naturalize", (Class[])new Class[]{Actor.class, EditSession.class, Region.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.naturalize(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_walls(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"walls", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.walls(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_faces(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"faces", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.faces(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_smooth(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"smooth", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Integer.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.smooth(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$iterations(parameters), this.extract$mask(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_move(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"move", (Class[])new Class[]{Actor.class, World.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Pattern.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.move(this.extract$actor(parameters), this.extract$world(parameters), this.extract$editSession(parameters), this.extract$session(parameters), this.extract$region(parameters), this.extract$multiplier(parameters), this.extract$offset(parameters), this.extract$replace(parameters), this.extract$moveSelection(parameters), this.extract$ignoreAirBlocks(parameters), this.extract$copyEntities(parameters), this.extract$copyBiomes(parameters), this.extract$mask2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_stack(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"stack", (Class[])new Class[]{Actor.class, World.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.stack(this.extract$actor(parameters), this.extract$world(parameters), this.extract$editSession(parameters), this.extract$session(parameters), this.extract$region(parameters), this.extract$count(parameters), this.extract$offset2(parameters), this.extract$moveSelection2(parameters), this.extract$ignoreAirBlocks(parameters), this.extract$copyEntities(parameters), this.extract$copyBiomes(parameters), this.extract$blockUnits(parameters), this.extract$mask2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_regen(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"regenerate", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, EditSession.class, Region.class, Long.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.regenerate(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$seed(parameters), this.extract$regenBiomes(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_deform(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"deform", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.deform(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$expression(parameters), this.extract$useRawCoords(parameters), this.extract$offset3(parameters), this.extract$offsetCenter(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_hollow(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"hollow", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Integer.TYPE, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.hollow(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$thickness3(parameters), this.extract$pattern4(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_forest(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"forest", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, TreeGenerator.TreeType.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.forest(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$type(parameters), this.extract$density(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_flora(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"flora", (Class[])new Class[]{Actor.class, EditSession.class, Region.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.flora(this.extract$actor(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$density(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private EditSession extract$editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private Region extract$region(CommandParameters parameters) {
        return (Region)RegistrationUtil.requireOptional(region_selection_Key, (String)"region", (Optional)parameters.injectedValue(region_selection_Key));
    }

    private Pattern extract$pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern extract$pattern2(CommandParameters parameters) {
        return (Pattern)this.patternPart2.value(parameters).asSingle(pattern_Key);
    }

    private int extract$thickness(CommandParameters parameters) {
        return (Integer)this.thicknessPart.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$shell(CommandParameters parameters) {
        return this.shellPart.in(parameters);
    }

    private int extract$thickness2(CommandParameters parameters) {
        return (Integer)this.thicknessPart2.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$from(CommandParameters parameters) {
        return (Mask)this.fromPart.value(parameters).asSingle(mask_Key);
    }

    private Pattern extract$to(CommandParameters parameters) {
        return (Pattern)this.toPart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern extract$pattern3(CommandParameters parameters) {
        return (Pattern)this.patternPart3.value(parameters).asSingle(pattern_Key);
    }

    private int extract$iterations(CommandParameters parameters) {
        return (Integer)this.iterationsPart.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private World extract$world(CommandParameters parameters) {
        return (World)RegistrationUtil.requireOptional(world_Key, (String)"world", (Optional)parameters.injectedValue(world_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private int extract$multiplier(CommandParameters parameters) {
        return (Integer)this.multiplierPart.value(parameters).asSingle(integer_Key);
    }

    private BlockVector3 extract$offset(CommandParameters parameters) {
        return (BlockVector3)this.offsetPart.value(parameters).asSingle(blockVector3_offset_Key);
    }

    private Pattern extract$replace(CommandParameters parameters) {
        return (Pattern)this.replacePart.value(parameters).asSingle(pattern_Key);
    }

    private boolean extract$moveSelection(CommandParameters parameters) {
        return this.moveSelectionPart.in(parameters);
    }

    private boolean extract$ignoreAirBlocks(CommandParameters parameters) {
        return this.ignoreAirBlocksPart.in(parameters);
    }

    private boolean extract$copyEntities(CommandParameters parameters) {
        return this.copyEntitiesPart.in(parameters);
    }

    private boolean extract$copyBiomes(CommandParameters parameters) {
        return this.copyBiomesPart.in(parameters);
    }

    private Mask extract$mask2(CommandParameters parameters) {
        return (Mask)this.maskPart2.value(parameters).asSingle(mask_Key);
    }

    private int extract$count(CommandParameters parameters) {
        return (Integer)this.countPart.value(parameters).asSingle(integer_Key);
    }

    private BlockVector3 extract$offset2(CommandParameters parameters) {
        return (BlockVector3)this.offsetPart2.value(parameters).asSingle(blockVector3_offset_Key);
    }

    private boolean extract$moveSelection2(CommandParameters parameters) {
        return this.moveSelectionPart2.in(parameters);
    }

    private boolean extract$blockUnits(CommandParameters parameters) {
        return this.blockUnitsPart.in(parameters);
    }

    private Long extract$seed(CommandParameters parameters) {
        return (Long)this.seedPart.value(parameters).asSingle(long_Key);
    }

    private boolean extract$regenBiomes(CommandParameters parameters) {
        return this.regenBiomesPart.in(parameters);
    }

    private List<String> extract$expression(CommandParameters parameters) {
        return this.expressionPart.value(parameters).asMultiple(string_Key);
    }

    private boolean extract$useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private boolean extract$offset3(CommandParameters parameters) {
        return this.offsetPart3.in(parameters);
    }

    private boolean extract$offsetCenter(CommandParameters parameters) {
        return this.offsetCenterPart.in(parameters);
    }

    private int extract$thickness3(CommandParameters parameters) {
        return (Integer)this.thicknessPart3.value(parameters).asSingle(integer_Key);
    }

    private Pattern extract$pattern4(CommandParameters parameters) {
        return (Pattern)this.patternPart4.value(parameters).asSingle(pattern_Key);
    }

    private TreeGenerator.TreeType extract$type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private double extract$density(CommandParameters parameters) {
        return (Double)this.densityPart.value(parameters).asSingle(double_Key);
    }
}

