/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ExpandCommands;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.annotation.MultiDirection;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class ExpandCommandsRegistration
implements CommandRegistration<ExpandCommands> {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<BlockVector3> blockVector3_multiDirection_Key = Key.of(BlockVector3.class, MultiDirection.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<World> world_Key = Key.of(World.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private ExpandCommands containerInstance;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument amountPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"amount"), (Component)TextComponent.of((String)"Amount to expand the selection by, can be `vert` to expand to the whole vertical column")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument reverseAmountPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"reverseAmount"), (Component)TextComponent.of((String)"Amount to expand the selection by in the other direction")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument directionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"direction"), (Component)TextComponent.of((String)"Direction to expand")).defaultsTo((Iterable)ImmutableList.of((Object)"me")).ofTypes((Collection)ImmutableList.of(blockVector3_multiDirection_Key)).build();

    private ExpandCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ExpandCommandsRegistration builder() {
        return new ExpandCommandsRegistration();
    }

    public ExpandCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ExpandCommandsRegistration containerInstance(ExpandCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public ExpandCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/expand", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Expand the selection area"));
            b.parts((Collection)ImmutableList.of((Object)this.amountPart, (Object)this.reverseAmountPart, (Object)this.directionPart));
            b.action(this::cmd$_expand);
        });
    }

    private int cmd$_expand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ExpandCommands.class, (String)"expand", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, Integer.TYPE, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.expand(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$amount(parameters), this.extract$reverseAmount(parameters), this.extract$direction(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private World extract$world(CommandParameters parameters) {
        return (World)RegistrationUtil.requireOptional(world_Key, (String)"world", (Optional)parameters.injectedValue(world_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private int extract$amount(CommandParameters parameters) {
        return (Integer)this.amountPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$reverseAmount(CommandParameters parameters) {
        return (Integer)this.reverseAmountPart.value(parameters).asSingle(integer_Key);
    }

    private List<BlockVector3> extract$direction(CommandParameters parameters) {
        return this.directionPart.value(parameters).asMultiple(blockVector3_multiDirection_Key);
    }
}

