/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.settings;

import java.util.HashMap;
import java.util.Map;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.config.BSConfigShop;
import org.black_ixx.bossshop.settings.SettingsProperty;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ShopProperty
extends SettingsProperty {
    private Map<BSShop, Object> shop_settings;

    public ShopProperty(ConfigurationSection config, String path, Class<?> type) {
        super(config, path, type);
    }

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        if (ClassManager.manager.getShops() != null && ClassManager.manager.getShops().getShops() != null) {
            this.readShops(this.type);
        }
    }

    public void readShops(Class<?> type) {
        for (BSShop shop : ClassManager.manager.getShops().getShops().values()) {
            this.readShop(shop, type);
        }
    }

    @Override
    public void update(Object o) {
        if (o instanceof BSShop) {
            BSShop shop = (BSShop)o;
            this.readShop(shop, this.type);
        }
        super.update(o);
    }

    public void readShop(BSShop shop, Class<?> type) {
        BSConfigShop configshop;
        FileConfiguration config;
        if (shop instanceof BSConfigShop && (config = (configshop = (BSConfigShop)shop).getConfig()).contains(this.path)) {
            if (this.shop_settings == null) {
                this.shop_settings = new HashMap<BSShop, Object>();
            }
            this.shop_settings.put(shop, this.read((ConfigurationSection)config));
        }
    }

    @Override
    public boolean containsValue(Object input, Object value) {
        BSShop shop;
        if (input instanceof BSShop && this.containsValueShop(shop = (BSShop)input, value)) {
            return true;
        }
        return super.containsValue(input, value);
    }

    public boolean containsValueShop(BSShop shop, Object value) {
        return this.shop_settings != null && this.shop_settings.containsKey(shop) && this.isIdentical(this.shop_settings.get(shop), value);
    }

    @Override
    public boolean containsValueAny(Object value) {
        if (this.shop_settings != null) {
            for (BSShop shop : this.shop_settings.keySet()) {
                if (!this.containsValueShop(shop, value)) continue;
                return true;
            }
        }
        return super.containsValueAny(value);
    }

    @Override
    public Object getObject(Object input) {
        if (input instanceof BSShop) {
            BSShop shop = (BSShop)input;
            if (this.shop_settings != null && this.shop_settings.containsKey(shop)) {
                return this.shop_settings.get(shop);
            }
        }
        return super.getObject(input);
    }
}

