/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.settings;

import java.util.HashMap;
import java.util.Map;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.config.BSConfigShop;
import org.black_ixx.bossshop.settings.ShopProperty;
import org.bukkit.configuration.ConfigurationSection;

public class ShopItemProperty
extends ShopProperty {
    private Map<BSBuy, Object> shopitem_settings;

    public ShopItemProperty(ConfigurationSection config, String path, Class<?> type) {
        super(config, path, type);
    }

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        if (ClassManager.manager.getShops() != null && ClassManager.manager.getShops().getShops() != null) {
            this.readShopItems(this.type);
        }
    }

    public void readShopItems(Class<?> type) {
        for (BSShop shop : ClassManager.manager.getShops().getShops().values()) {
            if (!(shop instanceof BSConfigShop)) continue;
            BSConfigShop configshop = (BSConfigShop)shop;
            for (BSBuy buy : shop.getItems()) {
                this.readShopItem(buy, configshop, type);
            }
        }
    }

    @Override
    public void update(Object o) {
        if (o instanceof BSBuy) {
            BSBuy buy = (BSBuy)o;
            this.readShopItem(buy, this.type);
        }
        super.update(o);
    }

    public void readShopItem(BSBuy buy, Class<?> type) {
        if (buy.getShop() instanceof BSConfigShop) {
            BSConfigShop configshop = (BSConfigShop)buy.getShop();
            this.readShopItem(buy, configshop, type);
        }
    }

    public void readShopItem(BSBuy buy, BSConfigShop configshop, Class<?> type) {
        ConfigurationSection section = buy.getConfigurationSection(configshop);
        if (section != null && section.contains(this.path)) {
            if (this.shopitem_settings == null) {
                this.shopitem_settings = new HashMap<BSBuy, Object>();
            }
            this.shopitem_settings.put(buy, this.read(section));
        }
    }

    @Override
    public void readShop(BSShop shop, Class<?> type) {
        super.readShop(shop, type);
        for (BSBuy buy : shop.getItems()) {
            this.readShopItem(buy, type);
        }
    }

    @Override
    public boolean containsValue(Object input, Object value) {
        if (input instanceof BSBuy) {
            BSBuy buy = (BSBuy)input;
            if (this.containsValueShopItem(buy, value)) {
                return true;
            }
            return super.containsValue(buy.getShop(), value);
        }
        return super.containsValue(input, value);
    }

    public boolean containsValueShopItem(BSBuy buy, Object value) {
        return this.shopitem_settings != null && this.shopitem_settings.containsKey(buy) && this.isIdentical(this.shopitem_settings.get(buy), value);
    }

    @Override
    public boolean containsValueAny(Object value) {
        if (this.shopitem_settings != null) {
            for (BSBuy buy : this.shopitem_settings.keySet()) {
                if (!this.containsValueShopItem(buy, value)) continue;
                return true;
            }
        }
        return super.containsValueAny(value);
    }

    @Override
    public Object getObject(Object input) {
        if (input instanceof BSBuy) {
            BSBuy buy = (BSBuy)input;
            if (this.shopitem_settings != null && this.shopitem_settings.containsKey(buy)) {
                return this.shopitem_settings.get(buy);
            }
            return super.getObject(buy.getShop());
        }
        return super.getObject(input);
    }
}

