/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.serverpinging;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.serverpinging.ServerConnector;
import org.black_ixx.bossshop.managers.serverpinging.ServerInfo;

public class ServerConnector3
implements ServerConnector {
    @Override
    public boolean update(ServerInfo info) {
        return this.fetchData(info);
    }

    public boolean fetchData(ServerInfo info) {
        Socket socket = new Socket();
        try {
            socket.setSoTimeout(info.getTimeout());
            socket.connect(info.getAddress(), info.getTimeout());
            OutputStream os = socket.getOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            InputStream is = socket.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-16BE"));
            dos.write(new byte[]{-2, 1});
            int packetId = is.read();
            if (packetId == -1) {
                info.setNoConnection();
                return false;
            }
            if (packetId != 255) {
                info.setNoConnection();
                return false;
            }
            int length = isr.read();
            if (length == -1) {
                info.setNoConnection();
                return false;
            }
            if (length == 1) {
                info.setNoConnection();
                return false;
            }
            char[] chars = new char[length];
            socket.close();
            if (isr.read(chars, 0, length) != length) {
                info.setNoConnection();
                return false;
            }
            String string = new String(chars);
            String[] data = string.split("\u0000");
            info.setMotd(data[3]);
            info.setPlayers(Integer.parseInt(data[4]));
            info.setMaxPlayers(Integer.parseInt(data[5]));
            info.setOnline(true);
            return true;
        }
        catch (Exception e) {
            info.setNoConnection();
            if (ClassManager.manager.getSettings().isDebugEnabled()) {
                e.printStackTrace();
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }
}

