/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.item;

import java.util.ArrayList;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.core.BSShopHolder;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.item.ItemDataPartCustomSkull;
import org.black_ixx.bossshop.managers.misc.StringManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.plugin.Plugin;

public class ItemStackTranslator {
    public ItemStack translateItemStack(BSBuy buy, BSShop shop, BSShopHolder holder, ItemStack item, Player target, boolean final_version) {
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                meta.setDisplayName(ClassManager.manager.getStringManager().transform(meta.getDisplayName(), buy, shop, holder, target));
            }
            if (meta.hasLore()) {
                List lore = meta.getLore();
                for (int i = 0; i < lore.size(); ++i) {
                    lore.set(i, ClassManager.manager.getStringManager().transform((String)lore.get(i), buy, shop, holder, target));
                }
                meta.setLore(this.splitLore(lore, ClassManager.manager.getSettings().getMaxLineLength(), final_version));
            }
            if (meta instanceof SkullMeta) {
                String placeholder;
                SkullMeta skullmeta = (SkullMeta)meta;
                NamespacedKey key = new NamespacedKey((Plugin)ClassManager.manager.getPlugin(), "skullOwnerPlaceholder");
                CustomItemTagContainer tagContainer = meta.getCustomTagContainer();
                if (tagContainer.hasCustomTag(key, ItemTagType.STRING) && (placeholder = (String)tagContainer.getCustomTag(key, ItemTagType.STRING)) != null) {
                    String playerName = ClassManager.manager.getStringManager().transform(placeholder, target);
                    OfflinePlayer transformedPlayer = Bukkit.getOfflinePlayer((String)playerName);
                    if (transformedPlayer != null) {
                        skullmeta.setOwningPlayer(transformedPlayer);
                    } else {
                        skullmeta.setOwner(playerName);
                    }
                }
            }
            item.setItemMeta(meta);
            if (meta instanceof SkullMeta) {
                this.transformCustomSkull(buy, shop, item, holder, target);
            }
        }
        return item;
    }

    private void transformCustomSkull(BSBuy buy, BSShop shop, ItemStack item, BSShopHolder holder, Player target) {
        String skulltexture = ItemDataPartCustomSkull.readSkullTexture(item);
        if (skulltexture != null && ClassManager.manager.getStringManager().checkStringForFeatures(shop, buy, item, skulltexture)) {
            item = ItemDataPartCustomSkull.transformSkull(item, ClassManager.manager.getStringManager().transform(skulltexture, buy, shop, holder, target));
        }
    }

    private List<String> splitLore(List<String> lore, int max_line_length, boolean final_version) {
        if (max_line_length > 0 && final_version) {
            ArrayList<String> goal = new ArrayList<String>();
            for (String line : lore) {
                String[] words = line.split(" ");
                String current = null;
                for (String word : words) {
                    if (current == null) {
                        current = word;
                        continue;
                    }
                    String next = current + " " + word;
                    if (ChatColor.stripColor((String)next).length() > max_line_length) {
                        goal.add(current);
                        String last_colors = current == null ? "" : ChatColor.getLastColors((String)current);
                        current = last_colors + word;
                        continue;
                    }
                    current = next;
                }
                goal.add(current);
            }
            return goal;
        }
        return lore;
    }

    public String getFriendlyText(List<ItemStack> items) {
        if (items != null) {
            String msg = "";
            int x = 0;
            for (ItemStack i : items) {
                msg = msg + this.readItemStack(i) + (++x < items.size() ? ", " : "");
            }
            return msg;
        }
        return null;
    }

    public String readItemStack(ItemStack i) {
        if (ClassManager.manager.getLanguageManager() != null) {
            return i.getAmount() + " " + ClassManager.manager.getLanguageManager().getDisplayNameItem(i);
        }
        String material = this.readMaterial(i);
        return i.getAmount() + " " + material;
    }

    public String readEnchantment(Enchantment e) {
        if (ClassManager.manager.getLanguageManager() != null) {
            return ClassManager.manager.getLanguageManager().getDisplayNameEnchantment(e);
        }
        return e.getName().toLowerCase().replace("_", "");
    }

    public boolean checkItemStackForFeatures(BSShop shop, BSBuy buy, ItemStack item) {
        boolean b = false;
        if (item != null && item.hasItemMeta()) {
            SkullMeta skullmeta;
            StringManager s = ClassManager.manager.getStringManager();
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName() && s.checkStringForFeatures(shop, buy, item, meta.getDisplayName())) {
                b = true;
            }
            if (meta.hasLore()) {
                List lore = meta.getLore();
                for (int i = 0; i < lore.size(); ++i) {
                    if (!s.checkStringForFeatures(shop, buy, item, (String)lore.get(i))) continue;
                    b = true;
                }
            }
            if (meta instanceof SkullMeta && (skullmeta = (SkullMeta)meta).hasOwner() && s.checkStringForFeatures(shop, buy, item, skullmeta.getOwner())) {
                b = true;
            }
        }
        return b;
    }

    public String readItemName(ItemStack item) {
        if (item != null) {
            ItemMeta meta;
            if (item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName()) {
                return meta.getDisplayName();
            }
            return this.readItemStack(item);
        }
        return null;
    }

    public String readMaterial(ItemStack item) {
        if (ClassManager.manager.getLanguageManager() != null) {
            ItemStack i = new ItemStack(item.getType());
            return ClassManager.manager.getLanguageManager().getDisplayNameItem(i);
        }
        String material = item.getType().name().toLowerCase().replace("_", " ");
        material = material.replaceFirst(material.substring(0, 1), material.substring(0, 1).toUpperCase());
        return material;
    }

    public void copyTexts(ItemStack receiver, ItemStack source) {
        if (source.hasItemMeta()) {
            ItemMeta meta_source = source.getItemMeta();
            ItemMeta meta_receiver = receiver.getItemMeta();
            if (meta_source.hasDisplayName()) {
                meta_receiver.setDisplayName(meta_source.getDisplayName());
            }
            if (meta_source.hasLore()) {
                meta_receiver.setLore(meta_source.getLore());
            }
            if (meta_source instanceof SkullMeta && meta_receiver instanceof SkullMeta) {
                SkullMeta sm_source = (SkullMeta)meta_source;
                SkullMeta sm_receiver = (SkullMeta)meta_receiver;
                if (sm_source.hasOwner()) {
                    sm_receiver.setOwner(sm_source.getOwner());
                }
            }
            receiver.setItemMeta(meta_receiver);
        }
    }

    public boolean isItemList(Object o) {
        if (o instanceof List) {
            return this.isItemList((List)o);
        }
        return false;
    }

    public boolean isItemList(List<?> list) {
        Object first;
        return list != null && list.size() >= 1 && (first = list.get(0)) instanceof ItemStack;
    }
}

