/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.item;

import java.util.ArrayList;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.config.BSConfigShop;
import org.black_ixx.bossshop.managers.item.ItemDataPart;
import org.black_ixx.bossshop.managers.misc.InputReader;
import org.black_ixx.bossshop.managers.misc.StringManipulationLib;
import org.black_ixx.bossshop.misc.Misc;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemStackCreator {
    public ItemStack createItemStack(List<String> itemData, BSBuy buy, BSShop shop, boolean final_version) {
        if (shop instanceof BSConfigShop) {
            BSConfigShop cshop = (BSConfigShop)shop;
            List<String> new_list = null;
            for (String line : itemData) {
                String price_line;
                String reward_line = StringManipulationLib.figureOutVariable(line, "rewarditem", 0);
                if (reward_line != null) {
                    if (new_list == null) {
                        new_list = this.cloneList(itemData);
                    }
                    int i = InputReader.getInt(reward_line, -1) - 1;
                    new_list = this.transform(line, i, new_list, buy, cshop, "Reward");
                }
                if ((price_line = StringManipulationLib.figureOutVariable(line, "priceitem", 0)) != null) {
                    if (new_list == null) {
                        new_list = this.cloneList(itemData);
                    }
                    int i = InputReader.getInt(reward_line, -1) - 1;
                    new_list = this.transform(line, i, new_list, buy, cshop, "Price");
                }
                if (new_list == null) continue;
                return this.createItemStack(new_list, final_version);
            }
        }
        return this.createItemStack(itemData, final_version);
    }

    private List<String> transform(String line, int index, List<String> new_list, BSBuy buy, BSConfigShop shop, String path) {
        if (index != -1) {
            new_list.remove(line);
            List<List<String>> list = InputReader.readStringListList(buy.getConfigurationSection(shop).get(path));
            if (list != null) {
                if (list.size() > index) {
                    for (String entry : list.get(index)) {
                        new_list.add(entry);
                    }
                } else {
                    ClassManager.manager.getBugFinder().warn("Was trying to import the item look for MenuItem of shopitem '" + buy.getName() + "' in shop '" + shop.getShopName() + "' but your " + path + " does not contain a " + index + ". item!");
                }
            } else {
                ClassManager.manager.getBugFinder().warn("Was trying to import the item look for MenuItem of shopitem '" + buy.getName() + "' in shop '" + shop.getShopName() + "' but your " + path + " is not an item list!");
            }
        }
        return new_list;
    }

    private List<String> cloneList(List<String> list) {
        if (list != null & !list.isEmpty()) {
            ArrayList<String> clone = new ArrayList<String>();
            for (String line : list) {
                clone.add(line);
            }
            return clone;
        }
        return list;
    }

    public ItemStack createItemStack(List<String> itemData, boolean final_version) {
        ItemStack i = new ItemStack(Material.STONE);
        itemData = Misc.fixLore(itemData);
        i = ItemDataPart.transformItem(i, itemData);
        ClassManager.manager.getItemStackTranslator().translateItemStack(null, null, null, i, null, final_version);
        return i;
    }

    public void giveItem(Player p, BSBuy buy, ItemStack i, boolean clone_item) {
        this.giveItem(p, buy, i, i.getAmount(), clone_item);
    }

    public void giveItem(Player p, BSBuy buy, ItemStack i, int amount, boolean clone_item) {
        if (clone_item) {
            i = i.clone();
        }
        int stacksize = ClassManager.manager.getItemStackChecker().getMaxStackSize(i);
        i = ClassManager.manager.getItemStackTranslator().translateItemStack(buy, null, null, clone_item ? i.clone() : i, p, true);
        for (int to_give = amount; to_give > 0; to_give -= i.getAmount()) {
            i.setAmount(Math.min(stacksize, to_give));
            this.giveItem(p, i.clone(), stacksize);
        }
    }

    private void giveItem(Player p, ItemStack i, int stacksize) {
        if (i.getAmount() > stacksize) {
            throw new RuntimeException("Can not give an itemstack with a higher amount than the maximum stack size at once to a player.");
        }
        int free = ClassManager.manager.getItemStackChecker().getAmountOfFreeSpace(p, i);
        if (free < i.getAmount()) {
            this.dropItem(p, i, stacksize);
        } else {
            p.getInventory().addItem(new ItemStack[]{i});
        }
    }

    private void dropItem(Player p, ItemStack i, int stacksize) {
        int toTake = i.getAmount();
        i = i.clone();
        while (toTake > 0) {
            int amount = Math.min(toTake, stacksize);
            i.setAmount(amount);
            p.getWorld().dropItem(p.getLocation(), i);
            toTake -= amount;
        }
    }
}

