/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.item;

import java.util.ArrayList;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.item.ItemDataPart;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemDataPartBanner
extends ItemDataPart {
    @Override
    public ItemStack transform(ItemStack item, String used_name, String argument) {
        if (Bukkit.getVersion().contains("1.8") || Bukkit.getVersion().contains("1.9")) {
            if (item.getType() != Material.LEGACY_BANNER) {
                ClassManager.manager.getBugFinder().severe("Mistake in Config: '" + argument + "' is not a valid '" + used_name + "'.");
                return item;
            }
            BannerMeta meta = (BannerMeta)item.getItemMeta();
            String[] bdata = argument.split("\\+");
            DyeColor basecolor = DyeColor.valueOf((String)bdata[0]);
            if (basecolor != null) {
                ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                for (int y = 1; y < bdata.length; ++y) {
                    try {
                        String[] bpattern = bdata[y].split("-");
                        DyeColor patterncolor = DyeColor.valueOf((String)bpattern[0]);
                        PatternType patterntype = PatternType.getByIdentifier((String)bpattern[1]);
                        Pattern pattern = new Pattern(patterncolor, patterntype);
                        patterns.add(pattern);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                meta.setBaseColor(basecolor);
                meta.setPatterns(patterns);
            }
            item.setItemMeta((ItemMeta)meta);
            return item;
        }
        return item;
    }

    @Override
    public int getPriority() {
        return PRIORITY_NORMAL;
    }

    @Override
    public boolean removeSpaces() {
        return true;
    }

    @Override
    public String[] createNames() {
        return new String[]{"banner"};
    }

    @Override
    public List<String> read(ItemStack i, List<String> output) {
        return output;
    }

    @Override
    public boolean isSimilar(ItemStack shop_item, ItemStack player_item, BSBuy buy, Player p) {
        return true;
    }
}

