/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.item.ItemDataPartAmount;
import org.black_ixx.bossshop.managers.item.ItemDataPartBanner;
import org.black_ixx.bossshop.managers.item.ItemDataPartColor;
import org.black_ixx.bossshop.managers.item.ItemDataPartCustomModelData;
import org.black_ixx.bossshop.managers.item.ItemDataPartCustomSkull;
import org.black_ixx.bossshop.managers.item.ItemDataPartDurability;
import org.black_ixx.bossshop.managers.item.ItemDataPartEnchantment;
import org.black_ixx.bossshop.managers.item.ItemDataPartItemflags;
import org.black_ixx.bossshop.managers.item.ItemDataPartLore;
import org.black_ixx.bossshop.managers.item.ItemDataPartMaterial;
import org.black_ixx.bossshop.managers.item.ItemDataPartMobEgg;
import org.black_ixx.bossshop.managers.item.ItemDataPartMobspawner;
import org.black_ixx.bossshop.managers.item.ItemDataPartName;
import org.black_ixx.bossshop.managers.item.ItemDataPartPlayerhead;
import org.black_ixx.bossshop.managers.item.ItemDataPartPotion;
import org.black_ixx.bossshop.managers.item.ItemDataPartPotionEffect;
import org.black_ixx.bossshop.managers.item.ItemDataPartUnbreaking;
import org.black_ixx.bossshop.managers.item.ItemDataPartWrittenBookInformation;
import org.black_ixx.bossshop.managers.item.ItemDataPartWrittenBookPage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ItemDataPart {
    public static int PRIORITY_MOST_EARLY = 0;
    public static int PRIORITY_EARLY = 10;
    public static int PRIORITY_NORMAL = 50;
    public static int PRIORITY_LATE = 80;
    public static int PRIORITY_VERY_LATE = 100;
    public static ItemDataPart MATERIAL;
    public static ItemDataPart AMOUNT;
    public static ItemDataPart DURABILITY;
    public static ItemDataPart NAME;
    public static ItemDataPart LORE;
    public static ItemDataPart ENCHANTMENT;
    public static ItemDataPart PLAYERHEAD;
    public static ItemDataPart CUSTOMSKULL;
    public static ItemDataPart CUSTOMMODELDATA;
    public static ItemDataPart MOBSPAWNER;
    public static ItemDataPart MOBEGG;
    public static ItemDataPart ITEMFLAGS;
    public static ItemDataPart COLOR;
    public static ItemDataPart POTIONEFFECT;
    public static ItemDataPart POTION;
    public static ItemDataPart UNBREAKING;
    public static ItemDataPart BOOK;
    public static ItemDataPart BOOKPAGE;
    public static ItemDataPart BANNER;
    private static List<ItemDataPart> types;
    private String[] names = this.createNames();

    public static void loadTypes() {
        types = new ArrayList<ItemDataPart>();
        MATERIAL = ItemDataPart.registerType(new ItemDataPartMaterial());
        AMOUNT = ItemDataPart.registerType(new ItemDataPartAmount());
        DURABILITY = ItemDataPart.registerType(new ItemDataPartDurability());
        NAME = ItemDataPart.registerType(new ItemDataPartName());
        LORE = ItemDataPart.registerType(new ItemDataPartLore());
        ENCHANTMENT = ItemDataPart.registerType(new ItemDataPartEnchantment());
        PLAYERHEAD = ItemDataPart.registerType(new ItemDataPartPlayerhead());
        CUSTOMMODELDATA = ItemDataPart.registerType(new ItemDataPartCustomModelData());
        MOBSPAWNER = ItemDataPart.registerType(new ItemDataPartMobspawner());
        MOBEGG = ItemDataPart.registerType(new ItemDataPartMobEgg());
        CUSTOMSKULL = ItemDataPart.registerType(new ItemDataPartCustomSkull());
        ITEMFLAGS = ItemDataPart.registerType(new ItemDataPartItemflags());
        COLOR = ItemDataPart.registerType(new ItemDataPartColor());
        POTIONEFFECT = ItemDataPart.registerType(new ItemDataPartPotionEffect());
        POTION = ItemDataPart.registerType(new ItemDataPartPotion());
        UNBREAKING = ItemDataPart.registerType(new ItemDataPartUnbreaking());
        BANNER = ItemDataPart.registerType(new ItemDataPartBanner());
        BOOK = ItemDataPart.registerType(new ItemDataPartWrittenBookInformation());
        BOOKPAGE = ItemDataPart.registerType(new ItemDataPartWrittenBookPage());
    }

    public static ItemDataPart registerType(ItemDataPart type) {
        types.add(type);
        return type;
    }

    public static ItemDataPart detectTypeSpecial(String whole_line) {
        if (whole_line == null) {
            return null;
        }
        String[] parts = whole_line.split(":", 2);
        String name = parts[0].trim();
        return ItemDataPart.detectType(name);
    }

    public static ItemDataPart detectType(String s) {
        for (ItemDataPart type : types) {
            if (!type.isType(s)) continue;
            return type;
        }
        return null;
    }

    public static ItemStack transformItem(ItemStack item, List<String> itemdata) {
        Collections.sort(itemdata, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                ItemDataPart type1 = ItemDataPart.detectTypeSpecial(s1);
                ItemDataPart type2 = ItemDataPart.detectTypeSpecial(s2);
                if (type1 != null && type2 != null) {
                    return Integer.compare(type1.getPriority(), type2.getPriority());
                }
                return 0;
            }
        });
        for (String line : itemdata) {
            item = ItemDataPart.transformItem(item, line);
        }
        return item;
    }

    public static ItemStack transformItem(ItemStack item, String line) {
        ItemDataPart part;
        if (line == null) {
            return item;
        }
        String[] parts = line.split(":", 2);
        String name = parts[0].trim();
        String argument = null;
        if (parts.length == 2) {
            argument = parts[1].trim();
        }
        if ((part = ItemDataPart.detectType(name)) == null) {
            ClassManager.manager.getBugFinder().severe("Mistake in Config: Unable to read itemdata '" + name + ":" + argument);
            return item;
        }
        return part.transformItem(item, name, argument);
    }

    public static List<String> readItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        List<String> output = new ArrayList<String>();
        for (ItemDataPart part : types) {
            try {
                output = part.read(item, output);
            }
            catch (Exception exception) {
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        }
        return output;
    }

    public static boolean isSimilar(ItemStack shop_item, ItemStack player_item, ItemDataPart[] exceptions, BSBuy buy, boolean compare_amount, Player p) {
        if (shop_item == null || player_item == null) {
            return false;
        }
        for (ItemDataPart part : types) {
            if (ItemDataPart.isException(exceptions, part) || !compare_amount && part == AMOUNT) continue;
            try {
                if (part.isSimilar(shop_item, player_item, buy, p)) continue;
                return false;
            }
            catch (Exception exception) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
        }
        return true;
    }

    private static boolean isException(ItemDataPart[] exceptions, ItemDataPart part) {
        if (exceptions != null) {
            for (ItemDataPart exception : exceptions) {
                if (exception != part) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ItemDataPart> values() {
        return types;
    }

    public boolean isType(String s) {
        if (this.names != null) {
            for (String name : this.names) {
                if (!name.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void register() {
        ItemDataPart.registerType(this);
    }

    public String name() {
        return this.names[0].toUpperCase();
    }

    public ItemStack transformItem(ItemStack item, String used_name, String argument) {
        if (argument == null && this.needsArgument()) {
            return item;
        }
        if (this.removeSpaces() && argument != null) {
            argument = argument.replaceAll(" ", "");
        }
        try {
            return this.transform(item, used_name.toLowerCase(), argument);
        }
        catch (NoClassDefFoundError e) {
            ClassManager.manager.getBugFinder().severe("Unable to work with itemdata '" + used_name.toLowerCase() + ":" + argument + ". Seems like it is not supported by your server version yet.");
            return item;
        }
        catch (NoSuchMethodError e) {
            ClassManager.manager.getBugFinder().severe("Unable to work with itemdata '" + used_name.toLowerCase() + ":" + argument + ". Seems like it is not supported by your server version yet.");
            return item;
        }
    }

    @Deprecated
    public abstract ItemStack transform(ItemStack var1, String var2, String var3);

    public abstract boolean isSimilar(ItemStack var1, ItemStack var2, BSBuy var3, Player var4);

    public abstract List<String> read(ItemStack var1, List<String> var2);

    public abstract int getPriority();

    public abstract boolean removeSpaces();

    public abstract String[] createNames();

    public boolean needsArgument() {
        return true;
    }
}

