/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.features;

import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.pointsystem.BSPointsAPI;
import org.black_ixx.bossshop.pointsystem.BSPointsPlugin;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginCommandPoints;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginEnjin;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginFailed;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginGadgetsMenu;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginJobs;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginKingdoms;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginMySQLTokens;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginMySQL_Tokens;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginNone;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginPlayerPoints;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginPointsAPI;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginTokenEnchant;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginTokenManager;
import org.black_ixx.bossshop.pointsystem.BSPointsPluginVotingPlugin;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PointsManager {
    private BSPointsPlugin pa;

    public PointsManager() {
        this(ClassManager.manager.getSettings().getPointsPlugin());
    }

    public PointsManager(PointsPlugin p) {
        if (p == null) {
            this.pa = new BSPointsPluginFailed();
            return;
        }
        if (p != PointsPlugin.NONE && Bukkit.getPluginManager().getPlugin(p.getPluginName()) == null) {
            ClassManager.manager.getBugFinder().severe("You defined " + p.getPluginName() + " as Points Plugin... BUT IT WAS NOT FOUND?! Please install it or use an alternative like PlayerPoints (http://dev.bukkit.org/server-mods/playerpoints/). If you want " + "BossShopPro" + " to auto-detect your Points plugin simply set 'PointsPlugin: auto-detect'.");
            this.pa = new BSPointsPluginFailed();
            return;
        }
        switch (p) {
            case COMMANDPOINTS: {
                this.pa = new BSPointsPluginCommandPoints();
                break;
            }
            case ENJIN_MINECRAFT_PLUGIN: {
                this.pa = new BSPointsPluginEnjin();
                break;
            }
            case PLAYERPOINTS: {
                this.pa = new BSPointsPluginPlayerPoints();
                break;
            }
            case POINTSAPI: {
                this.pa = new BSPointsPluginPointsAPI();
                break;
            }
            case TOKENENCHANT: {
                this.pa = new BSPointsPluginTokenEnchant();
                break;
            }
            case TOKENMANAGER: {
                this.pa = new BSPointsPluginTokenManager();
                break;
            }
            case Jobs: {
                this.pa = new BSPointsPluginJobs();
                break;
            }
            case MYSQL_TOKENS: {
                this.pa = new BSPointsPluginMySQL_Tokens();
                break;
            }
            case MYSQLTOKENS: {
                this.pa = new BSPointsPluginMySQLTokens();
                break;
            }
            case VOTINGPLUGIN: {
                this.pa = new BSPointsPluginVotingPlugin();
                break;
            }
            case KINGDOMS: {
                this.pa = new BSPointsPluginKingdoms();
                break;
            }
            case GadetsMenu: {
                this.pa = new BSPointsPluginGadgetsMenu();
                break;
            }
            case NONE: {
                this.pa = new BSPointsPluginNone();
                break;
            }
            case CUSTOM: {
                BSPointsPlugin customPoints = BSPointsAPI.get(p.getCustom());
                if (customPoints == null) break;
                this.pa = customPoints;
            }
        }
        if (this.pa == null) {
            ClassManager.manager.getBugFinder().warn("No PointsPlugin was found... You need one if you want BossShopPro to work with Points! Get PlayerPoints here: http://dev.bukkit.org/server-mods/playerpoints/");
            this.pa = new BSPointsPluginFailed();
        } else {
            BossShop.log("Successfully hooked into Points plugin " + this.pa.getName() + ".");
        }
    }

    public double getPoints(OfflinePlayer player) {
        return this.pa.getPoints(player);
    }

    public double setPoints(OfflinePlayer player, double points) {
        return this.pa.setPoints(player, points);
    }

    public double givePoints(OfflinePlayer player, double points) {
        return this.pa.givePoints(player, points);
    }

    public double takePoints(OfflinePlayer player, double points) {
        return this.pa.takePoints(player, points);
    }

    public boolean usesDoubleValues() {
        return this.pa.usesDoubleValues();
    }

    public static enum PointsPlugin {
        NONE(new String[]{"none", "nothing"}),
        PLAYERPOINTS(new String[]{"PlayerPoints", "PlayerPoint", "PP"}),
        COMMANDPOINTS(new String[]{"CommandPoints", "CommandPoint", "CP"}),
        ENJIN_MINECRAFT_PLUGIN(new String[]{"EnjinMinecraftPlugin", "Enjin", "EMP"}),
        POINTSAPI(new String[]{"PointsAPI", "PAPI"}),
        TOKENENCHANT(new String[]{"TokenEnchant", "TE", "TokenEnchants"}),
        TOKENMANAGER(new String[]{"TokenManager", "TM"}),
        Jobs(new String[]{"Jobs", "JobsReborn"}),
        MYSQL_TOKENS(new String[]{"MySQL-Tokens", "MySQL-Token"}),
        MYSQLTOKENS(new String[]{"MySQLTokens", "MySQLToken"}),
        VOTINGPLUGIN(new String[]{"VotingPlugin", "VP"}),
        KINGDOMS(new String[]{"Kingdoms", "Kingdom"}),
        GadetsMenu(new String[]{"GadgetsMenu"}),
        CUSTOM(new String[0]);

        private String[] nicknames;
        private String custom_name;

        private PointsPlugin(String[] nicknames) {
            this.nicknames = nicknames;
        }

        public String getCustom() {
            return this.custom_name;
        }

        public void setCustom(String custom_name) {
            this.custom_name = custom_name;
        }

        public String[] getNicknames() {
            return this.nicknames;
        }

        public String getPluginName() {
            if (this.getNicknames() == null) {
                return this.custom_name;
            }
            if (this.getNicknames().length == 0) {
                return this.custom_name;
            }
            return this.getNicknames()[0];
        }
    }
}

