/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.features;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.black_ixx.bossshop.BossShop;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BugFinder {
    private final BossShop plugin;
    private final String fileName = "BugFinder.yml";
    private final File file;
    String USER = "%%__USER__%%";
    private FileConfiguration config = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy dd-MM 'at' hh:mm:ss a (E)");

    public BugFinder(BossShop plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder().getAbsolutePath(), "BugFinder.yml");
        this.reloadConfig();
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        InputStream defConfigStream = this.plugin.getResource("BugFinder.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public void saveConfig() {
        try {
            this.getConfig().save(this.file);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("[BossShopPro] Could not save BugFinder config to " + this.file);
        }
    }

    public String getDate() {
        Date dNow = new Date();
        return this.formatter.format(dNow);
    }

    public void addMessage(String message) {
        this.config.set(this.getDate(), (Object)message);
        this.saveConfig();
    }

    public void warn(String message) {
        this.addMessage(message);
        Bukkit.getLogger().warning("[BossShopPro] " + message);
    }

    public void severe(String message) {
        this.addMessage(message);
        Bukkit.getLogger().severe("[BossShopPro] " + message);
    }
}

