/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.core.BSShopHolder;
import org.black_ixx.bossshop.events.BSChoosePageLayoutEvent;
import org.black_ixx.bossshop.events.BSDisplayItemEvent;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.features.PageLayoutHandler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ShopCustomizer {
    public Inventory createInventory(BSShop shop, Set<BSBuy> items, Player p, ClassManager m, int page, int highest_page, BSShopHolder oldshopholder) {
        BSShopHolder holder = new BSShopHolder(shop, oldshopholder);
        holder.setPage(page);
        holder.setHighestPage(highest_page);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)shop.getInventorySize(), (String)shop.getValidDisplayName(p, holder));
        return this.createInventory(shop, items, p, m, inventory, holder, page);
    }

    public Inventory createInventory(BSShop shop, Set<BSBuy> items, Player p, ClassManager m, Inventory inventory, int page, int highest_page) {
        if (inventory.getHolder() instanceof BSShopHolder) {
            BSShopHolder holder = (BSShopHolder)inventory.getHolder();
            return this.createInventory(shop, items, p, m, inventory, holder, page);
        }
        return inventory;
    }

    public Inventory createInventory(BSShop shop, Set<BSBuy> items, Player p, ClassManager m, Inventory inventory, BSShopHolder holder, int page) {
        boolean bl;
        int slot;
        holder.setPage(page);
        LinkedHashMap<Integer, BSBuy> everything = new LinkedHashMap<Integer, BSBuy>();
        PageLayoutHandler layout = ClassManager.manager.getPageLayoutHandler();
        BSChoosePageLayoutEvent event = new BSChoosePageLayoutEvent(shop, shop.getShopName(), layout);
        Bukkit.getPluginManager().callEvent((Event)event);
        layout = event.getLayout();
        int max_rows = layout.getMaxRows();
        int items_per_page = layout.getReservedSlotsStart() - 1;
        int items_per_page_one_page = 9 * max_rows;
        int page_slot_start = items_per_page * page;
        int page_slot_end = items_per_page * (page + 1) - 1;
        for (BSBuy bSBuy : items) {
            if (bSBuy == null || !this.showItem(shop, holder, bSBuy, p, inventory, everything)) continue;
            slot = this.getSlot(inventory, everything, bSBuy);
            everything.put(slot, bSBuy);
        }
        int highest_slot = 0;
        Iterator iterator = ((HashMap)everything).keySet().iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            highest_slot = Math.max(highest_slot, slot);
        }
        boolean bl2 = false;
        if (page == 0 && highest_slot < items_per_page_one_page && layout.showIfMultiplePagesOnly()) {
            page_slot_end = items_per_page_one_page;
        } else {
            bl = true;
        }
        LinkedHashMap<Integer, BSBuy> locs = new LinkedHashMap<Integer, BSBuy>();
        Iterator iterator2 = ((HashMap)everything).keySet().iterator();
        while (iterator2.hasNext()) {
            int slot2 = (Integer)iterator2.next();
            if (slot2 < page_slot_start || slot2 > page_slot_end) continue;
            BSBuy buy3 = (BSBuy)((HashMap)everything).get(slot2);
            int real_slot = slot2 - page_slot_start;
            locs.put(real_slot, buy3);
            this.addItem(inventory, buy3.getItem(), real_slot, shop.isDisplaying(), p, buy3, shop, holder);
        }
        int highest_page = highest_slot / items_per_page;
        holder.setItems(locs, page, bl ? highest_page : 0);
        if (bl) {
            for (BSBuy buy : layout.getItems()) {
                if (!this.showItem(shop, holder, buy, p, inventory, locs)) continue;
                if (buy.getInventoryLocation() < 0 || buy.getInventoryLocation() >= items_per_page_one_page) {
                    ClassManager.manager.getBugFinder().warn("Unable to add pagelayout item '" + buy.getName() + "': Inventory location needs to be between 1 and " + items_per_page_one_page + " with 'MaxRows' set to '" + layout.getMaxRows() + "'.");
                    continue;
                }
                locs.put(buy.getInventoryLocation(), buy);
                buy.updateShop(shop, buy.getItem(), m, false);
                this.addItem(inventory, buy.getItem(), buy.getInventoryLocation(), shop.isDisplaying(), p, buy, shop, holder);
            }
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (locs.containsKey(i)) continue;
            inventory.setItem(i, null);
        }
        return inventory;
    }

    private void addItem(Inventory inventory, ItemStack item, int slot, boolean displaying, Player p, BSBuy buy, BSShop shop, BSShopHolder holder) {
        ItemStack current;
        if (displaying && p != null && item.hasItemMeta() && !buy.isItemFix()) {
            item = ClassManager.manager.getItemStackTranslator().translateItemStack(buy, shop, holder, item.clone(), p, true);
        }
        if ((current = inventory.getItem(slot)) != null && current.getType() == Material.PLAYER_HEAD && ClassManager.manager.getItemStackChecker().isEqualShopItemAdvanced(item, current, true, p)) {
            return;
        }
        inventory.setItem(slot, item);
    }

    public boolean showItem(BSShop shop, BSShopHolder holder, BSBuy buy, Player p, Inventory inventory, HashMap<Integer, BSBuy> filled_locs) {
        if (filled_locs.containsKey(buy.getInventoryLocation()) && filled_locs.get(buy.getInventoryLocation()) != buy) {
            return false;
        }
        if (p != null) {
            if (ClassManager.manager.getSettings().getPropertyBoolean(0, buy) & !buy.hasPermission(p, false, null)) {
                return false;
            }
            if (!buy.meetsCondition(holder, p)) {
                return false;
            }
            BSDisplayItemEvent event = new BSDisplayItemEvent(p, shop, buy, inventory);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
        }
        return true;
    }

    public int getSlot(Inventory inventory, HashMap<Integer, BSBuy> everything, BSBuy buy) {
        if (buy.getInventoryLocation() == -1) {
            return this.getFirstFreeSlot(inventory, everything);
        }
        return buy.getInventoryLocation();
    }

    public int getFirstFreeSlot(Inventory inventory, HashMap<Integer, BSBuy> everything) {
        for (int i = 0; i < 5000; ++i) {
            if (everything.containsKey(i)) continue;
            return i;
        }
        return -1;
    }
}

