/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers;

import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.api.BossShopAddon;
import org.black_ixx.bossshop.core.BSShops;
import org.black_ixx.bossshop.core.conditions.BSConditionType;
import org.black_ixx.bossshop.core.prices.BSPriceType;
import org.black_ixx.bossshop.core.rewards.BSRewardType;
import org.black_ixx.bossshop.events.BSRegisterTypesEvent;
import org.black_ixx.bossshop.managers.BuyItemHandler;
import org.black_ixx.bossshop.managers.MessageHandler;
import org.black_ixx.bossshop.managers.ShopCustomizer;
import org.black_ixx.bossshop.managers.config.ConfigHandler;
import org.black_ixx.bossshop.managers.config.FileHandler;
import org.black_ixx.bossshop.managers.external.BungeeCordManager;
import org.black_ixx.bossshop.managers.external.LanguageManager;
import org.black_ixx.bossshop.managers.external.PlaceholderAPIHandler;
import org.black_ixx.bossshop.managers.external.VaultHandler;
import org.black_ixx.bossshop.managers.external.spawners.ISpawnEggHandler;
import org.black_ixx.bossshop.managers.external.spawners.ISpawnerHandler;
import org.black_ixx.bossshop.managers.external.spawners.SpawnersHandlerEpicSpawners;
import org.black_ixx.bossshop.managers.external.spawners.SpawnersHandlerSilkSpawners;
import org.black_ixx.bossshop.managers.features.AutoRefreshHandler;
import org.black_ixx.bossshop.managers.features.BugFinder;
import org.black_ixx.bossshop.managers.features.ItemDataStorage;
import org.black_ixx.bossshop.managers.features.MultiplierHandler;
import org.black_ixx.bossshop.managers.features.PageLayoutHandler;
import org.black_ixx.bossshop.managers.features.PlayerDataHandler;
import org.black_ixx.bossshop.managers.features.PointsManager;
import org.black_ixx.bossshop.managers.features.StorageManager;
import org.black_ixx.bossshop.managers.features.TransactionLog;
import org.black_ixx.bossshop.managers.item.ItemDataPart;
import org.black_ixx.bossshop.managers.item.ItemStackChecker;
import org.black_ixx.bossshop.managers.item.ItemStackCreator;
import org.black_ixx.bossshop.managers.item.ItemStackTranslator;
import org.black_ixx.bossshop.managers.misc.StringManager;
import org.black_ixx.bossshop.managers.serverpinging.ServerPingingManager;
import org.black_ixx.bossshop.misc.MathTools;
import org.black_ixx.bossshop.settings.Settings;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class ClassManager {
    public static ClassManager manager;
    String USER = "%%__USER__%%";
    private ItemStackChecker itemstackChecker;
    private StringManager stringmanager;
    private PointsManager pointsmanager;
    private VaultHandler vaulthandler;
    private PlaceholderAPIHandler placeholderhandler;
    private MessageHandler messagehandler;
    private ItemStackCreator itemstackCreator;
    private ItemStackTranslator itemstackTranslator;
    private BuyItemHandler buyItemHandler;
    private ConfigHandler configHandler;
    private BugFinder bugfinder;
    private BossShop plugin;
    private Settings settings;
    private BSShops shops;
    private PageLayoutHandler pagelayoutHandler;
    private BungeeCordManager bungeeCordManager;
    private ShopCustomizer customizer;
    private TransactionLog transactionLog;
    private ServerPingingManager serverPingingManager;
    private AutoRefreshHandler autoRefreshHandler;
    private MultiplierHandler multiplierHandler;
    private StorageManager storageManager;
    private ISpawnEggHandler spawnEggHandler;
    private ISpawnerHandler spawnerHandler;
    private LanguageManager languageManager;
    private ItemDataStorage itemdataStorage;
    private PlayerDataHandler playerdataHandler;

    public ClassManager(BossShop plugin) {
        this.plugin = plugin;
        manager = this;
        this.settings = new Settings();
        new FileHandler().exportConfigs(plugin);
        BSRewardType.loadTypes();
        BSPriceType.loadTypes();
        BSConditionType.loadTypes();
        ItemDataPart.loadTypes();
        this.playerdataHandler = new PlayerDataHandler();
        this.configHandler = new ConfigHandler(plugin);
        MathTools.init(this.settings.getNumberLocale(), this.settings.getNumberGroupingSize());
        this.storageManager = new StorageManager(plugin);
        this.bugfinder = new BugFinder(plugin);
        this.itemdataStorage = new ItemDataStorage(plugin);
        this.multiplierHandler = new MultiplierHandler(plugin);
        this.stringmanager = new StringManager();
        this.itemstackCreator = new ItemStackCreator();
        this.itemstackTranslator = new ItemStackTranslator();
        this.buyItemHandler = new BuyItemHandler();
        this.itemstackChecker = new ItemStackChecker();
        this.messagehandler = new MessageHandler(plugin);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderhandler = new PlaceholderAPIHandler();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("LangUtils")) {
            this.languageManager = new LanguageManager();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("SilkSpawners")) {
            try {
                Class.forName("de.dustplanet.util.SilkUtil");
                SpawnersHandlerSilkSpawners h = new SpawnersHandlerSilkSpawners();
                this.spawnerHandler = h;
                this.spawnEggHandler = h;
            }
            catch (ClassNotFoundException e) {
                this.getBugFinder().warn("It seems like you have 'SilkSpawners' installed, but BossShopPro does not recognize the API of the plugin. Note: There are different SilkSpawners plugins around. The one BossShopPro can hook into is https://www.spigotmc.org/resources/7811/. Others are simply ignored.");
            }
        }
        if (Bukkit.getPluginManager().isPluginEnabled("EpicSpawners")) {
            this.spawnerHandler = new SpawnersHandlerEpicSpawners();
        }
    }

    public void setupDependentClasses() {
        Bukkit.getPluginManager().callEvent((Event)new BSRegisterTypesEvent());
        FileConfiguration config = this.plugin.getConfig();
        this.plugin.getInventoryListener().init(config.getInt("ClickDelay"), config.getInt("ClickSpamKick.ClickDelay"), config.getInt("ClickSpamKick.Warnings"), config.getInt("ClickSpamKick.ForgetTime"));
        this.pagelayoutHandler = new PageLayoutHandler(this.plugin);
        this.pointsmanager = new PointsManager();
        this.shops = new BSShops(this.plugin, this.settings);
        if (this.settings.getVaultEnabled()) {
            Plugin VaultPlugin = Bukkit.getServer().getPluginManager().getPlugin("Vault");
            if (VaultPlugin == null) {
                manager.getBugFinder().warn("Vault was not found... You need it if you want to work with Permissions, Permission Groups or Money! Get it there: http://dev.bukkit.org/server-mods/vault/");
            } else {
                this.vaulthandler = new VaultHandler(this.settings.getMoneyEnabled(), this.settings.getPermissionsEnabled());
            }
        }
        if (this.settings.getBalanceVariableEnabled() || this.settings.getBalancePointsVariableEnabled() || this.settings.getProperty(0).containsValueAny(true)) {
            this.customizer = new ShopCustomizer();
        }
        if (this.settings.getTransactionLogEnabled()) {
            this.transactionLog = new TransactionLog(this.plugin);
        }
        if (this.settings.getServerPingingEnabled(false)) {
            this.serverPingingManager = new ServerPingingManager(this.plugin);
            this.getServerPingingManager().getServerPingingRunnableHandler().start(this.settings.getServerPingingSpeed(), this.plugin, this.getServerPingingManager());
            this.getServerPingingManager().setReadyToTransform(true);
        }
        if (this.settings.getBungeeCordServerEnabled()) {
            this.bungeeCordManager = new BungeeCordManager();
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, "BungeeCord");
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, "BungeeCord", (PluginMessageListener)this.bungeeCordManager);
        }
        if (this.settings.getAutoRefreshSpeed() > 0) {
            this.autoRefreshHandler = new AutoRefreshHandler();
            this.autoRefreshHandler.start(this.settings.getAutoRefreshSpeed(), this.plugin);
        }
        if (this.plugin.getAPI().getEnabledAddons() != null) {
            for (BossShopAddon addon : this.plugin.getAPI().getEnabledAddons()) {
                addon.bossShopFinishedLoading();
            }
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ItemStackChecker getItemStackChecker() {
        return this.itemstackChecker;
    }

    public StringManager getStringManager() {
        return this.stringmanager;
    }

    public PointsManager getPointsManager() {
        return this.pointsmanager;
    }

    public VaultHandler getVaultHandler() {
        if (this.vaulthandler == null) {
            return new VaultHandler(manager.getSettings().getMoneyEnabled(), manager.getSettings().getPointsEnabled());
        }
        return this.vaulthandler;
    }

    public PlaceholderAPIHandler getPlaceholderHandler() {
        return this.placeholderhandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messagehandler;
    }

    public ItemStackCreator getItemStackCreator() {
        return this.itemstackCreator;
    }

    public ItemStackTranslator getItemStackTranslator() {
        return this.itemstackTranslator;
    }

    public BuyItemHandler getBuyItemHandler() {
        return this.buyItemHandler;
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public BugFinder getBugFinder() {
        return this.bugfinder;
    }

    public BossShop getPlugin() {
        return this.plugin;
    }

    public BSShops getShops() {
        return this.shops;
    }

    public PageLayoutHandler getPageLayoutHandler() {
        return this.pagelayoutHandler;
    }

    public PlayerDataHandler getPlayerDataHandler() {
        return this.playerdataHandler;
    }

    public BungeeCordManager getBungeeCordManager() {
        if (this.bungeeCordManager == null) {
            this.bungeeCordManager = new BungeeCordManager();
        }
        return this.bungeeCordManager;
    }

    public ShopCustomizer getShopCustomizer() {
        if (this.customizer == null) {
            this.customizer = new ShopCustomizer();
        }
        return this.customizer;
    }

    public TransactionLog getTransactionLog() {
        return this.transactionLog;
    }

    public ServerPingingManager getServerPingingManager() {
        return this.serverPingingManager;
    }

    public MultiplierHandler getMultiplierHandler() {
        return this.multiplierHandler;
    }

    public AutoRefreshHandler getAutoRefreshHandler() {
        return this.autoRefreshHandler;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public ISpawnerHandler getSpawnerHandler() {
        return this.spawnerHandler;
    }

    public ISpawnEggHandler getSpawnEggHandler() {
        return this.spawnEggHandler;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ItemDataStorage getItemDataStorage() {
        return this.itemdataStorage;
    }
}

