/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.inbuiltaddons.advancedshops;

import java.util.Map;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.BSInputType;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.core.conditions.BSCondition;
import org.black_ixx.bossshop.core.prices.BSPriceType;
import org.black_ixx.bossshop.core.rewards.BSRewardType;
import org.black_ixx.bossshop.inbuiltaddons.advancedshops.ActionSet;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class BSBuyAdvanced
extends BSBuy {
    private Map<ClickType, ActionSet> actions;

    public BSBuyAdvanced(BSRewardType rewardT, BSPriceType priceT, Object reward, Object price, String msg, int location, String permission, String name, BSCondition condition, BSInputType inputtype, String inputmessage, Map<ClickType, ActionSet> actions) {
        super(rewardT, priceT, reward, price, msg, location, permission, name, condition, inputtype, inputmessage);
        this.actions = actions;
    }

    @Override
    public BSRewardType getRewardType(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).getRewardType();
        }
        return super.getRewardType(clicktype);
    }

    @Override
    public BSPriceType getPriceType(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).getPriceType();
        }
        return super.getPriceType(clicktype);
    }

    @Override
    public Object getReward(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).getReward();
        }
        return super.getReward(clicktype);
    }

    @Override
    public Object getPrice(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).getPrice();
        }
        return super.getPrice(clicktype);
    }

    @Override
    public String getMessage(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).getMessage();
        }
        return super.getMessage(clicktype);
    }

    @Override
    public BSInputType getInputType(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).getInputType();
        }
        return super.getInputType(clicktype);
    }

    @Override
    public String getInputText(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).getInputText();
        }
        return super.getInputText(clicktype);
    }

    @Override
    public boolean isExtraPermissionGroup(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).isExtraPermissionGroup();
        }
        return super.isExtraPermissionGroup(clicktype);
    }

    @Override
    public String getExtraPermission(ClickType clicktype) {
        if (this.actions != null && this.actions.containsKey(clicktype)) {
            return this.actions.get(clicktype).getExtraPermission();
        }
        return super.getExtraPermission(clicktype);
    }

    @Override
    public String transformMessage(String msg, BSShop shop, Player p) {
        if ((msg = super.transformMessage(msg, shop, p)) == null) {
            return null;
        }
        if (msg.length() == 0) {
            return msg;
        }
        if (this.actions != null) {
            for (ClickType clicktype : this.actions.keySet()) {
                boolean possibly_customizable;
                String priceMessage;
                ActionSet action = this.actions.get(clicktype);
                String s = clicktype.name().toLowerCase();
                String tp = "%price_" + s + "%";
                String tr = "%reward_" + s + "%";
                if (!msg.contains(tp) && !msg.contains(tr)) continue;
                String rewardMessage = action.getRewardType().isPlayerDependend(this, clicktype) ? null : action.getRewardType().getDisplayReward(p, this, action.getReward(), clicktype);
                String string = priceMessage = action.getPriceType().isPlayerDependend(this, clicktype) ? null : action.getPriceType().getDisplayPrice(p, this, action.getPrice(), clicktype);
                if (shop != null && !shop.isCustomizable()) {
                    boolean has_rewardvariable;
                    boolean has_pricevariable = msg.contains(tp) && action.getPriceType().isPlayerDependend(this, clicktype);
                    boolean bl = has_rewardvariable = msg.contains(tr) && action.getRewardType().isPlayerDependend(this, clicktype);
                    if (has_pricevariable || has_rewardvariable) {
                        shop.setCustomizable(true);
                        shop.setDisplaying(true);
                    }
                }
                boolean bl = possibly_customizable = shop == null ? true : shop.isCustomizable();
                if (possibly_customizable && p != null) {
                    rewardMessage = action.getRewardType().getDisplayReward(p, this, action.getReward(), clicktype);
                    priceMessage = action.getPriceType().getDisplayPrice(p, this, action.getPrice(), clicktype);
                }
                if (priceMessage != null && priceMessage != "" && priceMessage.length() > 0) {
                    msg = msg.replace(tp, priceMessage);
                }
                if (rewardMessage == null || rewardMessage == "" || rewardMessage.length() <= 0) continue;
                msg = msg.replace(tr, rewardMessage);
            }
        }
        return msg;
    }
}

