/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.core;

import java.io.File;
import java.util.HashMap;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.core.BSShopHolder;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.config.BSConfigShop;
import org.black_ixx.bossshop.managers.config.FileHandler;
import org.black_ixx.bossshop.settings.Settings;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class BSShops {
    private HashMap<Integer, BSShop> shops = new HashMap();
    private HashMap<String, Integer> shopsIds = new HashMap();
    private int id = 0;

    public BSShops(BossShop plugin, Settings settings) {
        File folder = new File(plugin.getDataFolder().getAbsolutePath() + File.separator + "shops" + File.separator);
        new FileHandler().exportShops(plugin);
        boolean enable_shop_commands = this.loadShops(folder, settings, "");
        ClassManager.manager.getSettings().setShopCommandsEnabled(enable_shop_commands);
        BossShop.log("Loaded " + this.shops.size() + " Shops!");
    }

    private boolean loadShops(File folder, Settings settings, String parent_path) {
        boolean enable_shop_commands = false;
        for (File f : folder.listFiles()) {
            BSShop shop;
            if (f == null) continue;
            if (f.isDirectory()) {
                if (!settings.getLoadSubfoldersEnabled() || !this.loadShops(f, settings, f.getName() + File.separator)) continue;
                enable_shop_commands = true;
                continue;
            }
            if (!f.isFile() || !f.getName().contains(".yml") || (shop = this.loadShop(f, parent_path)).getCommands() == null) continue;
            enable_shop_commands = true;
        }
        return enable_shop_commands;
    }

    public void addShop(BSShop shop) {
        this.shops.put(shop.getShopId(), shop);
        if (this.shopsIds.containsKey(shop.getShopName().toLowerCase())) {
            ClassManager.manager.getBugFinder().warn("Two Shops with the same Name (" + shop.getShopName().toLowerCase() + ") are loaded. When opening a Shop via Name, only one of this Shops will be opened!");
        }
        this.shopsIds.put(shop.getShopName().toLowerCase(), shop.getShopId());
    }

    public BSShop loadShop(File f, String parent_path) {
        String name = parent_path + f.getName();
        BSConfigShop shop = new BSConfigShop(this.createId(), name, this);
        this.addShop(shop);
        return shop;
    }

    public void unloadShop(BSShop shop) {
        int id = this.getShopId(shop.getShopName());
        this.shopsIds.remove(shop.getShopName());
        this.shops.remove(id);
        shop.close();
    }

    public void openShop(Player p, String name) {
        if (!this.isShop(name)) {
            ClassManager.manager.getMessageHandler().sendMessage("Main.ShopNotExisting", (CommandSender)p);
            return;
        }
        this.openShop(p, this.getShopFast(name));
    }

    public void openShop(Player p, BSShop shop) {
        BSShopHolder holder;
        BSShopHolder old_shopholder;
        int page = 0;
        boolean remember_current_shop = true;
        InventoryView view = p.getOpenInventory();
        if (view != null && view.getTopInventory().getHolder() instanceof BSShopHolder && (old_shopholder = (holder = (BSShopHolder)view.getTopInventory().getHolder()).getPreviousShopHolder()) != null && old_shopholder.getShop() == shop) {
            page = old_shopholder.getPage();
            remember_current_shop = false;
        }
        shop.openInventory(p, page, remember_current_shop);
    }

    public BSShop getShop(String name) {
        return this.getShop(this.getShopId(name));
    }

    public BSShop getShopFast(String name) {
        return this.getShopFast(this.getShopId(name));
    }

    public BSShop getShopByCommand(String player_command) {
        if (player_command != null && player_command.length() > 0) {
            for (BSShop shop : this.shops.values()) {
                String[] commands = shop.getCommands();
                if (commands == null) continue;
                for (String command : commands) {
                    if (!command.equalsIgnoreCase(player_command)) continue;
                    return shop;
                }
            }
        }
        return null;
    }

    public BSShop getShop(int id) {
        return this.shops.containsKey(id) ? this.shops.get(id) : null;
    }

    public BSShop getShopFast(int id) {
        return this.shops.get(id);
    }

    public int getShopId(String name) {
        if (!this.shopsIds.containsKey(name = name.toLowerCase())) {
            return -1;
        }
        return this.shopsIds.get(name);
    }

    public boolean isShop(String name) {
        return this.shopsIds.containsKey(name);
    }

    public boolean isShop(int id) {
        return this.shops.containsKey(id);
    }

    public HashMap<Integer, BSShop> getShops() {
        return this.shops;
    }

    public HashMap<String, Integer> getShopIds() {
        return this.shopsIds;
    }

    public int createId() {
        ++this.id;
        return this.id;
    }

    public void refreshShops(boolean mode_serverpinging) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            Inventory open_inventory;
            BSShopHolder h;
            if (!ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory()) || !(h = (BSShopHolder)(open_inventory = p.getOpenInventory().getTopInventory()).getHolder()).getShop().isCustomizable() || mode_serverpinging || ClassManager.manager.getSettings().getServerPingingEnabled(true) && ClassManager.manager.getServerPingingManager().containsServerpinging(h.getShop())) continue;
            h.getShop().updateInventory(open_inventory, h, p, ClassManager.manager, h.getPage(), h.getHighestPage(), true);
        }
    }
}

