/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.core;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.BSShopHolder;
import org.black_ixx.bossshop.events.BSChoosePageLayoutEvent;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.features.PageLayoutHandler;
import org.black_ixx.bossshop.misc.Misc;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public abstract class BSShop {
    public static final int ROWS_LIMIT_CURRENT = ClassManager.manager.getPageLayoutHandler().getMaxRows();
    public static final int ROWS_LIMIT_TOTAL = 6;
    public static final int ROW_ITEMS = 9;
    private String shop_name = "BossShop";
    private String sign_text = "[BossShop]";
    private String displayname;
    private String[] commands;
    private boolean needPermToCreateSign = true;
    private boolean customizable = !ClassManager.manager.getPageLayoutHandler().showIfMultiplePagesOnly();
    private boolean displaying = false;
    private int inventory_size = 9;
    private int manual_inventory_rows;
    private int shop_id = 0;
    private int highest_page;
    private Set<BSBuy> items = new LinkedHashSet<BSBuy>();

    public BSShop(int shop_id, String shop_name, String sign_text, boolean needPermToCreateSign, BossShop plugin, String displayname, int manual_inventory_rows, String[] commands) {
        this.shop_id = shop_id;
        this.shop_name = shop_name;
        this.sign_text = sign_text;
        this.manual_inventory_rows = manual_inventory_rows;
        this.needPermToCreateSign = needPermToCreateSign;
        this.setCommands(commands);
        this.setDisplayName(displayname);
    }

    public BSShop(int shop_id) {
        this.shop_id = shop_id;
    }

    public String getShopName() {
        return this.shop_name;
    }

    public void setShopName(String name) {
        this.shop_name = name;
    }

    public String getDisplayName() {
        return this.displayname;
    }

    public void setDisplayName(String displayname) {
        if (displayname != null) {
            this.displayname = ClassManager.manager.getStringManager().transform(displayname, null, this, null, null);
            if (ClassManager.manager.getStringManager().checkStringForFeatures(this, null, null, this.displayname)) {
                this.customizable = true;
                this.displaying = true;
            }
        } else {
            this.displayname = this.shop_name;
        }
    }

    public String getValidDisplayName(Player p, BSShopHolder holder) {
        String displayname = this.displayname;
        displayname = ClassManager.manager.getStringManager().transform(displayname, null, this, holder, p);
        return displayname.length() > 32 ? displayname.substring(0, 32) : displayname;
    }

    public String getSignText() {
        return this.sign_text;
    }

    public void setSignText(String text) {
        this.sign_text = text;
    }

    public String[] getCommands() {
        return this.commands;
    }

    public void setCommands(String[] commands) {
        this.commands = commands;
    }

    public boolean needPermToCreateSign() {
        return this.needPermToCreateSign;
    }

    public boolean isCustomizable() {
        return this.customizable;
    }

    public void setCustomizable(boolean b) {
        this.customizable = b;
    }

    public boolean isDisplaying() {
        return this.displaying;
    }

    public void setDisplaying(boolean b) {
        this.displaying = b;
    }

    public int getInventorySize() {
        return this.inventory_size;
    }

    public int getShopId() {
        return this.shop_id;
    }

    public int getManualInventoryRows() {
        return this.manual_inventory_rows;
    }

    public void setManualInventoryRows(int i) {
        this.manual_inventory_rows = i;
    }

    public void setNeedPermToCreateSign(boolean b) {
        this.needPermToCreateSign = b;
    }

    public Set<BSBuy> getItems() {
        return this.items;
    }

    public BSBuy getItem(String name) {
        for (BSBuy buy : this.items) {
            if (!buy.getName().equalsIgnoreCase(name)) continue;
            return buy;
        }
        for (BSBuy buy : this.items) {
            if (!buy.getName().toLowerCase().startsWith(name.toLowerCase())) continue;
            return buy;
        }
        return null;
    }

    public void addShopItem(BSBuy buy, ItemStack menu_item, ClassManager manager) {
        buy.updateShop(this, menu_item, manager, true);
    }

    public void removeShopItem(BSBuy buy) {
        this.items.remove(buy);
    }

    public Inventory createInventory(Player p, ClassManager manager, int page, int highest_page, BSShopHolder oldshopholder) {
        return manager.getShopCustomizer().createInventory(this, this.items, p, manager, page, highest_page, oldshopholder);
    }

    public void updateInventory(Inventory i, BSShopHolder holder, Player p, ClassManager manager, int page, int highest_page, boolean auto_refresh) {
        if (holder.getPage() != page) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(11, this, null));
        }
        holder.setPage(page);
        holder.setHighestPage(highest_page);
        if (ClassManager.manager.getStringManager().checkStringForFeatures(this, null, null, this.getDisplayName()) & !this.getValidDisplayName(p, holder).equals(p.getOpenInventory().getTitle()) & !auto_refresh) {
            Inventory created = manager.getShopCustomizer().createInventory(this, this.items, p, manager, page, highest_page, holder.getPreviousShopHolder());
            p.openInventory(created);
            return;
        }
        Inventory inventory = manager.getShopCustomizer().createInventory(this, this.items, p, manager, i, page, highest_page);
        if (inventory != i) {
            p.openInventory(inventory);
        }
    }

    public void loadInventorySize() {
        PageLayoutHandler layout = ClassManager.manager.getPageLayoutHandler();
        BSChoosePageLayoutEvent event = new BSChoosePageLayoutEvent(this, this.getShopName(), layout);
        Bukkit.getPluginManager().callEvent((Event)event);
        layout = event.getLayout();
        if (!layout.showIfMultiplePagesOnly()) {
            this.inventory_size = 9 * layout.getMaxRows();
            return;
        }
        HashSet<Integer> used_slots = new HashSet<Integer>();
        int highest = 0;
        int different_slots_amount = 0;
        for (BSBuy b : this.items) {
            if (b == null) continue;
            if (b.getInventoryLocation() == -1) {
                ++different_slots_amount;
            } else if (!used_slots.contains(b.getInventoryLocation())) {
                used_slots.add(b.getInventoryLocation());
            }
            if (b.getInventoryLocation() <= highest) continue;
            highest = b.getInventoryLocation();
        }
        this.inventory_size = this.getInventorySize(Math.max(highest, (different_slots_amount += used_slots.size()) - 1));
    }

    @Deprecated
    public int getInventorySize(int i) {
        int rest;
        if ((rest = ++i % 9) > 0) {
            i += 9 - i % 9;
        }
        int max_slots_per_page = ROWS_LIMIT_CURRENT * 9;
        this.highest_page = !ClassManager.manager.getPageLayoutHandler().showIfMultiplePagesOnly() || i > max_slots_per_page ? i / (ClassManager.manager.getPageLayoutHandler().getReservedSlotsStart() - 1) : 0;
        return Math.min(max_slots_per_page, Math.max(i, 9 * this.manual_inventory_rows));
    }

    public void openInventory(Player p) {
        this.openInventory(p, 0, true);
    }

    public void openInventory(Player p, boolean remember_current_shop) {
        this.openInventory(p, 0, remember_current_shop);
    }

    public void openInventory(Player p, int page, boolean remember_current_shop) {
        InventoryView openinventory;
        BSShopHolder oldshopholder = null;
        if (remember_current_shop && (openinventory = p.getOpenInventory()) != null && openinventory.getTopInventory().getHolder() instanceof BSShopHolder) {
            oldshopholder = (BSShopHolder)openinventory.getTopInventory().getHolder();
        }
        ClassManager.manager.getMessageHandler().sendMessage("Main.OpenShop", (CommandSender)p, null, p, this, null, null);
        if (ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory())) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(12, this, null));
        } else {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(9, this, null));
        }
        p.openInventory(this.createInventory(p, ClassManager.manager, page, this.highest_page, oldshopholder));
        ClassManager.manager.getPlayerDataHandler().openedShop(p, this);
    }

    public void close() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            BSShopHolder holder;
            if (!ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory()) || (holder = (BSShopHolder)p.getOpenInventory().getTopInventory().getHolder()).getShop() != this) continue;
            p.closeInventory();
        }
    }

    public boolean isBeingAccessed(Player exclusion) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            BSShopHolder holder;
            if (!ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory()) || (holder = (BSShopHolder)p.getOpenInventory().getTopInventory().getHolder()).getShop() != this || p == exclusion) continue;
            return true;
        }
        return false;
    }

    public void finishedAddingItems() {
        this.loadInventorySize();
    }

    public abstract void reloadShop();
}

