/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.core;

import java.util.HashMap;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.core.BSInputType;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.core.BSShopHolder;
import org.black_ixx.bossshop.core.conditions.BSCondition;
import org.black_ixx.bossshop.core.prices.BSPriceType;
import org.black_ixx.bossshop.core.rewards.BSRewardType;
import org.black_ixx.bossshop.events.BSPlayerPurchaseEvent;
import org.black_ixx.bossshop.events.BSPlayerPurchasedEvent;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.config.BSConfigShop;
import org.black_ixx.bossshop.misc.Misc;
import org.black_ixx.bossshop.misc.ShopItemPurchaseTask;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BSBuy {
    private BSShop shop;
    private HashMap<Plugin, Object> special_information;
    private boolean fix_item;
    private ItemStack item;
    private String name;
    private BSInputType inputtype;
    private String inputtext;
    private BSRewardType rewardT;
    private BSPriceType priceT;
    private Object reward;
    private Object price;
    private BSCondition condition;
    private String permission;
    private boolean perm_is_group = false;
    private String msg;
    private int location;

    public BSBuy(BSRewardType rewardT, BSPriceType priceT, Object reward, Object price, String msg, int location, String permission, String name, BSCondition condition, BSInputType inputtype, String inputtext) {
        this(rewardT, priceT, reward, price, msg, location, permission, name);
        this.condition = condition;
        this.inputtype = inputtype;
        this.inputtext = ClassManager.manager.getStringManager().transform(inputtext, this, null, null, null);
    }

    public BSBuy(BSRewardType rewardT, BSPriceType priceT, Object reward, Object price, String msg, int location, String permission, String name) {
        this.priceT = priceT;
        this.rewardT = rewardT;
        if (permission != null && permission != "") {
            String group;
            this.permission = permission;
            if (permission.startsWith("[") && permission.endsWith("]") && permission.length() > 2 && (group = permission.substring(1, permission.length() - 1)) != null) {
                ClassManager.manager.getSettings().setVaultEnabled(true);
                this.permission = group;
                this.perm_is_group = true;
            }
        }
        this.reward = reward;
        this.price = price;
        this.name = name;
        this.msg = ClassManager.manager.getStringManager().transform(msg, this, null, null, null);
        this.location = location;
    }

    public BSShop getShop() {
        return this.shop;
    }

    public void setShop(BSShop shop) {
        this.shop = shop;
    }

    public BSRewardType getRewardType(ClickType clicktype) {
        return this.rewardT;
    }

    public BSPriceType getPriceType(ClickType clicktype) {
        return this.priceT;
    }

    public Object getReward(ClickType clicktype) {
        return this.reward;
    }

    public Object getPrice(ClickType clicktype) {
        return this.price;
    }

    public String getMessage(ClickType clicktype) {
        return this.msg;
    }

    public BSInputType getInputType(ClickType clicktype) {
        return this.inputtype;
    }

    public String getInputText(ClickType clicktype) {
        return this.inputtext;
    }

    public int getInventoryLocation() {
        return this.location;
    }

    @Deprecated
    public void setInventoryLocation(int i) {
        this.location = i;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean isItemFix() {
        return this.fix_item;
    }

    public BSCondition getCondition() {
        return this.condition;
    }

    public boolean meetsCondition(BSShopHolder holder, Player p) {
        if (this.condition != null) {
            return this.condition.meetsCondition(holder, this, p);
        }
        return true;
    }

    public boolean containsConditions() {
        return this.condition != null;
    }

    public ConfigurationSection getConfigurationSection(BSConfigShop shop) {
        return shop.getConfig().getConfigurationSection("shop").getConfigurationSection(this.name);
    }

    public boolean hasPermission(Player p, boolean msg, ClickType clicktype) {
        if (!this.isExtraPermissionExisting(clicktype)) {
            return true;
        }
        String permission = this.getExtraPermission(clicktype);
        if (this.isExtraPermissionGroup(clicktype)) {
            boolean no_group = true;
            for (String group : ClassManager.manager.getVaultHandler().getPermission().getPlayerGroups(p)) {
                no_group = false;
                if (!group.equalsIgnoreCase(permission)) continue;
                return true;
            }
            if (no_group && permission.equalsIgnoreCase("default")) {
                return true;
            }
            if (msg) {
                ClassManager.manager.getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)p);
            }
            return false;
        }
        if (p.hasPermission(permission)) {
            return true;
        }
        if (msg) {
            ClassManager.manager.getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)p);
        }
        return false;
    }

    public boolean isExtraPermissionExisting(ClickType clicktype) {
        String permission = this.getExtraPermission(clicktype);
        if (permission == null) {
            return false;
        }
        return !permission.equalsIgnoreCase("");
    }

    public boolean isExtraPermissionGroup(ClickType clicktype) {
        return this.perm_is_group;
    }

    public String getExtraPermission(ClickType clicktype) {
        return this.permission;
    }

    public Object readSpecialInformation(Plugin plugin) {
        if (this.special_information != null) {
            return this.special_information.get(plugin);
        }
        return null;
    }

    public String transformMessage(String msg, BSShop shop, Player p) {
        if (msg == null) {
            return null;
        }
        if (msg.length() == 0) {
            return msg;
        }
        if (p == null) {
            if (msg.contains("%input_text%")) {
                this.inputtype = BSInputType.TEXT;
            } else if (msg.contains("%input_player%")) {
                this.inputtype = BSInputType.PLAYER;
            }
            if (this.inputtype != null && shop != null) {
                shop.setCustomizable(true);
                shop.setDisplaying(true);
            }
        }
        if (msg.contains("%price%") || msg.contains("%reward%")) {
            boolean possibly_customizable;
            String priceMessage;
            String rewardMessage = this.rewardT.isPlayerDependend(this, null) ? null : this.rewardT.getDisplayReward(p, this, this.reward, null);
            String string = priceMessage = this.priceT.isPlayerDependend(this, null) ? null : this.priceT.getDisplayPrice(p, this, this.price, null);
            if (shop != null && !shop.isCustomizable()) {
                boolean has_rewardvariable;
                boolean has_pricevariable = msg.contains("%price%") && this.priceT.isPlayerDependend(this, null);
                boolean bl = has_rewardvariable = msg.contains("%reward%") && this.rewardT.isPlayerDependend(this, null);
                if (has_pricevariable || has_rewardvariable) {
                    shop.setCustomizable(true);
                    shop.setDisplaying(true);
                }
            }
            boolean bl = possibly_customizable = shop == null ? true : shop.isCustomizable();
            if (possibly_customizable && p != null) {
                rewardMessage = this.rewardT.getDisplayReward(p, this, this.reward, null);
                priceMessage = this.priceT.getDisplayPrice(p, this, this.price, null);
            }
            if (priceMessage != null && priceMessage != "" && priceMessage.length() > 0) {
                msg = msg.replace("%price%", priceMessage);
            }
            if (rewardMessage != null && rewardMessage != "" && rewardMessage.length() > 0) {
                msg = msg.replace("%reward%", rewardMessage);
            }
        }
        if (this.priceT != null && this.priceT.name() != "" && this.priceT.name().length() > 0) {
            msg = msg.replace(" %pricetype%", "");
            msg = msg.replace("%pricetype%", "");
        }
        if (this.rewardT != null && this.rewardT.name() != "" && this.rewardT.name().length() > 0) {
            msg = msg.replace(" %rewardtype%", "");
            msg = msg.replace("%rewardtype%", "");
        }
        msg = msg.replace("%shopitemname%", this.name);
        String name = this.name;
        if (shop != null && this.item != null) {
            String item_title = ClassManager.manager.getItemStackTranslator().readItemName(this.item);
            if (item_title != null) {
                name = item_title;
                msg = msg.replace("%itemname%", name);
            }
            if (msg.contains("%amount%")) {
                msg = msg.replace("%amount%", String.valueOf(this.item.getAmount()));
            }
            if (msg.contains("%material%")) {
                msg = msg.replace("%material%", ClassManager.manager.getItemStackTranslator().readMaterial(this.item));
            }
            if (msg.contains("%rewardraw%")) {
                msg = msg.replace("%rewardraw%", String.valueOf(this.reward));
            }
            if (msg.contains("%priceraw%")) {
                msg = msg.replace("%priceraw%", String.valueOf(this.price));
            }
        }
        return msg;
    }

    public void updateShop(BSShop shop, ItemStack menuitem, ClassManager manager, boolean add_item) {
        if (manager.getSettings().getPropertyBoolean(0, this) && !shop.isCustomizable() && this.isExtraPermissionExisting(null)) {
            shop.setCustomizable(true);
        }
        if (!shop.isCustomizable()) {
            for (BSBuy b : shop.getItems()) {
                if (b == null || b.getInventoryLocation() != this.getInventoryLocation() && !b.containsConditions()) continue;
                shop.setCustomizable(true);
                break;
            }
        }
        if (menuitem.hasItemMeta()) {
            if (ClassManager.manager.getItemStackTranslator().checkItemStackForFeatures(shop, this, menuitem)) {
                shop.setCustomizable(true);
                shop.setDisplaying(true);
            }
            if (!this.isItemFix()) {
                ClassManager.manager.getItemStackTranslator().translateItemStack(this, shop, null, menuitem, null, false);
            }
        }
        this.setItem(menuitem, !ClassManager.manager.getItemStackTranslator().checkItemStackForFeatures(shop, this, menuitem));
        if (this.isItemFix()) {
            ClassManager.manager.getItemStackTranslator().translateItemStack(null, null, null, this.getItem(), null, true);
        }
        if (add_item) {
            shop.getItems().add(this);
        }
    }

    public void putSpecialInformation(Plugin plugin, Object information) {
        if (plugin != null && information != null) {
            if (this.special_information == null) {
                this.special_information = new HashMap();
            }
            this.special_information.put(plugin, information);
        }
    }

    public void setItem(ItemStack item, boolean fix_item) {
        this.item = item;
        this.fix_item = fix_item;
    }

    public void click(Player p, BSShop shop, BSShopHolder holder, ClickType clicktype, InventoryClickEvent event, BossShop plugin) {
        if (!this.hasPermission(p, true, clicktype)) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(7, this, null));
            return;
        }
        if (!this.meetsCondition(holder, p)) {
            return;
        }
        this.purchaseTry(p, shop, holder, clicktype, event, plugin);
    }

    public void purchaseTry(Player p, BSShop shop, BSShopHolder holder, ClickType clicktype, InventoryClickEvent event, BossShop plugin) {
        BSPlayerPurchaseEvent e1 = new BSPlayerPurchaseEvent(p, shop, this, clicktype);
        Bukkit.getPluginManager().callEvent((Event)e1);
        if (e1.isCancelled()) {
            return;
        }
        BSRewardType rewardtype = this.getRewardType(clicktype);
        BSPriceType pricetype = this.getPriceType(clicktype);
        if (!rewardtype.canBuy(p, this, true, this.getReward(clicktype), clicktype)) {
            return;
        }
        if (!pricetype.hasPrice(p, this, this.getPrice(clicktype), clicktype, true)) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(8, this, null));
            return;
        }
        this.purchaseTask(p, shop, holder, clicktype, rewardtype, pricetype, event, plugin);
    }

    @Deprecated
    public void purchaseTask(Player p, BSShop shop, BSShopHolder holder, ClickType clicktype, BSRewardType rewardtype, BSPriceType pricetype, InventoryClickEvent event, BossShop plugin) {
        if (this.inputtype != null) {
            this.inputtype.forceInput(p, shop, this, holder, clicktype, rewardtype, pricetype, event, plugin);
            return;
        }
        if (ClassManager.manager.getSettings().getPurchaseAsync()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, (Runnable)new ShopItemPurchaseTask(p, this, shop, holder, clicktype, rewardtype, pricetype, event));
        } else {
            this.purchase(p, shop, holder, clicktype, rewardtype, pricetype, event, plugin, false);
        }
    }

    @Deprecated
    public void purchase(final Player p, final BSShop shop, final BSShopHolder holder, final ClickType clicktype, final BSRewardType rewardtype, BSPriceType pricetype, final InventoryClickEvent event, final BossShop plugin, boolean async) {
        boolean need_update;
        String message = this.getMessage(clicktype);
        if (message != null) {
            message = this.transformMessage(message, shop, p);
        }
        String o = null;
        if (!rewardtype.overridesPrice()) {
            o = pricetype.takePrice(p, this, this.getPrice(clicktype), clicktype);
        }
        if (plugin.getClassManager().getSettings().getPropertyBoolean(3, this)) {
            p.closeInventory();
        }
        if (!pricetype.overridesReward()) {
            if (async && rewardtype.allowAsync()) {
                new BukkitRunnable(){

                    public void run() {
                        rewardtype.giveReward(p, BSBuy.this, BSBuy.this.getReward(clicktype), clicktype);
                    }
                }.runTask((Plugin)plugin);
            } else {
                rewardtype.giveReward(p, this, this.getReward(clicktype), clicktype);
            }
        }
        if (rewardtype.overridesPrice()) {
            o = rewardtype.getPriceReturnMessage(p, this, pricetype, clicktype);
        }
        if (message != null) {
            if (o != null && o != "" && message.contains("%left%")) {
                message = message.replace("%left%", o);
            }
            message = plugin.getClassManager().getStringManager().transform(message, this, shop, holder, p);
        }
        boolean bl = need_update = rewardtype.mightNeedShopUpdate() || pricetype.mightNeedShopUpdate();
        if (plugin.getClassManager().getSettings().getTransactionLogEnabled()) {
            plugin.getClassManager().getTransactionLog().addTransaction(p, this, clicktype);
        }
        BSPlayerPurchasedEvent e2 = new BSPlayerPurchasedEvent(p, shop, this, clicktype);
        Bukkit.getPluginManager().callEvent((Event)e2);
        ClassManager.manager.getMessageHandler().sendMessageDirect(message, (CommandSender)p);
        if (pricetype != BSPriceType.Nothing) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(5, this, null));
        } else if (rewardtype.isActualReward()) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(6, this, null));
        }
        if (shop.isCustomizable() && need_update && event != null && p.getOpenInventory() == event.getView()) {
            if (async) {
                Bukkit.getScheduler().runTask((Plugin)ClassManager.manager.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        shop.updateInventory(event.getInventory(), holder, p, plugin.getClassManager(), holder.getPage(), holder.getHighestPage(), false);
                    }
                });
            } else {
                shop.updateInventory(event.getInventory(), holder, p, plugin.getClassManager(), holder.getPage(), holder.getHighestPage(), false);
            }
        }
    }
}

