/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop;

import org.black_ixx.bossshop.api.BossShopAPI;
import org.black_ixx.bossshop.api.BossShopAddon;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.events.BSReloadedEvent;
import org.black_ixx.bossshop.inbuiltaddons.InbuiltAddonLoader;
import org.black_ixx.bossshop.listeners.InventoryListener;
import org.black_ixx.bossshop.listeners.PlayerListener;
import org.black_ixx.bossshop.listeners.SignListener;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.CommandManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BossShop
extends JavaPlugin {
    public static final String NAME = "BossShopPro";
    String USER = "%%__USER__%%";
    private ClassManager manager;
    private InventoryListener il;
    private SignListener sl;
    private PlayerListener pl;
    private BossShopAPI api;

    public static void log(String s) {
        Bukkit.getLogger().info("[BossShopPro] " + s);
    }

    public static void debug(String s) {
        if (ClassManager.manager.getSettings().isDebugEnabled()) {
            BossShop.log(s);
        }
    }

    public void onEnable() {
        BossShop.log("Loading data...");
        this.manager = new ClassManager(this);
        this.api = new BossShopAPI(this);
        CommandManager commander = new CommandManager();
        if (this.getCommand("bs") != null) {
            this.getCommand("bs").setExecutor((CommandExecutor)commander);
        }
        if (this.getCommand("bossshop") != null) {
            this.getCommand("bossshop").setExecutor((CommandExecutor)commander);
        }
        if (this.getCommand("shop") != null) {
            this.getCommand("shop").setExecutor((CommandExecutor)commander);
        }
        this.il = new InventoryListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.il, (Plugin)this);
        this.sl = new SignListener(this.manager.getSettings().getSignsEnabled(), this);
        this.getServer().getPluginManager().registerEvents((Listener)this.sl, (Plugin)this);
        this.pl = new PlayerListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.pl, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                new InbuiltAddonLoader().load(BossShop.this);
                BossShop.this.getClassManager().setupDependentClasses();
            }
        }.runTaskLaterAsynchronously((Plugin)this, 5L);
    }

    public void onDisable() {
        this.closeShops();
        this.unloadClasses();
        BossShop.log("Disabling... bye!");
    }

    public ClassManager getClassManager() {
        return this.manager;
    }

    public SignListener getSignListener() {
        return this.sl;
    }

    public InventoryListener getInventoryListener() {
        return this.il;
    }

    public PlayerListener getPlayerListener() {
        return this.pl;
    }

    public BossShopAPI getAPI() {
        return this.api;
    }

    public void reloadPlugin(CommandSender sender) {
        this.closeShops();
        this.reloadConfig();
        this.manager.getMessageHandler().reloadConfig();
        if (this.manager.getShops() != null) {
            for (String s : this.manager.getShops().getShopIds().keySet()) {
                BSShop shop = this.manager.getShops().getShops().get(s);
                if (shop == null) continue;
                shop.reloadShop();
            }
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.api.isValidShop(p.getOpenInventory())) continue;
            p.closeInventory();
        }
        this.sl.setSignsEnabled(false);
        this.unloadClasses();
        this.manager = new ClassManager(this);
        if (this.api.getEnabledAddons() != null) {
            for (BossShopAddon addon : this.api.getEnabledAddons()) {
                addon.reload(sender);
            }
        }
        this.manager.setupDependentClasses();
        BSReloadedEvent event = new BSReloadedEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    private void unloadClasses() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.manager == null) {
            return;
        }
        if (this.manager.getSettings() == null) {
            return;
        }
        if (this.manager.getStorageManager() != null) {
            this.manager.getStorageManager().saveConfig();
        }
        if (this.manager.getItemDataStorage() != null) {
            this.manager.getItemDataStorage().saveConfig();
        }
        if (this.manager.getSettings().getTransactionLogEnabled()) {
            this.manager.getTransactionLog().saveConfig();
        }
        if (this.manager.getSettings().getServerPingingEnabled(true)) {
            this.manager.getServerPingingManager().getServerPingingRunnableHandler().stop();
            this.manager.getServerPingingManager().clear();
        }
        if (this.manager.getAutoRefreshHandler() != null) {
            this.manager.getAutoRefreshHandler().stop();
        }
    }

    private void closeShops() {
        if (this.manager == null || this.manager.getShops() == null || this.manager.getShops().getShops() == null) {
            return;
        }
        for (int i : this.manager.getShops().getShops().keySet()) {
            BSShop shop = this.manager.getShops().getShops().get(i);
            if (shop == null) continue;
            shop.close();
        }
    }
}

