/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.util;

import com.google.common.collect.ImmutableMap;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import io.lumine.mythic.lib.version.Attributes;
import io.lumine.mythic.lib.version.VPotionEffectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MMOUtils {
    private static final String UNIVERSAL_REFERENCE = "all";
    private static final Map<ChatColor, Color> COLOR_MAPPINGS = ImmutableMap.builder().put((Object)ChatColor.BLACK, (Object)Color.fromRGB((int)0, (int)0, (int)0)).put((Object)ChatColor.DARK_BLUE, (Object)Color.fromRGB((int)0, (int)0, (int)170)).put((Object)ChatColor.DARK_GREEN, (Object)Color.fromRGB((int)0, (int)170, (int)0)).put((Object)ChatColor.DARK_AQUA, (Object)Color.fromRGB((int)0, (int)170, (int)170)).put((Object)ChatColor.DARK_RED, (Object)Color.fromRGB((int)170, (int)0, (int)0)).put((Object)ChatColor.DARK_PURPLE, (Object)Color.fromRGB((int)170, (int)0, (int)170)).put((Object)ChatColor.GOLD, (Object)Color.fromRGB((int)255, (int)170, (int)0)).put((Object)ChatColor.GRAY, (Object)Color.fromRGB((int)170, (int)170, (int)170)).put((Object)ChatColor.DARK_GRAY, (Object)Color.fromRGB((int)85, (int)85, (int)85)).put((Object)ChatColor.BLUE, (Object)Color.fromRGB((int)85, (int)85, (int)255)).put((Object)ChatColor.GREEN, (Object)Color.fromRGB((int)85, (int)255, (int)85)).put((Object)ChatColor.AQUA, (Object)Color.fromRGB((int)85, (int)255, (int)255)).put((Object)ChatColor.RED, (Object)Color.fromRGB((int)255, (int)85, (int)85)).put((Object)ChatColor.LIGHT_PURPLE, (Object)Color.fromRGB((int)255, (int)85, (int)255)).put((Object)ChatColor.YELLOW, (Object)Color.fromRGB((int)255, (int)255, (int)85)).put((Object)ChatColor.WHITE, (Object)Color.fromRGB((int)255, (int)255, (int)255)).build();
    private static final String[] romanChars = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final int[] romanValues = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};

    public MMOUtils() {
        throw new IllegalArgumentException("This class cannot be instantiated.");
    }

    public static boolean isColorable(@NotNull Particle particle) {
        return particle.getDataType() == Particle.DustOptions.class;
    }

    public static String[] trimString(int charactersPerLine, String ... inputs) {
        ArrayList<String> list = new ArrayList<String>();
        for (String input : inputs) {
            if (input.length() <= charactersPerLine) {
                list.add(input);
                continue;
            }
            StringBuilder currentLine = new StringBuilder();
            for (String word : input.split(" ")) {
                if (!currentLine.isEmpty()) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                if (currentLine.length() <= charactersPerLine && !word.endsWith("\n")) continue;
                list.add(currentLine.toString());
                currentLine.setLength(0);
            }
            if (currentLine.isEmpty()) continue;
            list.add(currentLine.toString());
        }
        return list.toArray(new String[0]);
    }

    @NotNull
    public static ItemStack readIcon(@NotNull String stringInput) {
        Validate.notNull((Object)stringInput, (String)"Input must not be null");
        String[] split = stringInput.split(":");
        ItemStack stack = new ItemStack(Material.valueOf((String)UtilityMethods.enumName((String)split[0])));
        if (split.length > 1) {
            ItemMeta meta = stack.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(Integer.parseInt(split[1])));
            stack.setItemMeta(meta);
        }
        return stack;
    }

    public static double getForce(@NotNull EntityShootBowEvent event) {
        double force = event.getForce();
        return MythicLib.plugin.getVersion().isUnder(new int[]{1, 21}) ? force : force / 3.0;
    }

    public static boolean isSoulboundTo(@NotNull NBTItem item, @NotNull Player player) {
        String foundNbt = item.getString("MMOITEMS_SOULBOUND");
        return foundNbt != null && foundNbt.contains(player.getUniqueId().toString());
    }

    public static boolean hasBeenRemoved(@NotNull NBTItem item) {
        if (!item.hasType()) {
            return false;
        }
        String type = item.getType();
        return MMOUtils.isNonEmpty(type) && (!Type.isValid(type) || !MMOItems.plugin.getTemplates().hasTemplate(Type.get(type), item.getString("MMOITEMS_ITEM_ID")));
    }

    public static boolean isNonEmpty(@javax.annotation.Nullable String str) {
        return str != null && !str.isEmpty();
    }

    @NotNull
    public static String requireNonEmptyElse(@javax.annotation.Nullable String str, @NotNull String fallback) {
        return MMOUtils.isNonEmpty(str) ? str : Objects.requireNonNull(fallback);
    }

    public static boolean checkReference(@javax.annotation.Nullable String ref1, @javax.annotation.Nullable String ref2) {
        if (ref1 != null && ref1.equals(UNIVERSAL_REFERENCE)) {
            return true;
        }
        if (ref2 != null && ref2.equals(UNIVERSAL_REFERENCE)) {
            return true;
        }
        return Objects.equals(ref1, ref2);
    }

    @NotNull
    public static Color toRGB(ChatColor color) {
        return Objects.requireNonNull(COLOR_MAPPINGS.get(color), "Not a color");
    }

    public static int getPickaxePower(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return 0;
        }
        NBTItem nbt = NBTItem.get((ItemStack)item);
        if (nbt.hasTag("MMOITEMS_PICKAXE_POWER")) {
            return nbt.getInteger("MMOITEMS_PICKAXE_POWER");
        }
        switch (item.getType().name()) {
            case "WOODEN_PICKAXE": 
            case "WOOD_PICKAXE": {
                return 5;
            }
            case "STONE_PICKAXE": {
                return 10;
            }
            case "GOLDEN_PICKAXE": 
            case "GOLD_PICKAXE": {
                return 15;
            }
            case "IRON_PICKAXE": {
                return 20;
            }
            case "DIAMOND_PICKAXE": {
                return 25;
            }
            case "NETHERITE_PICKAXE": {
                return 30;
            }
        }
        return 0;
    }

    @Deprecated
    @NotNull
    public static TriggerType backwardsCompatibleTriggerType(@NotNull String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Trigger cannot be null");
        }
        switch (name) {
            case "ON_HIT": {
                return TriggerType.ATTACK;
            }
            case "WHEN_HIT": {
                return TriggerType.DAMAGED;
            }
        }
        return TriggerType.valueOf((String)name);
    }

    public static boolean isMMOItem(@javax.annotation.Nullable ItemStack item, @NotNull String type, @NotNull String id) {
        if (item == null) {
            return false;
        }
        NBTItem asNBT = NBTItem.get((ItemStack)item);
        String itemID = MMOUtils.getID(asNBT);
        if (itemID == null) {
            return false;
        }
        if (!itemID.equals(id)) {
            return false;
        }
        return asNBT.getType().equals(type);
    }

    @javax.annotation.Nullable
    public static Type getType(@javax.annotation.Nullable NBTItem nbtItem) {
        if (nbtItem == null || !nbtItem.hasType()) {
            return null;
        }
        return MMOItems.plugin.getTypes().get(nbtItem.getType());
    }

    @javax.annotation.Nullable
    public static String getID(@javax.annotation.Nullable NBTItem nbtItem) {
        if (nbtItem == null || !nbtItem.hasType()) {
            return null;
        }
        ItemTag type = ItemTag.getTagAtPath((String)"MMOITEMS_ITEM_ID", (NBTItem)nbtItem, (SupportedNBTTagValues)SupportedNBTTagValues.STRING);
        if (type == null) {
            return null;
        }
        return (String)type.getValue();
    }

    public static Vector normalize(Vector vector) {
        return vector.getX() == 0.0 && vector.getY() == 0.0 ? vector : vector.normalize();
    }

    public static double parseDouble(String format) {
        try {
            return Double.parseDouble(format);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("Could not read number from '" + format + "'");
        }
    }

    @javax.annotation.Nullable
    public static UUID UUIDFromString(@Nullable String anything) {
        if (anything == null) {
            return null;
        }
        if (anything.matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")) {
            return UUID.fromString(anything);
        }
        return null;
    }

    public static LivingEntity getDamager(EntityDamageByEntityEvent event) {
        Projectile proj;
        if (event.getDamager() instanceof LivingEntity) {
            return (LivingEntity)event.getDamager();
        }
        if (event.getDamager() instanceof Projectile && (proj = (Projectile)event.getDamager()).getShooter() instanceof LivingEntity) {
            return (LivingEntity)proj.getShooter();
        }
        return null;
    }

    public static int getLevel(@NotNull ItemStack item, @NotNull Enchantment enchant) {
        return item.hasItemMeta() ? item.getItemMeta().getEnchantLevel(enchant) : 0;
    }

    public static int getEffectDuration(PotionEffectType type) {
        return type.equals(PotionEffectType.NIGHT_VISION) || type.equals(VPotionEffectType.NAUSEA.get()) ? 260 : (type.equals(PotionEffectType.BLINDNESS) ? 140 : 100);
    }

    @NotNull
    public static String getDisplayName(@javax.annotation.Nullable ItemStack item) {
        if (item == null) {
            return "null";
        }
        return item.hasItemMeta() && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : MMOUtils.caseOnWords(item.getType().name().toLowerCase().replace("_", " "));
    }

    @Deprecated
    public static String caseOnWords(String s) {
        return UtilityMethods.caseOnWords((String)s);
    }

    public static boolean isMetaItem(ItemStack item, boolean lore) {
        return item != null && item.getType() != Material.AIR && item.getItemMeta() != null && item.getItemMeta().getDisplayName() != null && (!lore || item.getItemMeta().getLore() != null);
    }

    public static void saturate(@NotNull Player player, double saturation) {
        MMOUtils.saturate(player, saturation, true);
    }

    public static void saturate(@NotNull Player player, double saturation, boolean allowNegatives) {
        if (saturation > 0.0 || allowNegatives) {
            player.setSaturation(Math.max(0.0f, Math.min(20.0f, player.getSaturation() + (float)saturation)));
        }
    }

    public static void feed(@NotNull Player player, int feed) {
        MMOUtils.feed(player, feed, true);
    }

    public static void feed(@NotNull Player player, int feed, boolean allowNegatives) {
        if (feed > 0 || allowNegatives) {
            player.setFoodLevel(Math.max(Math.min(20, player.getFoodLevel() + feed), 0));
        }
    }

    public static void heal(@NotNull LivingEntity entity, double heal) {
        MMOUtils.heal(entity, heal, true);
    }

    public static void heal(@NotNull LivingEntity entity, double heal, boolean allowNegatives) {
        if (heal == 0.0) {
            return;
        }
        if (entity.isDead() || entity.getHealth() <= 0.0) {
            return;
        }
        if (heal < 0.0 && !allowNegatives) {
            return;
        }
        double maxHealth = entity.getAttribute(Attributes.MAX_HEALTH).getValue();
        entity.setHealth(Math.min(maxHealth, entity.getHealth() + heal));
    }

    public static String intToRoman(int input) {
        if (input < 1 || input > 3999) {
            throw new IllegalArgumentException("Input must be between 1 and 3999");
        }
        StringBuilder format = new StringBuilder();
        for (int i = 0; i < romanChars.length; ++i) {
            while (input >= romanValues[i]) {
                format.append(romanChars[i]);
                input -= romanValues[i];
            }
        }
        return format.toString();
    }

    public static double truncation(double x, int n) {
        double pow = Math.pow(10.0, n);
        return Math.floor(x * pow) / pow;
    }

    public static Vector rotateFunc(Vector v, Location loc) {
        double yaw = (double)(loc.getYaw() / 180.0f) * Math.PI;
        double pitch = (double)(loc.getPitch() / 180.0f) * Math.PI;
        v = MMOUtils.rotAxisX(v, pitch);
        v = MMOUtils.rotAxisY(v, -yaw);
        return v;
    }

    private static Vector rotAxisX(Vector v, double a) {
        double y = v.getY() * Math.cos(a) - v.getZ() * Math.sin(a);
        double z = v.getY() * Math.sin(a) + v.getZ() * Math.cos(a);
        return v.setY(y).setZ(z);
    }

    private static Vector rotAxisY(Vector v, double b) {
        double x = v.getX() * Math.cos(b) + v.getZ() * Math.sin(b);
        double z = v.getX() * -Math.sin(b) + v.getZ() * Math.cos(b);
        return v.setX(x).setZ(z);
    }

    private static Vector rotAxisZ(Vector v, double c) {
        double x = v.getX() * Math.cos(c) - v.getY() * Math.sin(c);
        double y = v.getX() * Math.sin(c) + v.getY() * Math.cos(c);
        return v.setX(x).setY(y);
    }

    public static List<Entity> getNearbyChunkEntities(Location loc) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        int cx = loc.getChunk().getX();
        int cz = loc.getChunk().getZ();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                entities.addAll(Arrays.asList(loc.getWorld().getChunkAt(cx + x, cz + z).getEntities()));
            }
        }
        return entities;
    }
}

