/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.tooltip;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.List;
import net.Indyuce.mmoitems.tooltip.CenteringOptions;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooltipTexture {
    private final String id;
    @NotNull
    private final String top;
    @NotNull
    private final String middle;
    @NotNull
    private final String bottom;
    @Nullable
    private final String bar;
    @Nullable
    private final String hideVanilla;
    @Nullable
    private final String alignText;
    private final List<String> loreHeader;
    private final int ignoreFirst;
    private final CenteringOptions centering;

    public TooltipTexture(@NotNull ConfigurationSection config) {
        this.id = UtilityMethods.enumName((String)config.getName());
        String alignLeft = UtilityMethods.getFontSpace((int)config.getInt("align_texture"));
        this.alignText = UtilityMethods.getFontSpace((int)config.getInt("align_text"));
        this.hideVanilla = UtilityMethods.getFontSpace((int)config.getInt("hide_texture"));
        this.top = alignLeft + config.getString("top") + this.alignText;
        this.loreHeader = config.getStringList("lore_header");
        this.middle = alignLeft + config.getString("middle") + this.alignText;
        this.bar = config.get("bar") != null ? alignLeft + config.getString("bar") : null;
        this.bottom = alignLeft + config.getString("bottom");
        this.ignoreFirst = config.getInt("ignore_first");
        try {
            this.centering = config.isConfigurationSection("center") ? new CenteringOptions(config.getConfigurationSection("center")) : null;
        }
        catch (RuntimeException exception) {
            throw new RuntimeException("Could not load centering options: " + exception.getMessage());
        }
        Validate.notNull((Object)this.top, (String)"Tooltip top portion cannot be null");
        Validate.notNull((Object)this.middle, (String)"Tooltip middle portion cannot be null");
        Validate.notNull((Object)this.bottom, (String)"Tooltip bottom portion cannot be null");
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getTop() {
        return this.top;
    }

    @NotNull
    public String getMiddle() {
        return this.middle;
    }

    @NotNull
    public String getAlignText() {
        return this.alignText;
    }

    @NotNull
    public String getBottom() {
        return this.bottom;
    }

    @NotNull
    public String getBar() {
        return this.bar == null ? this.middle : this.bar;
    }

    @NotNull
    public String getSuffix() {
        return this.hideVanilla;
    }

    public int getFirstIgnored() {
        return this.ignoreFirst;
    }

    @Nullable
    public CenteringOptions getCenteringOptions() {
        return this.centering;
    }

    @Nullable
    public List<String> getLoreHeader() {
        return this.loreHeader;
    }
}

