/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.tooltip;

import io.lumine.mythic.lib.UtilityMethods;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class CenteringOptions {
    private final boolean name;
    private final double nameFontSize;
    private final int nameSpan;
    private final String namePrefix;
    private final int loreLines;
    private final List<Double> loreFontSize;
    private final List<Integer> loreSpan;
    private final Pattern regex;
    private static final String DEFAULT_REGEX = "(?i)[^&\u00a7][a-z][a-z ]*[a-z]";
    private static final double SEPARATOR_SPACE = 1.0;

    public CenteringOptions(@NotNull ConfigurationSection config) {
        this.name = config.getBoolean("display_name.enabled");
        this.nameFontSize = config.getDouble("display_name.font_size");
        this.nameSpan = config.getInt("display_name.span");
        this.namePrefix = config.getString("display_name.prefix", "");
        this.loreLines = config.getInt("lore.lines");
        this.loreFontSize = config.getDoubleList("lore.font_size");
        this.loreSpan = config.getIntegerList("lore.span");
        Validate.isTrue((this.name || this.loreLines > 0 ? 1 : 0) != 0, (String)"Centering must be enabled for at least one lore line or the display name");
        Validate.isTrue((this.loreLines >= 0 ? 1 : 0) != 0, (String)"Lore line count must be positive");
        if (this.loreLines > 0) {
            double d;
            Validate.isTrue((!this.loreFontSize.isEmpty() ? 1 : 0) != 0, (String)"You must provide at least one lore font size");
            Validate.isTrue((!this.loreSpan.isEmpty() ? 1 : 0) != 0, (String)"You must provide at least one lore span");
            Iterator<Number> iterator = this.loreFontSize.iterator();
            while (iterator.hasNext()) {
                d = iterator.next();
                Validate.isTrue((d > 0.0 ? 1 : 0) != 0, (String)"Font size must be positive");
            }
            iterator = this.loreSpan.iterator();
            while (iterator.hasNext()) {
                d = ((Integer)iterator.next()).intValue();
                Validate.isTrue((d > 0.0 ? 1 : 0) != 0, (String)"Font size must be positive");
            }
        }
        if (this.name) {
            Validate.isTrue((this.nameFontSize > 0.0 ? 1 : 0) != 0, (String)"Font size must be positive");
            Validate.isTrue((this.nameSpan > 0 ? 1 : 0) != 0, (String)"Name must be positive");
        }
        this.regex = Pattern.compile(config.getString("regex", DEFAULT_REGEX));
    }

    public boolean displayName() {
        return this.name;
    }

    public int getLoreLines() {
        return this.loreLines;
    }

    @NotNull
    public String centerLore(int j, String line) {
        return this.center(line, "", this.loreFontSize.get(Math.min(j, this.loreFontSize.size() - 1)), this.loreSpan.get(Math.min(j, this.loreSpan.size() - 1)));
    }

    @NotNull
    public String centerName(@NotNull String line) {
        return this.center(line, this.namePrefix, this.nameFontSize, this.nameSpan);
    }

    @NotNull
    private String center(@NotNull String line, @NotNull String prefix, double fontSize, int span) {
        Matcher matcher = this.regex.matcher(line);
        if (!matcher.find()) {
            return line;
        }
        int start = matcher.start();
        int end = matcher.end();
        int length = (int)(fontSize * (double)(end - start) + 1.0 * (double)this.countSeparators(line.substring(start, end)));
        if (length >= span) {
            return line;
        }
        int offset = (span - length) / 2;
        return line.substring(0, start) + UtilityMethods.getFontSpace((int)offset) + prefix + line.substring(start);
    }

    private int countSeparators(@NotNull String str) {
        int count = 0;
        boolean prevSpace = true;
        for (int i = 0; i < str.length(); ++i) {
            boolean space;
            boolean bl = space = str.charAt(i) == ' ';
            if (!prevSpace && !space) {
                ++count;
            }
            prevSpace = space;
        }
        return count;
    }
}

