/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.type;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringStat
extends ItemStat<StringData, StringData> {
    public StringStat(String id, Material mat, String name, String[] lore, String[] types, Material ... materials) {
        super(id, mat, name, lore, types, materials);
    }

    @Override
    public StringData whenInitialized(Object object) {
        return new StringData(object.toString());
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull StringData data) {
        item.addItemTag(this.getAppliedNBT(data));
        item.getLore().insert(this.getPath(), this.getGeneralStatFormat().replace("{value}", data.toString()));
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull StringData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)data.toString()));
        return ret;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_HALF) {
            inv.getEditedSection().set(this.getPath(), null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + this.getName() + ".");
        } else {
            new StatEdition(inv, this, new Object[0]).enable("Write in the chat the text you want.");
        }
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        inv.getEditedSection().set(this.getPath(), (Object)message);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + this.getName() + " successfully changed to '" + MythicLib.plugin.parseColors(message) + ChatColor.GRAY + "'.");
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData bakedData;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.STRING));
        }
        if ((bakedData = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, bakedData);
        }
    }

    @Override
    @Nullable
    public StringData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tg = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tg != null) {
            String value = (String)tg.getValue();
            return new StringData(value);
        }
        return null;
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<StringData> statData) {
        if (statData.isPresent()) {
            String value = MythicLib.plugin.parseColors(statData.get().toString());
            value = value.length() > 40 ? value.substring(0, 40) + "..." : value;
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GREEN + value);
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.RED + "None");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to change this value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove this value.");
    }

    @Override
    @NotNull
    public StringData getClearStatData() {
        return new StringData("");
    }
}

