/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.type;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.gson.JsonArray;
import io.lumine.mythic.lib.gson.JsonElement;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.Indyuce.mmoitems.ItemStats;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.stat.data.EnchantListData;
import net.Indyuce.mmoitems.stat.data.GemSocketsData;
import net.Indyuce.mmoitems.stat.data.GemstoneData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.data.type.UpgradeInfo;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.Upgradable;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatHistory {
    private final ItemStat itemStat;
    private StatData originalData;
    private MMOItem parent;
    private HashMap<UUID, StatData> perModifierBonus = new HashMap();
    private ArrayList<StatData> perExternalData = new ArrayList();
    private HashMap<UUID, StatData> perGemstoneData = new HashMap();
    private static final String ENC_STAT = "Stat";
    private static final String ENC_OGS = "OGStory";
    private static final String ENC_GSS = "Gemstory";
    private static final String ENC_EXS = "Exstory";
    private static final String ENC_MOD = "Mod";

    public StatHistory(@NotNull MMOItem parentItem, @NotNull ItemStat parentStat, @NotNull StatData parentData) {
        this.itemStat = parentStat;
        this.originalData = parentData;
        this.parent = parentItem;
    }

    @NotNull
    public ItemStat getItemStat() {
        return this.itemStat;
    }

    @NotNull
    public MMOItem getMMOItem() {
        return this.parent;
    }

    @NotNull
    public StatData getOriginalData() {
        return this.originalData;
    }

    public boolean isEmpty() {
        if (this.getOriginalData() instanceof EnchantListData && ((EnchantListData)this.getOriginalData()).getEnchants().size() != 0) {
            return false;
        }
        if (this.getAllGemstones().size() > 0 || this.getExternalData().size() > 0 || this.getAllModifiers().size() > 0) {
            return false;
        }
        if (this.getOriginalData().isEmpty() && (!this.isUpgradeable() || this.getMMOItem().getUpgradeLevel() == 0)) {
            return true;
        }
        return this.getOriginalData().equals(this.getMMOItem().getData(this.getItemStat()));
    }

    @NotNull
    public StatHistory setParent(@NotNull MMOItem parent) {
        this.parent = parent;
        return this;
    }

    public void setOriginalData(@NotNull StatData s) {
        Validate.notNull((Object)s, (String)"Original data cannot be null");
        this.originalData = s;
    }

    @Nullable
    public StatData getModifiersBonus(@NotNull UUID of) {
        return this.perModifierBonus.get(of);
    }

    public void registerModifierBonus(@NotNull UUID of, @NotNull StatData data) {
        Validate.notNull((Object)of, (String)"Modifier UUID cannot be null");
        Validate.notNull((Object)data, (String)"Stat data cannot be null");
        if (data.isEmpty()) {
            return;
        }
        this.perModifierBonus.put(of, data);
    }

    public void removeModifierBonus(@NotNull UUID of) {
        this.perModifierBonus.remove(of);
    }

    @NotNull
    public ArrayList<UUID> getAllModifiers() {
        return new ArrayList<UUID>(this.perModifierBonus.keySet());
    }

    public void clearModifiersBonus() {
        this.perModifierBonus.clear();
    }

    @Nullable
    public StatData getGemstoneData(@NotNull UUID of) {
        return this.perGemstoneData.get(of);
    }

    public void removeGemData(@NotNull UUID of) {
        this.perGemstoneData.remove(of);
    }

    @NotNull
    public ArrayList<UUID> getAllGemstones() {
        return new ArrayList<UUID>(this.perGemstoneData.keySet());
    }

    public void registerGemstoneData(@NotNull UUID of, @NotNull StatData data) {
        Validate.notNull((Object)of, (String)"Gemstone ID cannot be null");
        Validate.notNull((Object)data, (String)"Stat data cannot be null");
        if (data.isEmpty()) {
            return;
        }
        this.perGemstoneData.put(of, data);
    }

    public void clearGemstones() {
        this.perGemstoneData.clear();
    }

    @NotNull
    public ArrayList<StatData> getExternalData() {
        return this.perExternalData;
    }

    public void fuseExternalData() {
        Object theEXSH = this.getItemStat().getClearStatData();
        for (StatData ex : this.getExternalData()) {
            ((Mergeable)theEXSH).mergeWith((Mergeable)ex);
        }
        this.getExternalData().clear();
        this.registerExternalData((StatData)theEXSH);
    }

    public void registerExternalData(@NotNull StatData data) {
        Validate.notNull((Object)data, (String)"Stat data cannot be null");
        if (data.isEmpty()) {
            return;
        }
        this.perExternalData.add(data);
    }

    public void clearExternalData() {
        this.perExternalData.clear();
    }

    public void purgeGemstones() {
        GemSocketsData data = (GemSocketsData)this.getMMOItem().getData(ItemStats.GEM_SOCKETS);
        if (data == null) {
            this.perGemstoneData.clear();
            return;
        }
        HashMap<UUID, StatData> newPerGemstoneData = new HashMap<UUID, StatData>();
        for (GemstoneData gemData : data.getGemstones()) {
            StatData found = this.perGemstoneData.get(gemData.getHistoricUUID());
            if (found == null) continue;
            newPerGemstoneData.put(gemData.getHistoricUUID(), found);
        }
        this.perGemstoneData = newPerGemstoneData;
    }

    @NotNull
    public StatData recalculate(int level) {
        return this.recalculate(true, level);
    }

    @NotNull
    public StatData recalculateUnupgraded() {
        return this.recalculate(true, null);
    }

    private int findLevel(int upgradeLevel, UUID gemstoneId) {
        for (GemstoneData gemstone : this.getMMOItem().getGemstones()) {
            if (!gemstone.getHistoricUUID().equals(gemstoneId)) continue;
            return gemstone.isScaling() ? gemstone.getLevel() : upgradeLevel;
        }
        throw new IllegalArgumentException("Could not find level of gem " + gemstoneId);
    }

    @NotNull
    public StatData recalculate(boolean purgeFirst, @Nullable Integer upgradeLevel) {
        if (purgeFirst) {
            this.purgeGemstones();
        }
        UpgradeInfo upgradeInfo = upgradeLevel != null && upgradeLevel != 0 && this.getItemStat() instanceof Upgradable ? this.getMMOItem().getUpgradeTemplate().getUpgradeInfo(this.getItemStat()) : null;
        Object finalData = ((Mergeable)this.originalData).clone();
        for (StatData data : this.perModifierBonus.values()) {
            finalData.mergeWith((Mergeable)((Mergeable)data));
        }
        if (upgradeInfo != null) {
            finalData = (Mergeable)((Upgradable)((Object)this.getItemStat())).apply((StatData)finalData, upgradeInfo, upgradeLevel);
        }
        for (UUID gemstoneId : this.perGemstoneData.keySet()) {
            Mergeable gsData = (Mergeable)this.getGemstoneData(gemstoneId);
            if (upgradeInfo != null) {
                int levelDifference = upgradeLevel - this.findLevel(upgradeLevel, gemstoneId);
                gsData = (Mergeable)((Upgradable)((Object)this.getItemStat())).apply((StatData)gsData.clone(), upgradeInfo, levelDifference);
            }
            finalData.mergeWith((Mergeable)gsData);
        }
        for (StatData externalData : this.getExternalData()) {
            finalData.mergeWith((Mergeable)externalData);
        }
        return finalData;
    }

    @NotNull
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty(ENC_STAT, this.getItemStat().getId());
        if (!this.getOriginalData().isEmpty() || this.getItemStat() == ItemStats.ENCHANTS) {
            object.add(ENC_OGS, (JsonElement)ItemTag.compressTags(this.getItemStat().getAppliedNBT(this.getOriginalData())));
        }
        JsonArray gemz = new JsonArray();
        for (UUID uUID : this.getAllGemstones()) {
            JsonObject yes = new JsonObject();
            JsonArray yesCompressed = ItemTag.compressTags(this.getItemStat().getAppliedNBT(this.getGemstoneData(uUID)));
            yes.add(uUID.toString(), (JsonElement)yesCompressed);
            gemz.add((JsonElement)yes);
        }
        if (gemz.size() > 0) {
            object.add(ENC_GSS, (JsonElement)gemz);
        }
        JsonArray externals = new JsonArray();
        for (StatData ex : this.getExternalData()) {
            if (ex.isEmpty()) continue;
            externals.add((JsonElement)ItemTag.compressTags(this.getItemStat().getAppliedNBT(ex)));
        }
        if (!externals.isEmpty()) {
            object.add(ENC_EXS, (JsonElement)externals);
        }
        JsonArray jsonArray = new JsonArray();
        for (UUID mod : this.getAllModifiers()) {
            JsonObject yes = new JsonObject();
            JsonArray yesCompressed = ItemTag.compressTags(this.getItemStat().getAppliedNBT(this.getModifiersBonus(mod)));
            yes.add(mod.toString(), (JsonElement)yesCompressed);
            jsonArray.add((JsonElement)yes);
        }
        if (jsonArray.size() > 0) {
            object.add(ENC_MOD, (JsonElement)jsonArray);
        }
        return object;
    }

    @NotNull
    public String toNBTString() {
        return this.toJson().toString();
    }

    public boolean isUpgradeable() {
        return this.getMMOItem().hasUpgradeTemplate() && this.getMMOItem().getUpgradeTemplate().getUpgradeInfo(this.getItemStat()) != null;
    }

    @Nullable
    public static StatHistory fromJson(@NotNull MMOItem iSource, @NotNull JsonObject json) {
        ArrayList tags;
        JsonElement compressedTags;
        UUID actualUUID;
        Set contained;
        JsonObject element;
        Object sData;
        JsonElement ogStatsEncode = null;
        JsonElement gemsEncode = null;
        JsonElement extEncode = null;
        JsonElement modEncode = null;
        if (!json.has(ENC_STAT)) {
            return null;
        }
        JsonElement statEncode = json.get(ENC_STAT);
        if (json.has(ENC_OGS)) {
            ogStatsEncode = json.get(ENC_OGS);
        }
        if (json.has(ENC_GSS)) {
            gemsEncode = json.get(ENC_GSS);
        }
        if (json.has(ENC_EXS)) {
            extEncode = json.get(ENC_EXS);
        }
        if (json.has(ENC_MOD)) {
            modEncode = json.get(ENC_MOD);
        }
        if (!statEncode.isJsonPrimitive()) {
            return null;
        }
        if (ogStatsEncode != null && !ogStatsEncode.isJsonArray()) {
            return null;
        }
        if (gemsEncode != null && !gemsEncode.isJsonArray()) {
            return null;
        }
        if (extEncode != null && !extEncode.isJsonArray()) {
            return null;
        }
        if (modEncode != null && !modEncode.isJsonArray()) {
            return null;
        }
        String statInternalName = statEncode.getAsJsonPrimitive().getAsString();
        ItemStat<?, ?> stat = MMOItems.plugin.getStats().get(statInternalName);
        if (stat == null) {
            return null;
        }
        if (ogStatsEncode != null) {
            ArrayList ogDecoded = ItemTag.decompressTags((JsonArray)ogStatsEncode.getAsJsonArray());
            sData = stat.getLoadedNBT(ogDecoded);
        } else {
            sData = stat.getClearStatData();
        }
        if (sData == null) {
            return null;
        }
        StatHistory sHistory = new StatHistory(iSource, stat, (StatData)sData);
        if (gemsEncode != null) {
            for (JsonElement elmnt : gemsEncode.getAsJsonArray()) {
                if (!elmnt.isJsonObject()) continue;
                element = elmnt.getAsJsonObject();
                contained = element.entrySet();
                for (Map.Entry entry : contained) {
                    Object gemData;
                    String gemUUID = (String)entry.getKey();
                    actualUUID = MMOUtils.UUIDFromString(gemUUID);
                    compressedTags = (JsonElement)entry.getValue();
                    if (!compressedTags.isJsonArray() || actualUUID == null || (gemData = stat.getLoadedNBT(tags = ItemTag.decompressTags((JsonArray)compressedTags.getAsJsonArray()))) == null) continue;
                    sHistory.registerGemstoneData(actualUUID, (StatData)gemData);
                }
            }
        }
        if (extEncode != null) {
            for (JsonElement elmnt : extEncode.getAsJsonArray()) {
                ArrayList tags2;
                Object exData;
                if (!elmnt.isJsonArray() || (exData = stat.getLoadedNBT(tags2 = ItemTag.decompressTags((JsonArray)elmnt.getAsJsonArray()))) == null) continue;
                sHistory.registerExternalData((StatData)exData);
            }
        }
        if (modEncode != null) {
            for (JsonElement elmnt : modEncode.getAsJsonArray()) {
                if (!elmnt.isJsonObject()) continue;
                element = elmnt.getAsJsonObject();
                contained = element.entrySet();
                for (Map.Entry entry : contained) {
                    Object modData;
                    String modUUID = (String)entry.getKey();
                    actualUUID = MMOUtils.UUIDFromString(modUUID);
                    compressedTags = (JsonElement)entry.getValue();
                    if (!compressedTags.isJsonArray() || actualUUID == null || (modData = stat.getLoadedNBT(tags = ItemTag.decompressTags((JsonArray)compressedTags.getAsJsonArray()))) == null) continue;
                    sHistory.registerModifierBonus(actualUUID, (StatData)modData);
                }
            }
        }
        return sHistory;
    }

    @Nullable
    public static StatHistory fromNBTString(@NotNull MMOItem iSource, @NotNull String codedJson) {
        try {
            JsonParser pJSON = new JsonParser();
            JsonObject oJSON = pJSON.parse(codedJson).getAsJsonObject();
            return StatHistory.fromJson(iSource, oJSON);
        }
        catch (Throwable e) {
            FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
            ffp.activatePrefix(true, "Stat History");
            ffp.log(FriendlyFeedbackCategory.ERROR, "Could not get stat history: $f{0}$b at $f{1}", new String[]{e.getMessage(), e.getStackTrace()[0].toString()});
            ffp.sendTo(FriendlyFeedbackCategory.ERROR, MMOItems.getConsole());
            return null;
        }
    }

    @NotNull
    public StatHistory clone() {
        StatHistory res = new StatHistory(this.getMMOItem(), this.getItemStat(), (StatData)((Mergeable)this.getOriginalData()).clone());
        this.perGemstoneData.forEach((uuid, statData) -> res.perGemstoneData.put((UUID)uuid, (StatData)((Mergeable)statData).clone()));
        this.perExternalData.forEach(statData -> res.perExternalData.add((StatData)((Mergeable)statData).clone()));
        this.perModifierBonus.forEach((uuid, statData) -> res.perModifierBonus.put((UUID)uuid, (StatData)((Mergeable)statData).clone()));
        return res;
    }

    public void assimilate(@NotNull StatHistory other) {
        if (other.getItemStat().getNBTPath().equals(this.getItemStat().getNBTPath())) {
            for (UUID exUID : other.getAllGemstones()) {
                this.registerGemstoneData(exUID, other.getGemstoneData(exUID));
            }
            for (StatData ex : other.getExternalData()) {
                this.registerExternalData(ex);
            }
            for (UUID exUID : other.getAllModifiers()) {
                this.registerModifierBonus(exUID, other.getModifiersBonus(exUID));
            }
        }
    }

    @Deprecated
    public StatHistory clone(@NotNull MMOItem newParent) {
        StatHistory his = this.clone();
        his.setParent(newParent);
        return his;
    }

    @Deprecated
    @NotNull
    public static StatHistory from(@NotNull MMOItem ofItem, @NotNull ItemStat ofStat) {
        return ofItem.computeStatHistory(ofStat);
    }

    @Deprecated
    @NotNull
    public static StatHistory from(@NotNull MMOItem parentItem, @NotNull ItemStat stat, boolean forceNew) {
        if (forceNew) {
            StatHistory newHist = new StatHistory(parentItem, stat, Objects.requireNonNull(parentItem.getData(stat)));
            parentItem.setStatHistory(stat, newHist);
            return newHist;
        }
        return parentItem.computeStatHistory(stat);
    }

    @Deprecated
    @NotNull
    public StatData recalculateUnupgraded(boolean withPurge) {
        return this.recalculate(withPurge, null);
    }

    @Deprecated
    public boolean isClear() {
        return this.isEmpty();
    }

    @Deprecated
    public void consolidateEXSH() {
        this.fuseExternalData();
    }
}

