/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.type;

import io.lumine.mythic.lib.api.item.ItemTag;
import java.util.ArrayList;
import java.util.Objects;
import net.Indyuce.mmoitems.stat.data.StringData;
import net.Indyuce.mmoitems.stat.data.type.Mergeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameData
extends StringData
implements Mergeable<NameData> {
    @NotNull
    ArrayList<String> prefixes = new ArrayList();
    @NotNull
    ArrayList<String> suffixes = new ArrayList();

    public NameData(@Nullable String string) {
        super(string);
    }

    public void readPrefixes(@Nullable ItemTag tag) {
        if (tag == null) {
            return;
        }
        for (String str : ItemTag.getStringListFromTag((ItemTag)tag)) {
            if (str == null) continue;
            this.addPrefix(str);
        }
    }

    public void readSuffixes(@Nullable ItemTag tag) {
        if (tag == null) {
            return;
        }
        for (String str : ItemTag.getStringListFromTag((ItemTag)tag)) {
            if (str == null) continue;
            this.addSuffix(str);
        }
    }

    public boolean hasMainName() {
        return this.getString() != null && !this.getString().isEmpty();
    }

    @NotNull
    public String getMainName() {
        return Objects.requireNonNullElse(this.getString(), "");
    }

    public boolean hasPrefixes() {
        return this.prefixes.size() > 0;
    }

    public boolean hasSuffixes() {
        return this.suffixes.size() > 0;
    }

    @NotNull
    public String bake() {
        StringBuilder sb = new StringBuilder();
        for (String prefix : this.getPrefixes()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(prefix);
        }
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(this.getMainName());
        for (String suffix : this.getSuffixes()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(suffix);
        }
        return sb.toString();
    }

    @NotNull
    public String bakePrefix() {
        StringBuilder sb = new StringBuilder();
        for (String prefix : this.getPrefixes()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(prefix);
        }
        return sb.toString();
    }

    @NotNull
    public String bakeSuffix() {
        StringBuilder sb = new StringBuilder();
        for (String suffix : this.getSuffixes()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(suffix);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.bake();
    }

    @NotNull
    public ItemTag compressPrefixes(@NotNull String path) {
        return ItemTag.fromStringList((String)path, this.getPrefixes());
    }

    @NotNull
    public ItemTag compressSuffixes(@NotNull String path) {
        return ItemTag.fromStringList((String)path, this.getSuffixes());
    }

    public void addPrefix(@NotNull String str) {
        this.prefixes.add(str);
    }

    public void clearPrefixes() {
        this.prefixes.clear();
    }

    @NotNull
    public ArrayList<String> getPrefixes() {
        return this.prefixes;
    }

    public void addSuffix(@NotNull String str) {
        this.suffixes.add(str);
    }

    public void clearSuffixes() {
        this.suffixes.clear();
    }

    @NotNull
    public ArrayList<String> getSuffixes() {
        return this.suffixes;
    }

    @Override
    public void mergeWith(NameData data) {
        if (data.hasMainName()) {
            this.setString(data.getString());
        }
        for (String p : data.getPrefixes()) {
            this.addPrefix(p);
        }
        for (String p : data.getSuffixes()) {
            this.addSuffix(p);
        }
    }

    @Override
    @NotNull
    public NameData clone() {
        NameData c = new NameData(this.getString());
        for (String p : this.getPrefixes()) {
            c.addPrefix(p);
        }
        for (String p : this.getSuffixes()) {
            c.addSuffix(p);
        }
        return c;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.prefixes.isEmpty() && this.suffixes.isEmpty();
    }
}

