/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmoitems.stat.type;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.item.SupportedNBTTagValues;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackMessage;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackPalette;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.PlusMinusPercent;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.manager.StatManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.UpgradeTemplate;
import net.Indyuce.mmoitems.api.edition.StatEdition;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.api.item.mmoitem.ReadMMOItem;
import net.Indyuce.mmoitems.api.util.NumericStatFormula;
import net.Indyuce.mmoitems.api.util.message.FFPMMOItems;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.DoubleData;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.data.type.UpgradeInfo;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.Previewable;
import net.Indyuce.mmoitems.stat.type.StatHistory;
import net.Indyuce.mmoitems.stat.type.Upgradable;
import net.Indyuce.mmoitems.util.MMOUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleStat
extends ItemStat<NumericStatFormula, DoubleData>
implements Upgradable,
Previewable<NumericStatFormula, DoubleData> {
    private final boolean moreIsBetter;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.####");

    public DoubleStat(String id, Material mat, String name, String[] lore) {
        this(id, mat, name, lore, new String[]{"!miscellaneous", "!block", "all"}, true, new Material[0]);
    }

    public DoubleStat(String id, Material mat, String name, String lore) {
        this(id, mat, name, MMOUtils.trimString(50, lore), new String[]{"!miscellaneous", "!block", "all"}, true, new Material[0]);
    }

    public DoubleStat(String id, Material mat, String name, String[] lore, String[] types, Material ... materials) {
        this(id, mat, name, lore, types, true, materials);
    }

    public DoubleStat(String id, Material mat, String name, String[] lore, String[] types, boolean moreIsBetter, Material ... materials) {
        super(id, mat, name, lore, types, materials);
        this.moreIsBetter = moreIsBetter;
    }

    public boolean handleNegativeStats() {
        return true;
    }

    public double multiplyWhenDisplaying() {
        return 1.0;
    }

    public boolean moreIsBetter() {
        return this.moreIsBetter;
    }

    @Override
    public NumericStatFormula whenInitialized(Object object) {
        if (object instanceof Number) {
            return new NumericStatFormula(Double.parseDouble(object.toString()), 0.0, 0.0, 0.0);
        }
        if (object instanceof ConfigurationSection) {
            return new NumericStatFormula(object);
        }
        throw new IllegalArgumentException("Must specify a number or a config section");
    }

    @Override
    public void whenApplied(@NotNull ItemStackBuilder item, @NotNull DoubleData data) {
        StatHistory hist;
        double value = data.getValue();
        if (value < 0.0 && !this.handleNegativeStats()) {
            return;
        }
        double upgradeShift = 0.0;
        if (UpgradeTemplate.isDisplayingUpgrades() && item.getMMOItem().getUpgradeLevel() != 0 && (hist = item.getMMOItem().getStatHistory(this)) != null) {
            DoubleData uData = (DoubleData)hist.recalculateUnupgraded();
            upgradeShift = value - uData.getValue();
        }
        if (value != 0.0 || upgradeShift != 0.0) {
            String loreInsert = DoubleStat.formatPath(this.getId(), this.getGeneralStatFormat(), this.moreIsBetter, value * this.multiplyWhenDisplaying());
            if (upgradeShift != 0.0) {
                loreInsert = loreInsert + UpgradeTemplate.getUpgradeChangeSuffix(DoubleStat.plus(true, upgradeShift * this.multiplyWhenDisplaying()) + MythicLib.plugin.getMMOConfig().decimals.format(upgradeShift * this.multiplyWhenDisplaying()), !this.isGood(upgradeShift * this.multiplyWhenDisplaying()));
            }
            item.getLore().insert(this.getPath(), loreInsert);
        }
        if (data.getValue() != 0.0) {
            item.addItemTag(this.getAppliedNBT(data));
        }
    }

    @Deprecated
    public static String formatPath(@NotNull String format, boolean moreIsBetter, double value) {
        return DoubleStat.formatPath("ATTACK_DAMAGE", format, moreIsBetter, value);
    }

    @Deprecated
    public static String formatPath(@NotNull String format, boolean moreIsBetter, double min, double max) {
        return DoubleStat.formatPath("ATTACK_DAMAGE", format, moreIsBetter, min, max);
    }

    @NotNull
    public static String formatPath(@NotNull String stat, @NotNull String format, boolean moreIsBetter, double value) {
        return DoubleStat.formatPath(stat, format, moreIsBetter, true, value);
    }

    @NotNull
    public static String formatPath(@NotNull String stat, @NotNull String format, boolean moreIsBetter, boolean displayPlus, double value) {
        String valueFormatted = StatManager.format((String)stat, (double)value);
        String colorPrefix = DoubleStat.getColorPrefix(value < 0.0 && moreIsBetter);
        return format.replace("{value}", colorPrefix + valueFormatted).replace("<plus>", colorPrefix + DoubleStat.plus(displayPlus, value));
    }

    @NotNull
    public static String formatPath(@NotNull String stat, @NotNull String format, boolean moreIsBetter, double min, double max) {
        return DoubleStat.formatPath(stat, format, moreIsBetter, true, min, max);
    }

    @NotNull
    public static String formatPath(@NotNull String stat, @NotNull String format, boolean moreIsBetter, boolean displayPlus, double min, double max) {
        if (SilentNumbers.round((double)min, (int)2) == SilentNumbers.round((double)max, (int)2)) {
            return DoubleStat.formatPath(stat, format, moreIsBetter, displayPlus, min);
        }
        String minFormatted = DoubleStat.plus(displayPlus, min) + StatManager.format((String)stat, (double)min);
        String maxFormatted = (displayPlus && min < 0.0 && max > 0.0 ? "+" : "") + StatManager.format((String)stat, (double)max);
        String minPrefix = DoubleStat.getColorPrefix(min < 0.0 && moreIsBetter);
        String maxPrefix = DoubleStat.getColorPrefix(max < 0.0 && moreIsBetter);
        return format.replace("<plus>", "").replace("{value}", minPrefix + minFormatted + MMOItems.plugin.getConfig().getString("stats-displaying.range-dash", "\u2393") + maxPrefix + maxFormatted);
    }

    @NotNull
    private static String getColorPrefix(boolean isNegative) {
        return MMOItems.plugin.getConfig().getString("stats-displaying.color-" + (isNegative ? "negative" : "positive"), "");
    }

    @NotNull
    private static String plus(boolean displayPlus, double amount) {
        return displayPlus && amount > 0.0 ? "+" : "";
    }

    @Override
    public void whenPreviewed(@NotNull ItemStackBuilder item, @NotNull DoubleData currentData, @NotNull NumericStatFormula templateData) throws IllegalArgumentException {
        Validate.isTrue((boolean)(currentData instanceof DoubleData), (String)"Current Data is not Double Data");
        Validate.isTrue((boolean)(templateData instanceof NumericStatFormula), (String)"Template Data is not Numeric Stat Formula");
        double techMinimum = templateData.calculate(0.0, NumericStatFormula.FormulaInputType.LOWER_BOUND);
        double techMaximum = templateData.calculate(0.0, NumericStatFormula.FormulaInputType.UPPER_BOUND);
        if (techMaximum < 0.0 && !this.handleNegativeStats()) {
            return;
        }
        if (techMinimum < 0.0 && !this.handleNegativeStats()) {
            techMinimum = 0.0;
        }
        item.addItemTag(this.getAppliedNBT(currentData));
        if (techMinimum != 0.0 || techMaximum != 0.0) {
            String builtRange = DoubleStat.formatPath(this.getId(), this.getGeneralStatFormat(), this.moreIsBetter(), techMinimum * this.multiplyWhenDisplaying(), techMaximum * this.multiplyWhenDisplaying());
            item.getLore().insert(this.getPath(), builtRange);
        }
    }

    public boolean isGood(double amount) {
        return this.moreIsBetter() ? amount >= 0.0 : amount <= 0.0;
    }

    @Override
    @NotNull
    public ArrayList<ItemTag> getAppliedNBT(@NotNull DoubleData data) {
        ArrayList<ItemTag> ret = new ArrayList<ItemTag>();
        ret.add(new ItemTag(this.getNBTPath(), (Object)data.getValue()));
        return ret;
    }

    @Override
    public void whenLoaded(@NotNull ReadMMOItem mmoitem) {
        StatData bakedData;
        ArrayList<ItemTag> relevantTags = new ArrayList<ItemTag>();
        if (mmoitem.getNBT().hasTag(this.getNBTPath())) {
            relevantTags.add(ItemTag.getTagAtPath((String)this.getNBTPath(), (NBTItem)mmoitem.getNBT(), (SupportedNBTTagValues)SupportedNBTTagValues.DOUBLE));
        }
        if ((bakedData = this.getLoadedNBT((ArrayList)relevantTags)) != null) {
            mmoitem.setData(this, bakedData);
        }
    }

    @Override
    @Nullable
    public DoubleData getLoadedNBT(@NotNull ArrayList<ItemTag> storedTags) {
        ItemTag tg = ItemTag.getTagAtPath((String)this.getNBTPath(), storedTags);
        if (tg != null) {
            return new DoubleData(SilentNumbers.round((double)((Double)tg.getValue()), (int)4));
        }
        return null;
    }

    @Override
    public void whenClicked(@NotNull EditionInventory inv, @NotNull InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.PICKUP_HALF) {
            inv.getEditedSection().set(this.getPath(), null);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + "Successfully removed " + this.getName() + ChatColor.GRAY + ".");
            return;
        }
        new StatEdition(inv, this, new Object[0]).enable("Write in the chat the numeric value you want.", "Second Format: {Base} {Scaling Value} {Spread} {Max Spread} {Hard Min} {Hard Max}", "Third Format: {Min Value} -> {Max Value}");
    }

    @Override
    public void whenInput(@NotNull EditionInventory inv, @NotNull String message, Object ... info) {
        NumericStatFormula formula = new NumericStatFormula(message);
        formula.fillConfigurationSection(inv.getEditedSection(), this.getPath(), NumericStatFormula.FormulaSaveOption.DELETE_IF_ZERO);
        inv.registerTemplateEdition();
        inv.getPlayer().sendMessage(MMOItems.plugin.getPrefix() + this.getName() + " successfully changed to {" + formula.getBase() + " - " + formula.getScale() + " - " + formula.getSpread() + " - " + formula.getMaxSpread() + " - (" + formula.getMin() + " -> " + formula.getMax() + ") }");
    }

    @Override
    public void whenDisplayed(List<String> lore, Optional<NumericStatFormula> statData) {
        if (statData.isPresent()) {
            NumericStatFormula data = statData.get();
            if (data.isUniform()) {
                lore.add(ChatColor.GRAY + "Uniform: " + ChatColor.GREEN + DECIMAL_FORMAT.format(data.getMin()) + ChatColor.GRAY + " -> " + ChatColor.GREEN + DECIMAL_FORMAT.format(data.getMax()));
            } else {
                lore.add(ChatColor.GRAY + "Base Value: " + ChatColor.GREEN + DECIMAL_FORMAT.format(data.getBase()) + (data.getScale() != 0.0 ? ChatColor.GRAY + " (+" + ChatColor.GREEN + DECIMAL_FORMAT.format(data.getScale()) + ChatColor.GRAY + "/Lvl)" : ""));
                if (data.getSpread() > 0.0) {
                    lore.add(ChatColor.GRAY + "Spread: " + ChatColor.GREEN + DECIMAL_FORMAT.format(data.getSpread() * 100.0) + "%" + ChatColor.GRAY + " (Max: " + ChatColor.GREEN + DECIMAL_FORMAT.format(data.getMaxSpread() * 100.0) + "%" + ChatColor.GRAY + ")");
                }
                if (data.hasMin()) {
                    lore.add(ChatColor.GRAY + "Min: " + ChatColor.GREEN + DECIMAL_FORMAT.format(data.getMin()));
                }
                if (data.hasMax()) {
                    lore.add(ChatColor.GRAY + "Max: " + ChatColor.GREEN + DECIMAL_FORMAT.format(data.getMax()));
                }
            }
        } else {
            lore.add(ChatColor.GRAY + "Current Value: " + ChatColor.GREEN + "---");
        }
        lore.add("");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Left click to change this value.");
        lore.add(ChatColor.YELLOW + "\u25ba" + " Right click to remove this value.");
    }

    @Override
    @NotNull
    public DoubleData getClearStatData() {
        return new DoubleData(0.0);
    }

    @Override
    @NotNull
    public UpgradeInfo loadUpgradeInfo(@Nullable Object obj) throws IllegalArgumentException {
        return DoubleUpgradeInfo.GetFrom(obj);
    }

    @Override
    @NotNull
    public StatData apply(@NotNull StatData original, @NotNull UpgradeInfo info, int level) {
        if (original instanceof DoubleData && info instanceof DoubleUpgradeInfo) {
            int i;
            double value = ((DoubleData)original).getValue();
            if (i > 0) {
                for (i = level; i > 0; --i) {
                    value = ((DoubleUpgradeInfo)info).getPMP().apply(value);
                }
            } else if (i < 0) {
                while (i < 0) {
                    value = ((DoubleUpgradeInfo)info).getPMP().reverse(value);
                    ++i;
                }
            }
            ((DoubleData)original).setValue(value);
        }
        return original;
    }

    public static class DoubleUpgradeInfo
    implements UpgradeInfo {
        @NotNull
        PlusMinusPercent pmp;

        @NotNull
        public static DoubleUpgradeInfo GetFrom(@Nullable Object obj) throws IllegalArgumentException {
            Validate.notNull((Object)obj, (String)FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Upgrade operation must not be null", (String[])new String[0]));
            String str = obj.toString();
            if (str.isEmpty()) {
                throw new IllegalArgumentException(FriendlyFeedbackProvider.quickForConsole((FriendlyFeedbackPalette)FFPMMOItems.get(), (String)"Upgrade operation is empty", (String[])new String[0]));
            }
            char c = str.charAt(0);
            if (c == 's') {
                str = str.substring(1);
            } else if (c != '+' && c != '-' && c != 'n') {
                str = '+' + str;
            }
            FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider((FriendlyFeedbackPalette)FFPMMOItems.get());
            PlusMinusPercent pmpRead = PlusMinusPercent.getFromString((String)str, (FriendlyFeedbackProvider)ffp);
            if (pmpRead == null) {
                throw new IllegalArgumentException(((FriendlyFeedbackMessage)ffp.getFeedbackOf(FriendlyFeedbackCategory.ERROR).get(0)).forConsole(ffp.getPalette()));
            }
            return new DoubleUpgradeInfo(pmpRead);
        }

        public DoubleUpgradeInfo(@NotNull PlusMinusPercent pmp) {
            this.pmp = pmp;
        }

        @NotNull
        public PlusMinusPercent getPMP() {
            return this.pmp;
        }
    }
}

